/*
 * Decompiled with CFR 0.152.
 */
package pams.function.guangzhou.port.control;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.common.util.Page;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import pams.function.guangzhou.common.bean.PageResponseBean;
import pams.function.guangzhou.common.control.CommonControl;
import pams.function.guangzhou.common.exception.GuangzhouException;
import pams.function.guangzhou.port.bean.ApplyInfoBean;
import pams.function.guangzhou.port.bean.PortInfoBean;
import pams.function.guangzhou.port.bean.QueryApplyBean;
import pams.function.guangzhou.port.bean.QueryPortBean;
import pams.function.guangzhou.port.entity.ApplyInfo;
import pams.function.guangzhou.port.service.PortService;

@Controller
@Scope(value="session")
public class PortControl
extends CommonControl {
    @Autowired
    private PortService portService;
    private static Logger log = LoggerFactory.getLogger(PortControl.class);

    @RequestMapping(value={"/port/portControl/approvalList.do"})
    public String approvalList() {
        return "port/default/approvalList";
    }

    @RequestMapping(value={"/port/portControl/applyList.do"})
    public String applyList() {
        return "port/default/applyList";
    }

    @RequestMapping(value={"/port/portControl/startApply.do"})
    public String startApply() {
        return "port/default/startApply";
    }

    @RequestMapping(value={"/port/portControl/applyInfo.do"})
    public String applyInfo() {
        return "port/default/applyInfo";
    }

    @RequestMapping(value={"/port/portControl/portList.do"})
    public String portList() {
        return "port/default/portList";
    }

    @RequestMapping(value={"/port/portControl/saveApply.do"}, method={RequestMethod.POST})
    public void saveApply(@RequestBody String param, HttpServletRequest request, HttpServletResponse response) {
        ApplyInfoBean applyInfoBean = null;
        try {
            if (!StringUtils.isNotBlank((CharSequence)param)) {
                super.writeResponseBeanWrong(response, log, "\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a");
                return;
            }
            applyInfoBean = (ApplyInfoBean)JSON.parseObject((String)param, ApplyInfoBean.class);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5165\u53c2\u5931\u8d25", (Throwable)e);
            super.writeResponseBeanWrong(response, log, e.getMessage());
        }
        applyInfoBean.setCreatorId(this.person.getId());
        String applyId = null;
        try {
            applyId = this.portService.saveApplyInfoBean(applyInfoBean);
        }
        catch (GuangzhouException e) {
            log.error("\u4fdd\u5b58\u7533\u8bf7\u5355\u5931\u8d25", (Throwable)e);
            super.writeResponseBeanWrong(response, log, e.getMessage());
            return;
        }
        log.debug("\u4fdd\u5b58\u7684\u7533\u8bf7\u5355id\u4e3a:{}", (Object)applyId);
        super.writeResponseBeanSuccess(response, log, applyId);
    }

    @RequestMapping(value={"/port/portControl/getApplyInfo.do"})
    public void getApplyInfo(HttpServletRequest request, HttpServletResponse response, ApplyInfoBean applyInfoBean) {
        this.forgePerson(request);
        log.debug("getApplyInfo(), \u5165\u53c2applyInfoBean:{}", (Object)JSON.toJSONString((Object)applyInfoBean));
        ApplyInfoBean applyInfoBeanResult = this.portService.getApplyInfoBean(applyInfoBean.getApplyId());
        super.writeResponseBeanSuccess(response, log, applyInfoBeanResult);
    }

    @RequestMapping(value={"/port/portControl/getApplyList.do"})
    public void getApplyList(HttpServletRequest request, HttpServletResponse response, QueryApplyBean queryApplyBean) {
        this.forgePerson(request);
        if (queryApplyBean == null) {
            queryApplyBean = new QueryApplyBean();
        }
        queryApplyBean.setCreatorId(this.person.getId());
        log.debug("getApplyList(), queryApplyBean:{}", (Object)JSON.toJSONString((Object)queryApplyBean));
        Page page = new Page(queryApplyBean.getPage().intValue(), queryApplyBean.getPageSize().intValue());
        List<ApplyInfo> applyInfoList = this.portService.queryApplyInfoList(queryApplyBean, page);
        PageResponseBean<ApplyInfo> pageResponseBean = new PageResponseBean<ApplyInfo>();
        pageResponseBean.setTotal(page.getTotal());
        pageResponseBean.setRows(applyInfoList);
        super.writePageResponseBeanSuccess(response, log, pageResponseBean);
    }

    @RequestMapping(value={"/port/portControl/getAuditList.do"})
    public void getAuditList(HttpServletRequest request, HttpServletResponse response, QueryApplyBean queryApplyBean) {
        this.forgePerson(request);
        log.debug("getAuditList(), queryApplyBean:{}", (Object)JSON.toJSONString((Object)queryApplyBean));
        Page page = new Page(queryApplyBean.getPage().intValue(), queryApplyBean.getPageSize().intValue());
        List<ApplyInfo> applyInfoBeanList = this.portService.queryApplyInfoList(queryApplyBean, page);
        PageResponseBean<ApplyInfo> pageResponseBean = new PageResponseBean<ApplyInfo>();
        pageResponseBean.setTotal(page.getTotal());
        pageResponseBean.setRows(applyInfoBeanList);
        super.writePageResponseBeanSuccess(response, log, pageResponseBean);
    }

    @RequestMapping(value={"/port/portControl/getPortList.do"})
    public void getPortList(HttpServletRequest request, HttpServletResponse response, QueryPortBean queryPortBean) {
        this.forgePerson(request);
        if (queryPortBean == null) {
            queryPortBean = new QueryPortBean();
        }
        queryPortBean.setCreatorId(this.person.getId());
        log.debug("getPortList(), queryPortBean:{}", (Object)JSON.toJSONString((Object)queryPortBean));
        Page page = new Page(queryPortBean.getPage().intValue(), queryPortBean.getPageSize().intValue());
        List<PortInfoBean> portInfoBeanList = this.portService.queryPortInfoBeanList(queryPortBean, page);
        PageResponseBean<PortInfoBean> pageResponseBean = new PageResponseBean<PortInfoBean>();
        pageResponseBean.setTotal(page.getTotal());
        pageResponseBean.setRows(portInfoBeanList);
        super.writePageResponseBeanSuccess(response, log, pageResponseBean);
    }

    @RequestMapping(value={"/port/portControl/saveAudit.do"}, method={RequestMethod.POST})
    public void saveAudit(@RequestBody String param, HttpServletRequest request, HttpServletResponse response) {
        ApplyInfoBean applyInfoBean = null;
        try {
            if (!StringUtils.isNotBlank((CharSequence)param)) {
                super.writeResponseBeanWrong(response, log, "\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a");
                return;
            }
            applyInfoBean = (ApplyInfoBean)JSON.parseObject((String)param, ApplyInfoBean.class);
            this.portService.saveAudit(applyInfoBean);
        }
        catch (GuangzhouException e) {
            log.error("\u5ba1\u6279\u7533\u8bf7\u5355\u5931\u8d25", (Throwable)e);
            super.writeResponseBeanWrong(response, log, e.getMessage());
            return;
        }
        super.writeResponseBeanSuccess(response, log, null);
    }
}

