/*
 * Decompiled with CFR 0.152.
 */
package pams.function.guangzhou.port.service.impl;

import com.xdja.pams.common.util.Page;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.guangzhou.common.exception.GuangzhouException;
import pams.function.guangzhou.port.bean.ApplyInfoBean;
import pams.function.guangzhou.port.bean.AuditStatusEnum;
import pams.function.guangzhou.port.bean.PortInfoBean;
import pams.function.guangzhou.port.bean.QueryApplyBean;
import pams.function.guangzhou.port.bean.QueryPortBean;
import pams.function.guangzhou.port.bean.RolePerson;
import pams.function.guangzhou.port.dao.PortDao;
import pams.function.guangzhou.port.entity.ApplyInfo;
import pams.function.guangzhou.port.entity.AttachmentInfo;
import pams.function.guangzhou.port.entity.PortInfo;
import pams.function.guangzhou.port.service.PortCheckService;
import pams.function.guangzhou.port.service.PortService;

@Service
public class PortServiceImpl
implements PortService {
    @Autowired
    private PortDao portDao;
    @Autowired
    private PortCheckService portCheckService;
    private static Logger log = LoggerFactory.getLogger(PortServiceImpl.class);

    @Override
    @Transactional
    public String saveApplyInfoBean(ApplyInfoBean applyInfoBean) throws GuangzhouException {
        long time = System.currentTimeMillis();
        this.portCheckService.checkSaveApplyInfoBean(applyInfoBean);
        ApplyInfo dbApplyInfo = null;
        if (StringUtils.isNotBlank((CharSequence)applyInfoBean.getApplyId())) {
            dbApplyInfo = this.portDao.getApplyInfo(applyInfoBean.getApplyId());
        }
        if (dbApplyInfo != null) {
            this.portDao.deleteAttachmentInfoByApplyId(applyInfoBean.getApplyId());
            this.portDao.deletePortInfoByApplyId(applyInfoBean.getApplyId());
            this.portDao.deleteApplyInfo(dbApplyInfo);
        }
        ApplyInfo applyInfo = new ApplyInfo();
        BeanUtils.copyProperties((Object)applyInfoBean, (Object)applyInfo);
        applyInfo.setAuditStatus(AuditStatusEnum.INIT.getStatus());
        applyInfo.setApplyTime(time);
        String applyId = this.portDao.addApplyInfo(applyInfo);
        log.debug("\u4fdd\u5b58\u5b8c\u7533\u8bf7\u57fa\u672c\u4fe1\u606f,applyId:{}", (Object)applyId);
        if (!CollectionUtils.isEmpty(applyInfoBean.getIntranetPortList())) {
            for (PortInfo portInfo : applyInfoBean.getIntranetPortList()) {
                portInfo.setApplyId(applyId);
                portInfo.setType("intranet");
                this.portDao.addPortInfo(portInfo);
            }
        }
        log.debug("\u4fdd\u5b58\u5b8c\u7533\u8bf7\u4e2d\u7684\u5185\u7f51\u5217\u8868");
        if (!CollectionUtils.isEmpty(applyInfoBean.getOuternetPortList())) {
            for (PortInfo portInfo : applyInfoBean.getOuternetPortList()) {
                portInfo.setApplyId(applyId);
                portInfo.setType("outernet");
                this.portDao.addPortInfo(portInfo);
            }
        }
        log.debug("\u4fdd\u5b58\u5b8c\u7533\u8bf7\u4e2d\u7684\u5916\u7f51\u5217\u8868");
        if (!CollectionUtils.isEmpty(applyInfoBean.getAttachmentList())) {
            for (AttachmentInfo attachmentInfo : applyInfoBean.getAttachmentList()) {
                attachmentInfo.setApplyId(applyId);
                this.portDao.addAttachmentInfo(attachmentInfo);
            }
        }
        log.debug("\u4fdd\u5b58\u5b8c\u9644\u4ef6");
        return applyId;
    }

    @Override
    public ApplyInfoBean getApplyInfoBean(String applyId) {
        List<AttachmentInfo> attachmentInfoList;
        ApplyInfo applyInfo = this.portDao.getApplyInfo(applyId);
        if (applyInfo == null) {
            log.debug("applyId:{},\u672a\u67e5\u5230\u7533\u8bf7\u5355", (Object)applyId);
            return null;
        }
        ApplyInfoBean applyInfoBean = new ApplyInfoBean();
        BeanUtils.copyProperties((Object)applyInfo, (Object)applyInfoBean);
        List<PortInfo> portInfoList = this.portDao.queryPortInfoList(applyId);
        if (!CollectionUtils.isEmpty(portInfoList)) {
            for (PortInfo portInfo : portInfoList) {
                if ("intranet".equals(portInfo.getType())) {
                    applyInfoBean.getIntranetPortList().add(portInfo);
                    continue;
                }
                applyInfoBean.getOuternetPortList().add(portInfo);
            }
        }
        if (!CollectionUtils.isEmpty(attachmentInfoList = this.portDao.queryAttachmentInfoList(applyId))) {
            applyInfoBean.getAttachmentList().addAll(attachmentInfoList);
        }
        return applyInfoBean;
    }

    @Override
    public List<ApplyInfo> queryApplyInfoList(QueryApplyBean queryAppBean, Page page) {
        List<ApplyInfo> applyInfoList = this.portDao.queryApplyInfoList(queryAppBean, page);
        return applyInfoList;
    }

    @Override
    public List<PortInfoBean> queryPortInfoBeanList(QueryPortBean queryPortBean, Page page) {
        boolean isProvinceManager = false;
        List<RolePerson> rolePersonList = this.portDao.getRolePersonList(queryPortBean.getCreatorId());
        if (!CollectionUtils.isEmpty(rolePersonList)) {
            for (RolePerson rolePerson : rolePersonList) {
                if (!"5".equals(rolePerson.getRoleId()) && !"40288cef41a15e770141a15e870f0002".equals(rolePerson.getRoleId())) continue;
                log.debug("\u662f\u7701\u5385\u7ba1\u7406\u5458\u6216\u8d85\u7ea7\u7ba1\u7406\u5458,personId:{}", (Object)queryPortBean.getCreatorId());
                isProvinceManager = true;
                break;
            }
        }
        if (isProvinceManager) {
            queryPortBean.setCreatorId(null);
        }
        List<PortInfoBean> portInfoBeanList = this.portDao.queryPortInfoBeanList(queryPortBean, page);
        return portInfoBeanList;
    }

    @Override
    @Transactional
    public void saveAudit(ApplyInfoBean applyInfoBean) throws GuangzhouException {
        this.portCheckService.checkAuditApplyInfoBean(applyInfoBean);
        ApplyInfo applyInfo = this.portDao.getApplyInfo(applyInfoBean.getApplyId());
        if (applyInfo == null) {
            log.error("\u65e0\u6548\u7684applyId\u3002applyId:{}", (Object)applyInfo.getApplyId());
            throw new GuangzhouException("\u65e0\u6548\u7684applyId");
        }
        if (applyInfo.getAuditStatus().intValue() == AuditStatusEnum.PASS.getStatus().intValue()) {
            log.error("\u7533\u8bf7\u5355\u5df2\u901a\u8fc7\u5ba1\u6279\uff0c\u65e0\u9700\u518d\u6b21\u5ba1\u6279\u3002applyId:{}", (Object)applyInfo.getApplyId());
            throw new GuangzhouException("\u7533\u8bf7\u5355\u5df2\u901a\u8fc7\u5ba1\u6279\uff0c\u65e0\u9700\u518d\u6b21\u5ba1\u6279");
        }
        this.portDao.deletePortInfoByApplyId(applyInfoBean.getApplyId());
        for (PortInfo portInfo : applyInfoBean.getIntranetPortList()) {
            portInfo.setApplyId(applyInfo.getApplyId());
            portInfo.setType("intranet");
            this.portDao.addPortInfo(portInfo);
        }
        for (PortInfo portInfo : applyInfoBean.getOuternetPortList()) {
            portInfo.setApplyId(applyInfo.getApplyId());
            portInfo.setType("outernet");
            this.portDao.addPortInfo(portInfo);
        }
        applyInfo.setKxcAuditOpinion(applyInfoBean.getKxcAuditOpinion());
        applyInfo.setAuditStatus(applyInfoBean.getAuditStatus());
        applyInfo.setAuditTime(System.currentTimeMillis());
        this.portDao.updateApplyInfo(applyInfo);
    }
}

