/*
 * Decompiled with CFR 0.152.
 */
package pams.function.lasa.service;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.lasa.util.MsgMaker;

@Service
public class LasaSyncServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(LasaSyncServiceImpl.class);
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private DeviceService deviceService;
    private static final String OPT_TYPE_A = "A";
    private static final String OPT_TYPE_U = "U";
    private static final String OPT_TYPE_D = "D";

    @Transactional
    public String synchroUser(String xml) {
        List entrys;
        String type;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("synchroUser\u4fe1\u606f\u53c2\u6570:{}", (Object)xml);
        }
        if (Strings.isEmpty((String)xml)) {
            return MsgMaker.makeResult("1", "\u53c2\u6570\u5f02\u5e38");
        }
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            if (doc == null) {
                LOGGER.info("\u89e3\u6790xml\u5931\u8d25");
                return MsgMaker.makeResult("1", "\u89e3\u6790\u5f02\u5e38");
            }
            type = this.getType(doc);
            entrys = this.getEntrys(doc);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u89e3\u6790\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            } else {
                LOGGER.error("\u89e3\u6790\u5931\u8d25:{}", (Object)e.getMessage());
            }
            return MsgMaker.makeResult("1", "\u64cd\u4f5c\u5931\u8d25");
        }
        LOGGER.debug("\u64cd\u4f5c\u7c7b\u578b:{}", (Object)type);
        if (!(OPT_TYPE_D.equals(type) || OPT_TYPE_U.equals(type) || OPT_TYPE_A.equals(type))) {
            return MsgMaker.makeResult("1", "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
        try {
            for (int i = 0; i < entrys.size(); ++i) {
                Element entry = (Element)entrys.get(i);
                Person person = this.parsePerson(entry);
                this.resolvePerson(person, type);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw new RuntimeException(e.getMessage());
            }
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
        }
        return MsgMaker.makeResult("0", "\u64cd\u4f5c\u6210\u529f");
    }

    @Transactional
    public String synchroUnit(String xml) {
        List entrys;
        String type;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("synchroUnit\u53c2\u6570\u4fe1\u606f:{}", (Object)xml);
        }
        if (Strings.isEmpty((String)xml)) {
            return MsgMaker.makeResult("1", "\u53c2\u6570\u5f02\u5e38");
        }
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            if (doc == null) {
                LOGGER.info("\u89e3\u6790xml\u5931\u8d25");
                return MsgMaker.makeResult("1", "\u89e3\u6790\u5f02\u5e38");
            }
            type = this.getType(doc);
            entrys = this.getEntrys(doc);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u89e3\u6790\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            } else {
                LOGGER.error("\u89e3\u6790\u5931\u8d25:{}", (Object)e.getMessage());
            }
            return MsgMaker.makeResult("1", "\u64cd\u4f5c\u5931\u8d25");
        }
        LOGGER.debug("\u64cd\u4f5c\u7c7b\u578b:{}", (Object)type);
        try {
            ArrayList<Department> deps = new ArrayList<Department>();
            for (int i = 0; i < entrys.size(); ++i) {
                Element entry = (Element)entrys.get(i);
                deps.add(this.parseDep(entry));
            }
            for (Department d : deps) {
                this.resolveDep1(d, type);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw new RuntimeException(e.getMessage());
            }
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
        }
        return MsgMaker.makeResult("0", "\u64cd\u4f5c\u6210\u529f");
    }

    public String synchroRel(String xml) {
        return MsgMaker.makeResult("0", "\u64cd\u4f5c\u6210\u529f");
    }

    private String getType(Document document) {
        List elements = document.selectNodes("message/messageHead/OperateType");
        Element element = (Element)elements.get(0);
        return element.getTextTrim();
    }

    private List getEntrys(Document document) {
        return document.selectNodes("message/messageBody/entry");
    }

    private Person parsePerson(Element entry) {
        Department department;
        Person person = new Person();
        person.setName(this.getPropertieText(entry, "xm"));
        person.setCode(this.getPropertieText(entry, "jh"));
        person.setPassword(this.getPropertieText(entry, "dlmm"));
        List<Mobile> list = this.parseMobile(entry, person);
        if (!list.isEmpty()) {
            person.setMobiledList(list);
        }
        if ((department = this.depManageService.getDepartmentByCode(this.getPropertieText(entry, "ssdwdm"))) != null) {
            person.setDepartment(department);
            person.setDepCode(department.getCode());
            person.setDepId(department.getId());
        }
        person.setIdentifier(this.getPropertieText(entry, "sfzh"));
        person.setSex(this.getPropertieText(entry, "xb"));
        person.setOrderField(this.parseLong(this.getPropertieText(entry, "pxh"), 9999L));
        person.setNameBriefSpell(this.getPropertieText(entry, "xmjp"));
        String yhlx = this.getPropertieText(entry, "yhlx");
        if ("\u975e\u8b66\u5458".equals(yhlx) || "\u517c\u804c\u4eba\u5458".equals(yhlx)) {
            person.setPersonType("3");
        } else {
            person.setPersonType("1");
        }
        List positionList = this.commonCodePbService.queryByType("2011");
        for (CommonCode position : positionList) {
            if (!"\u5176\u4ed6".equals(position.getName())) continue;
            person.setPosition(position.getCode());
            break;
        }
        if (Strings.isEmpty((String)person.getPosition())) {
            person.setPosition("28");
        }
        List policeList = this.commonCodePbService.queryByType("2012");
        for (CommonCode police : policeList) {
            if (!"\u5176\u4ed6".equals(police.getName())) continue;
            person.setPolice(police.getCode());
            break;
        }
        if (Strings.isEmpty((String)person.getPolice())) {
            person.setPolice("22");
        }
        List leaderLevels = this.commonCodePbService.queryByType("grade");
        for (CommonCode ll : leaderLevels) {
            if (!ll.getName().contains("\u666e\u901a\u8b66\u5458")) continue;
            person.setPolice(ll.getCode());
            break;
        }
        if (Strings.isEmpty((String)person.getLeaderLevel())) {
            person.setLeaderLevel("3");
        }
        return person;
    }

    private List<Mobile> parseMobile(Element entry, Person person) {
        ArrayList<Mobile> list = new ArrayList<Mobile>();
        HashSet<String> mobileNos = new HashSet<String>();
        mobileNos.add(this.getPropertieText(entry, "lxdh"));
        mobileNos.add(this.getPropertieText(entry, "jtdh"));
        mobileNos.add(this.getPropertieText(entry, "ydhm"));
        mobileNos.add(this.getPropertieText(entry, "lthm"));
        mobileNos.add(this.getPropertieText(entry, "dxxlthm"));
        if (!mobileNos.isEmpty()) {
            for (String s : mobileNos) {
                Mobile mobile = new Mobile();
                mobile.setPerson(person);
                mobile.setMobile(s);
                list.add(mobile);
            }
        }
        return list;
    }

    private void updatePerson(Person localPerson, Person syncPerson) {
        localPerson.setDepId(syncPerson.getDepId());
        localPerson.setNameBriefSpell(syncPerson.getNameBriefSpell());
        localPerson.setOrderField(syncPerson.getOrderField());
        localPerson.setSex(syncPerson.getSex());
        localPerson.setIdentifier(syncPerson.getIdentifier());
        localPerson.setDepartment(syncPerson.getDepartment());
        localPerson.setMobiledList(syncPerson.getMobiledList());
        localPerson.setName(syncPerson.getName());
        localPerson.setCode(syncPerson.getCode());
        localPerson.setPassword(syncPerson.getPassword());
        localPerson.setCommType(syncPerson.getCommType());
        localPerson.setPersonType(syncPerson.getPersonType());
        localPerson.setPolice(syncPerson.getPolice());
        localPerson.setPosition(syncPerson.getPosition());
    }

    private void resolvePerson(Person person, String type) {
        Person localPerson;
        if (person == null) {
            return;
        }
        String allMobiles = this.getAllMobileString(person.getMobiledList());
        if (Strings.isEmpty((String)person.getCode())) {
            LOGGER.info("\u6ca1\u6709\u8b66\u53f7");
            throw new RuntimeException("\u6ca1\u6709\u8b66\u53f7");
        }
        if (Strings.isEmpty((String)person.getName())) {
            LOGGER.info("\u6ca1\u6709\u59d3\u540d");
            throw new RuntimeException("\u6ca1\u6709\u59d3\u540d");
        }
        if (Strings.isNotEmpty((String)person.getIdentifier())) {
            localPerson = this.userManageService.getUserByIdentifer(person.getIdentifier().toLowerCase());
            if (localPerson == null) {
                localPerson = this.userManageService.getUserByIdentifer(person.getIdentifier().toUpperCase());
            }
        } else {
            LOGGER.info("\u6ca1\u6709\u8eab\u4efd\u8bc1\u53f7");
            throw new RuntimeException(String.format("%s[%s]\u6ca1\u6709\u8eab\u4efd\u8bc1\u53f7", person.getName(), person.getCode()));
        }
        if (OPT_TYPE_A.equals(type)) {
            if (this.userManageService.checkCode(person.getCode())) {
                LOGGER.info("\u8b66\u53f7\u5df2\u7ecf\u5b58\u5728");
                throw new RuntimeException(String.format("%s[%s]-\u8b66\u53f7\u5df2\u7ecf\u5b58\u5728", person.getName(), person.getCode()));
            }
            String tmp = this.userManageService.checkMobileIsExist(allMobiles.split(","));
            if (tmp != null) {
                LOGGER.info("\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728");
                throw new RuntimeException(String.format("%s[%s]-\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728", person.getName(), person.getCode()));
            }
            if (this.userManageService.checkIdentifer(person.getIdentifier())) {
                LOGGER.info("\u8eab\u4efd\u8bc1\u53f7\u5df2\u7ecf\u5b58\u5728");
                throw new RuntimeException(String.format("%s[%s]-\u8eab\u4efd\u8bc1\u53f7\u5df2\u7ecf\u5b58\u5728", person.getName(), person.getCode()));
            }
            Department department = person.getDepartment();
            if (department == null) {
                LOGGER.info("\u6ca1\u6709\u90e8\u95e8");
                throw new RuntimeException(String.format("%s[%s]-\u6ca1\u6709\u90e8\u95e8&", person.getName(), person.getCode()));
            }
            this.userManageService.addUser(person);
        } else if (OPT_TYPE_U.equals(type)) {
            if (localPerson == null) {
                LOGGER.info("\u4eba\u5458\u4e0d\u5b58\u5728");
                throw new RuntimeException("\u4fee\u6539\u7684\u4eba\u5458\u4e0d\u5b58\u5728");
            }
            List<Mobile> mobiles = this.checkUpdateMobile(allMobiles.split(","), localPerson);
            if (this.userManageService.checkCode(person.getCode(), localPerson.getId())) {
                LOGGER.info("\u8b66\u53f7\u5df2\u7ecf\u5b58\u5728");
                throw new RuntimeException(String.format("%s[%s]-\u8b66\u53f7\u5df2\u7ecf\u5b58\u5728", person.getName(), person.getCode()));
            }
            if (this.userManageService.checkIdentifer(person.getIdentifier(), localPerson.getId())) {
                LOGGER.info("\u8eab\u4efd\u8bc1\u53f7\u5df2\u7ecf\u5b58\u5728");
                throw new RuntimeException(String.format("%s[%s]-\u8eab\u4efd\u8bc1\u53f7\u5df2\u7ecf\u5b58\u5728", person.getName(), person.getCode()));
            }
            Department department = person.getDepartment();
            if (department == null) {
                LOGGER.info("\u6ca1\u6709\u90e8\u95e8");
                throw new RuntimeException(String.format("%s[%s]-\u6ca1\u6709\u90e8\u95e8&", person.getName(), person.getCode()));
            }
            List oldMobileList = localPerson.getMobiledList();
            StringBuilder canNotDelMobiles = new StringBuilder();
            for (Mobile mobile : oldMobileList) {
                List devices = this.deviceService.getByMobile(mobile.getMobile());
                if (allMobiles.contains(mobile.getMobile()) || devices == null || devices.isEmpty()) continue;
                canNotDelMobiles.append(mobile.getMobile()).append(" ");
            }
            String cnm = canNotDelMobiles.toString();
            if (!"".equals(cnm)) {
                LOGGER.info("\u5df2\u7ecf\u7533\u8bf7\u8fc7\u5361\u7684\u624b\u673a\u53f7\u4e0d\u53ef\u5220\u9664");
                throw new RuntimeException("\u4e0b\u9762\u7684\u5df2\u7533\u8bf7\u8fc7\u5361\u7684\u624b\u673a\u53f7\u4e0d\u53ef\u5220\u9664\uff1a" + cnm);
            }
            localPerson.setMobiledList(mobiles);
            person.setId(localPerson.getId());
            this.updatePerson(localPerson, person);
            this.userManageService.updateUser(localPerson);
        } else if (OPT_TYPE_D.equals(type)) {
            if (localPerson == null) {
                LOGGER.info("\u5220\u9664\u7684\u4eba\u5458\u4e0d\u5b58\u5728");
                throw new RuntimeException("\u5220\u9664\u7684\u4eba\u5458\u4e0d\u5b58\u5728");
            }
            this.userManageService.delete(localPerson.getId());
        }
    }

    private List<Mobile> checkUpdateMobile(String[] mobiles, Person p) {
        String tmp = null;
        HashMap<String, String> mMap = new HashMap<String, String>();
        ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
        for (String m : mobiles) {
            if (Util.varCheckEmp((String)m)) continue;
            if (mMap.get(m) != null) {
                tmp = m;
                break;
            }
            mMap.put(m, m);
            Mobile tmpMobile = this.userManageService.getMobile(m);
            if (tmpMobile != null && !p.getId().equals(tmpMobile.getPerson().getId())) {
                tmp = m;
                break;
            }
            if (tmpMobile == null) {
                tmpMobile = new Mobile();
                tmpMobile.setMobile(m);
            }
            mobileList.add(tmpMobile);
        }
        if (tmp != null) {
            throw new RuntimeException("\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
        return mobileList;
    }

    private String getAllMobileString(List<Mobile> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                sb.append(list.get(i).getMobile());
                continue;
            }
            sb.append(",").append(list.get(i).getMobile());
        }
        return sb.toString();
    }

    private Department parseDep(Element entry) {
        Department department = new Department();
        department.setCode(this.getPropertieText(entry, "dwbm"));
        department.setName(this.getPropertieText(entry, "dwmc"));
        department.setNameAbbr(department.getName());
        Department parentDep = new Department();
        parentDep.setCode(this.getPropertieText(entry, "sjdwbm"));
        department.setParentDep(parentDep);
        department.setOrderField(this.parseLong(this.getPropertieText(entry, "pxh"), 999L));
        return department;
    }

    private void resolveDep1(Department d, String type) {
        String parentCode = d.getParentDep().getCode();
        Department local = this.depManageService.getDepartmentByCode(d.getCode());
        if (OPT_TYPE_A.equals(type)) {
            if (local != null) {
                LOGGER.info("\u90e8\u95e8\u5df2\u7ecf\u5b58\u5728");
                throw new RuntimeException(String.format("%s[%s]\u90e8\u95e8\u5df2\u7ecf\u5b58\u5728", d.getName(), d.getCode()));
            }
            if (Strings.isEmpty((String)parentCode)) {
                LOGGER.info("\u6ca1\u6709\u7236\u7ea7\u7f16\u7801");
                throw new RuntimeException(String.format("%s[%s]\u6ca1\u6709\u7236\u7ea7\u7f16\u7801", d.getName(), d.getCode()));
            }
            Department parent = this.getParent(parentCode);
            if (parent == null) {
                LOGGER.info("\u6ca1\u6709\u7236\u7ea7\u90e8\u95e8");
                throw new RuntimeException(String.format("%s[%s]\u6ca1\u6709\u7236\u7ea7\u5355\u4f4d", d.getName(), d.getCode()));
            }
            d.setParentDep(parent);
            this.depManageService.addDep(d);
        } else if (OPT_TYPE_U.equals(type)) {
            if (local == null) {
                LOGGER.info("\u90e8\u95e8\u4e0d\u5b58\u5728\u4e0d\u53ef\u4fee\u6539");
                throw new RuntimeException(String.format("%s[%s]\u7cfb\u7edf\u4e0d\u5b58\u5728\u4e0d\u53ef\u4fee\u6539", d.getName(), d.getCode()));
            }
            if (Strings.isEmpty((String)parentCode)) {
                LOGGER.info("\u6ca1\u6709\u7236\u7ea7\u7f16\u7801");
                throw new RuntimeException(String.format("%s[%s]\u6ca1\u6709\u7236\u7ea7\u7f16\u7801", d.getName(), d.getCode()));
            }
            Department parent = this.getParent(parentCode);
            if (parent == null) {
                LOGGER.info("\u6ca1\u6709\u7236\u7ea7\u90e8\u95e8");
                throw new RuntimeException(String.format("%s[%s]\u6ca1\u6709\u7236\u7ea7\u90e8\u95e8", d.getName(), d.getCode()));
            }
            boolean flag = parentCode.equals(local.getParentDep().getCode());
            this.updateDep(local, d);
            local.setParentDep(parent);
            this.depManageService.updateDep(local, flag);
        } else if (OPT_TYPE_D.equals(type)) {
            LOGGER.info("\u5220\u9664\u64cd\u4f5c");
            if (local == null) {
                return;
            }
            List children = this.depManageService.queryChildDepListByParentId(local.getId());
            if (children != null && !children.isEmpty()) {
                LOGGER.info("\u6709\u4e0b\u7ea7\u90e8\u95e8\u4e0d\u53ef\u5220\u9664");
                throw new RuntimeException(String.format("%s[%s]\u6709\u4e0b\u7ea7\u90e8\u95e8\u4e0d\u53ef\u5220\u9664", d.getName(), d.getCode()));
            }
            this.depManageService.deleteDepById(local.getId());
        } else {
            throw new RuntimeException("\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38");
        }
    }

    private Department getParent(String parentCode) {
        return this.depManageService.getDepartmentByCode(parentCode);
    }

    private void updateDep(Department local, Department sync) {
        local.setName(sync.getName());
        local.setCode(sync.getCode());
        local.setNameAbbr(sync.getNameAbbr());
        local.setOrderField(sync.getOrderField());
    }

    private String getPropertieText(Element entry, String prop) {
        return entry.element(prop).getTextTrim();
    }

    private long parseLong(String s, long defaultVal) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return defaultVal;
        }
    }
}

