/*
 * Decompiled with CFR 0.152.
 */
package pams.function.lasa.service;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.scms.util.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.XMLType;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TokenCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenCheckService.class);
    @Autowired
    private UserManageService userManageService;

    public Map<String, Object> checkToken(String serverIp, String token) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isEmpty((String)serverIp) || Strings.isEmpty((String)token)) {
            result.put("msg", "\u53c2\u6570\u5f02\u5e38");
            result.put("p", null);
            return result;
        }
        String url = String.format("http://%s/services/querySsoUser", serverIp);
        LOGGER.debug("\u6821\u9a8c\u5730\u5740:{}", (Object)url);
        String resultXml = this.invokeClient(url, token);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8fdc\u7a0b\u8fd4\u56de\u7ed3\u679c:{}", (Object)resultXml);
        }
        if (Strings.isEmpty((String)resultXml)) {
            result.put("msg", "\u9a8c\u8bc1\u5f02\u5e38");
            result.put("p", null);
            return result;
        }
        Map<String, String> paseResult = this.paseXml(resultXml);
        LOGGER.debug("\u89e3\u6790\u7ed3\u679c:{}", paseResult);
        String sfzh = paseResult.get("sfzh");
        if (Strings.isEmpty((String)sfzh)) {
            LOGGER.info("\u89e3\u6790\u7684\u8eab\u4efd\u8bc1\u53f7\u4e3a\u7a7a");
            result.put("msg", paseResult.get("msg"));
        } else {
            LOGGER.debug("\u8eab\u4efd\u8bc1\u53f7:{}", (Object)sfzh);
            Person person = this.userManageService.getUserByIdentifer(sfzh.toLowerCase());
            if (person == null) {
                person = this.userManageService.getUserByIdentifer(sfzh.toUpperCase());
            }
            if (person == null) {
                LOGGER.info("\u6839\u636e\u8eab\u4efd\u8bc1\u53f7\u6ca1\u6709\u83b7\u53d6\u5230\u4eba\u5458");
                result.put("msg", "\u767b\u5f55\u4eba\u5458\u4e0d\u5c5e\u4e8e\u672c\u7cfb\u7edf");
            } else {
                LOGGER.info("\u83b7\u53d6\u4eba\u5458\u6210\u529f");
                result.put("p", person);
            }
        }
        return result;
    }

    private String invokeClient(String url, String token) {
        org.apache.axis.client.Service service = new org.apache.axis.client.Service();
        Call call = null;
        try {
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(url);
            call.setOperationName("checkUserLogin");
            call.addParameter("in0", XMLType.XSD_STRING, ParameterMode.IN);
            call.setReturnType(XMLType.XSD_STRING);
            return (String)call.invoke(new Object[]{token});
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            } else {
                LOGGER.error("\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            return null;
        }
    }

    private Map<String, String> paseXml(String xml) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            if (doc != null) {
                List list = doc.selectNodes("result/resultHead/operateSign");
                Element sign = (Element)list.get(0);
                if (sign == null) {
                    result.put("msg", "\u7ed3\u679c\u5f02\u5e38");
                } else {
                    String text = sign.getText();
                    if (!"SUCCESS".equalsIgnoreCase(text)) {
                        List errorl = doc.selectNodes("result/resultBody/error");
                        Element error = (Element)errorl.get(0);
                        result.put("msg", error.getTextTrim());
                    } else {
                        List entys = doc.selectNodes("result/resultBody/entry");
                        if (entys == null || entys.isEmpty()) {
                            result.put("msg", "\u8ba4\u8bc1\u4fe1\u606f\u5f02\u5e38");
                        } else {
                            Element element = (Element)entys.get(0);
                            Element sfzh = element.element("sfzh");
                            String sfzhNo = sfzh.getTextTrim();
                            result.put("sfzh", sfzhNo);
                        }
                    }
                }
            }
        }
        catch (DocumentException e) {
            result.put("msg", "\u89e3\u6790\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38");
        }
        catch (Exception e) {
            result.put("msg", "\u89e3\u6790\u5931\u8d25");
        }
        return result;
    }
}

