/*
 * Decompiled with CFR 0.152.
 */
package pams.function.liaoning.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.bean.QueryForm;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.liaoning.service.RequestPowerService;

@Service
public class RequestPowerServiceImpl
implements RequestPowerService {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private CommonCodePbService commonCodePbService;
    private static Logger log = LoggerFactory.getLogger(RequestPowerServiceImpl.class);

    @Override
    public String clientVerifyStr(String clientInfo) {
        log.debug("\u8f93\u5165\u53c2\u6570:" + clientInfo);
        if (StringUtils.isBlank((CharSequence)clientInfo) || clientInfo.indexOf(";") == -1) {
            return "5:\u5176\u5b83\u9519\u8bef";
        }
        String[] info = clientInfo.split(";");
        if (info.length < 2) {
            return "5:\u5176\u5b83\u9519\u8bef";
        }
        String iccid = info[1];
        String imei = null;
        if (info.length > 2) {
            imei = info[2];
        }
        String imsi = null;
        if (info.length > 3) {
            imsi = info[3];
        }
        if (StringUtils.isBlank((CharSequence)iccid)) {
            return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
        }
        if (StringUtils.isBlank((CharSequence)imei)) {
            // empty if block
        }
        if (StringUtils.isBlank((CharSequence)imsi)) {
            // empty if block
        }
        return this.checkBindStr(iccid, imei, imsi);
    }

    private String checkBindStr(String iccid, String imei, String imsi) {
        Device device = this.deviceService.getByCardNO(iccid);
        if (null == device) {
            log.debug("\u975e\u672c\u5e73\u53f0\u7528\u6237\uff0c\u8df3\u8fc7\u9a8c\u8bc1....");
            return "0:" + this.transEmptyPersonStr();
        }
        String verifyType = this.scps.getValueByCode("_B_CheckDeivce");
        QueryForm form = null;
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if ("2".equals(person.getPersonType())) {
            return "7:\u4eba\u5458\u7c7b\u578b\u5f02\u5e38";
        }
        String personStr = this.transPersonStr(person);
        if ("0".equals(verifyType)) {
            return "0:" + personStr;
        }
        if ("1".equals(verifyType)) {
            if (device != null) {
                return "0:" + personStr;
            }
            return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("2".equals(device.getType())) {
            return "0:" + personStr;
        }
        if ("2".equals(verifyType)) {
            form = new QueryForm();
            form.setImei(imei);
            if (this.checkDeviceExit(form)) {
                return "0:" + personStr;
            }
            return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("3".equals(verifyType)) {
            form = new QueryForm();
            form.setImsi(imsi);
            if (this.checkDeviceExit(form)) {
                return "0:" + personStr;
            }
            return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("4".equals(verifyType)) {
            if (null == device) {
                return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
            }
            if (StringUtils.isBlank((CharSequence)device.getImei())) {
                boolean isExist = this.deviceService.isExistImeiOrImsi(imei, "imei");
                if (isExist) {
                    return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
                }
                try {
                    device.setImei(imei);
                    this.deviceService.update(device);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58imei\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    return "6:\u6821\u9a8c\u5931\u8d25\uff0c\u4fdd\u5b58\u4fe1\u606f\u65f6\u51fa\u9519";
                }
                return "0:" + personStr;
            }
            if (device.getImei().equals(imei)) {
                return "0:" + personStr;
            }
            return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("5".equals(verifyType)) {
            if (null == device) {
                return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
            }
            if (StringUtils.isBlank((CharSequence)device.getImsi())) {
                boolean isExist = this.deviceService.isExistImeiOrImsi(imsi, "imsi");
                if (isExist) {
                    return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
                }
                try {
                    device.setImsi(imsi);
                    this.deviceService.update(device);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58imei\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    return "6:\u6821\u9a8c\u5931\u8d25\uff0c\u4fdd\u5b58\u4fe1\u606f\u65f6\u51fa\u9519";
                }
                return "0:" + personStr;
            }
            if (device.getImsi().equals(imsi)) {
                return "0:" + personStr;
            }
            return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("6".equals(verifyType)) {
            form = new QueryForm();
            form.setImsi(imsi);
            form.setImei(imei);
            if (this.checkDeviceExit(form)) {
                return "0:" + personStr;
            }
            return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("7".equals(verifyType)) {
            boolean isExist;
            if (null == device) {
                return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
            }
            boolean isSaveInfo = false;
            if (StringUtils.isBlank((CharSequence)device.getImsi())) {
                isExist = this.deviceService.isExistImeiOrImsi(imsi, "imsi");
                if (isExist) {
                    return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
                }
                isSaveInfo = true;
                device.setImsi(imsi);
            } else if (!device.getImsi().equals(imsi)) {
                return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
            }
            if (StringUtils.isBlank((CharSequence)device.getImei())) {
                isExist = this.deviceService.isExistImeiOrImsi(imei, "imei");
                if (isExist) {
                    return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
                }
                isSaveInfo = true;
                device.setImei(imei);
            } else if (!device.getImei().equals(imei)) {
                return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
            }
            if (isSaveInfo) {
                try {
                    this.deviceService.update(device);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58imei\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    return "6:\u6821\u9a8c\u5931\u8d25\uff0c\u4fdd\u5b58\u4fe1\u606f\u65f6\u51fa\u9519";
                }
            }
            return "0:" + personStr;
        }
        return "0:" + personStr;
    }

    private String transPersonStr(Person person) {
        String showInfo = "<html>\n<head>\n<meta charset=\"utf-8\">\n<title>\u7528\u6237\u4fe1\u606f</title>\n\n<style>\n.infolist ul {\n    padding: 0;\n    margin: 0;\n    margin-top: 0.3ex;\n}\n\n.infolist ul li {\n    list-style-type: none; \n    display: inline;\n}\n\nli.key {\n    float: left;\n    width: 5em;\n    color: #606060;\n}\n\nli.key:after {\n    content: \"\uff1a\";\n}\n\nli.value {\n    color: #303030;\n}\n</style>\n\n</head>\n\n<body>\n<div class=\"infolist\">\n<ul>\n<li class=\"key\">\u59d3\u540d</li>\n<li class=\"value\">" + person.getName() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u8b66\u53f7</li>\n<li class=\"value\">" + person.getCode() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u804c\u52a1</li>\n<li class=\"value\">" + this.commonCodePbService.getCodeNameByCode(person.getPosition(), "2011") + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u624b\u673a\u53f7</li>\n<li class=\"value\">" + person.getMobile() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u8eab\u4efd\u8bc1\u53f7</li>\n<li class=\"value\">" + person.getIdentifier() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u8b66\u79cd</li>\n<li class=\"value\">" + this.commonCodePbService.getCodeNameByCode(person.getPolice(), "2012") + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u5355\u4f4d\u540d\u79f0</li>\n<li class=\"value\">" + person.getDepartment().getName() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u5355\u4f4d\u7f16\u53f7</li>\n<li class=\"value\">" + person.getDepCode() + "</li>\n</ul>\n</div>\n</body>\n</html>\n";
        return showInfo;
    }

    private String transEmptyPersonStr() {
        String showInfo = "<html>\n<head>\n<meta charset=\"utf-8\">\n<title>\u7528\u6237\u4fe1\u606f</title>\n\n<style>\n.infolist ul {\n    padding: 0;\n    margin: 0;\n    margin-top: 0.3ex;\n}\n\n.infolist ul li {\n    list-style-type: none; \n    display: inline;\n}\n\nli.key {\n    float: left;\n    width: 5em;\n    color: #606060;\n}\n\nli.key:after {\n    content: \"\uff1a\";\n}\n\nli.value {\n    color: #303030;\n}\n</style>\n\n</head>\n\n<body>\n</body>\n</html>\n";
        return showInfo;
    }

    private boolean checkDeviceExit(QueryForm form) {
        Page page = new Page();
        page.setPage(1);
        page.setRp(1);
        List list = this.deviceService.queryDeviceByImeiImsiIccid(form, page);
        return list != null && list.size() > 0;
    }
}

