/*
 * Decompiled with CFR 0.152.
 */
package pams.function.lkyw.controller;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.lkyw.bean.ClhcParamBean;
import pams.function.lkyw.bean.ClhcResultBean;
import pams.function.lkyw.bean.CzrzParamBean;
import pams.function.lkyw.bean.RyhcParamBean;
import pams.function.lkyw.bean.RyhcResultBean;
import pams.function.lkyw.bean.XlrzParamBean;
import pams.function.lkyw.bean.XlrzResultBean;
import pams.function.lkyw.entity.Clhc;
import pams.function.lkyw.entity.Czrz;
import pams.function.lkyw.entity.Ryhc;
import pams.function.lkyw.service.LkywService;

@Controller
@Scope(value="session")
public class LkywController
extends BaseControler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LkywController.class);
    @Autowired
    private LkywService service;
    @Autowired
    private CommonCodePbService commonCodePbService;

    @RequestMapping(value={"/lkyw/lkywController/cl/index.do"})
    public String clIndex(HttpServletRequest request, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            LOGGER.error("\u8df3\u8f6c\u5230\u4f4d\u7f6e\u4fe1\u606f\u9875\u9762\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/lkyw/lkywController/cl/list.do"})
    public void queryClhcInfo(ClhcParamBean paramBean, HttpServletResponse response) {
        try {
            Page page = new Page(paramBean.getPage(), paramBean.getRows());
            List<ClhcResultBean> list = this.service.listClhc(paramBean, page);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(this.pagination(page, list)));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
            LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/lkyw/lkywController/cl/toDetail.do"})
    public String toClhcDetail(String id, ModelMap modelMap) {
        modelMap.addAttribute("id", (Object)id);
        return "lkyw/cl/default/detail";
    }

    @RequestMapping(value={"/lkyw/lkywController/cl/detail.do"})
    public void detailClhc(String id, HttpServletResponse response) {
        try {
            Clhc clhc = this.service.detailClhc(id);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)clhc));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
            LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/lkyw/lkywController/ry/index.do"})
    public String toRyhc(HttpServletRequest request, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            LOGGER.error("\u8df3\u8f6c\u5230\u4f4d\u7f6e\u4fe1\u606f\u9875\u9762\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/lkyw/lkywController/ry/list.do"})
    public void listRyhc(RyhcParamBean param, HttpServletResponse response) {
        try {
            Page page = new Page(param.getPage(), param.getRows());
            List<RyhcResultBean> list = this.service.listRyhc(param, page);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(this.pagination(page, list)));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
            LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/lkyw/lkywController/ry/toDetail.do"})
    public String toRyDetail(String id, ModelMap modelMap) {
        modelMap.put((Object)"id", (Object)id);
        return "lkyw/ry/default/detail";
    }

    @RequestMapping(value={"/lkyw/lkywController/ry/detail.do"})
    public void detailRyhc(String id, HttpServletResponse response) {
        try {
            Ryhc ryhc = this.service.detailRyhc(id);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)ryhc));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
            LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/lkyw/lkywController/xlrz/index.do"})
    public String toXlrz(HttpServletRequest request, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            LOGGER.error("\u8df3\u8f6c\u5230\u4f4d\u7f6e\u4fe1\u606f\u9875\u9762\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/lkyw/lkywController/xlrz/list.do"})
    public void listXlrz(XlrzParamBean param, HttpServletResponse response) {
        try {
            Page page = new Page(param.getPage(), param.getRows());
            List<XlrzResultBean> list = this.service.listXlrz(param, page);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(this.pagination(page, list)));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
            LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/lkyw/lkywController/xlrz/img.do"})
    public String showXlrzImg() {
        return "lkyw/rz/default/xlrzimg";
    }

    @RequestMapping(value={"/lkyw/lkywController/czrz/index.do"})
    public String toCzrz(HttpServletRequest request, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            LOGGER.error("\u8df3\u8f6c\u5230\u4f4d\u7f6e\u4fe1\u606f\u9875\u9762\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/lkyw/lkywController/czrz/list.do"})
    public void listCzrz(CzrzParamBean param, HttpServletResponse response) {
        try {
            Page page = new Page(param.getPage(), param.getRows());
            List<Czrz> list = this.service.listCzrz(param.getCode(), param.getName(), param.getTime(), page);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(this.pagination(page, list)));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
            LOGGER.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/lkyw/lkywController/common/hhdd.do"})
    public void getCommoncodehhdd(String hhdd, HttpServletResponse response) {
        if (Strings.isEmpty((String)hhdd)) {
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)""));
        } else {
            String[] location = hhdd.split("-");
            if (location.length == 2) {
                CommonCode commonCode;
                String p = location[0];
                String c = location[1];
                CommonCode pCommonCode = this.commonCodePbService.getByCode(p, "lkyw-fenju-zfz");
                if (pCommonCode != null && (commonCode = this.commonCodePbService.getByCodeUnderType(c, pCommonCode.getCode(), "lkyw-fenju-zfz")) != null) {
                    Util.writeUtf8JSON((HttpServletResponse)response, (String)(pCommonCode.getName() + " " + commonCode.getName()));
                }
            }
        }
    }

    @RequestMapping(value={"/lkyw/lkywController/common/querylocation.do"})
    public void getCommonCodeHhdd(String q, HttpServletResponse response) {
        HashMap<String, String> all = new HashMap<String, String>();
        List list = this.commonCodePbService.queryByType("lkyw-fenju-zfz");
        if (list != null && !list.isEmpty()) {
            for (CommonCode commonCode : list) {
                List clist = this.commonCodePbService.queryByType(commonCode.getCode());
                if (clist == null || clist.isEmpty()) {
                    all.put(commonCode.getCode(), commonCode.getName());
                    continue;
                }
                for (String c : clist) {
                    all.put(commonCode.getCode() + "-" + c.getCode(), commonCode.getName() + "-" + c.getName());
                }
            }
        }
        ArrayList li = new ArrayList();
        Set set = all.entrySet();
        if (!set.isEmpty()) {
            for (Map.Entry entry : set) {
                String c;
                c = (String)entry.getKey();
                String v = (String)entry.getValue();
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("code", c);
                m.put("name", v);
                if (Strings.isNotEmpty((String)q)) {
                    if (!v.contains(q)) continue;
                    li.add(m);
                    continue;
                }
                li.add(m);
            }
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(li));
    }

    private Map<String, Object> pagination(Page page, List list) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", page.getTotal());
        if (list == null) {
            list = new ArrayList();
        }
        map.put("rows", list);
        return map;
    }
}

