/*
 * Decompiled with CFR 0.152.
 */
package pams.function.lkyw.service.impl;

import com.xdja.framework.commons.fileserver.FdfsUtil;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.lkyw.bean.ClhcParamBean;
import pams.function.lkyw.bean.ClhcResultBean;
import pams.function.lkyw.bean.RyhcParamBean;
import pams.function.lkyw.bean.RyhcResultBean;
import pams.function.lkyw.bean.XlrzParamBean;
import pams.function.lkyw.bean.XlrzResultBean;
import pams.function.lkyw.dao.LkywDao;
import pams.function.lkyw.entity.Clhc;
import pams.function.lkyw.entity.CljcHc;
import pams.function.lkyw.entity.CljcHcWj;
import pams.function.lkyw.entity.CljcKc;
import pams.function.lkyw.entity.CljcKcWj;
import pams.function.lkyw.entity.Czrz;
import pams.function.lkyw.entity.Ryhc;
import pams.function.lkyw.entity.Xlrz;
import pams.function.lkyw.entity.XlrzWj;
import pams.function.lkyw.service.LkywService;

@Service
public class LkywServiceImpl
implements LkywService {
    @Autowired
    private LkywDao lkywDao;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    private static FdfsUtil fdfsUtil;

    @Override
    public Clhc getById(String id) {
        Clhc clhc = this.lkywDao.getById(id);
        this.complateHc(clhc);
        return clhc;
    }

    @Override
    public List<ClhcResultBean> listClhc(ClhcParamBean param, Page page) {
        List<Clhc> list = this.lkywDao.listClhc(param, page);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<ClhcResultBean> result = new ArrayList<ClhcResultBean>(list.size());
        for (Clhc hc : list) {
            result.add(this.transHcResult(hc));
        }
        return result;
    }

    @Override
    public Clhc detailClhc(String id) {
        Clhc clhc = this.lkywDao.getById(id);
        this.complateHc(clhc);
        return clhc;
    }

    @Override
    public List<RyhcResultBean> listRyhc(RyhcParamBean param, Page page) {
        List<Ryhc> list = this.lkywDao.listRyhc(param, page);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<RyhcResultBean> result = new ArrayList<RyhcResultBean>(list.size());
        for (Ryhc ryhc : list) {
            result.add(this.transRyhcResult(ryhc));
        }
        return result;
    }

    @Override
    public Ryhc detailRyhc(String id) {
        Ryhc ryhc = this.lkywDao.detailRyhc(id);
        this.complateRyhc(ryhc);
        return ryhc;
    }

    @Override
    public List<XlrzResultBean> listXlrz(XlrzParamBean param, Page page) {
        List<Xlrz> list = this.lkywDao.listXlrz(param, page);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<XlrzResultBean> result = new ArrayList<XlrzResultBean>();
        for (Xlrz xlrz : list) {
            result.add(this.transXlrzResult(xlrz));
        }
        return result;
    }

    @Override
    public List<Czrz> listCzrz(String code, String name, String time, Page page) {
        return this.lkywDao.listCzrz(code, name, time, page);
    }

    private XlrzResultBean transXlrzResult(Xlrz xlrz) {
        CommonCode commonCode;
        String[] ss;
        Person person;
        if (xlrz == null) {
            return null;
        }
        if (Strings.isNotEmpty((String)xlrz.getPersonCode())) {
            person = this.userManageService.getUserByCode(xlrz.getPersonCode());
            xlrz.setPersonName(person == null ? "" : person.getName());
        }
        if (Strings.isNotEmpty((String)xlrz.getCompanion())) {
            person = this.userManageService.getUserByCode(xlrz.getCompanion());
            xlrz.setCompanionName(person == null ? "" : person.getName());
        }
        XlrzResultBean b = new XlrzResultBean();
        b.setZfjj(xlrz.getPersonName() + "(" + xlrz.getPersonCode() + ")");
        b.setJcbh(xlrz.getCarNo());
        if (Strings.isNotEmpty((String)xlrz.getCompanion())) {
            b.setStry(xlrz.getCompanionName() + "(" + xlrz.getCompanion() + ")");
        }
        b.setTqqk(xlrz.getWeather());
        b.setLmqk(xlrz.getLmqk());
        List<XlrzWj> wjs = this.lkywDao.listXlrzWj(xlrz.getId());
        if (wjs != null && !wjs.isEmpty()) {
            for (XlrzWj wj : wjs) {
                wj.setUrl(this.getWjUrl(wj.getWjId()));
            }
            b.setLmqkWj(wjs.get(0).getWjId());
            b.setWjList(wjs);
        }
        b.setCll(xlrz.getTrafficFlow());
        b.setJtgz(xlrz.getTrafficControl());
        b.setSbwz(xlrz.getReportPosition());
        if (Strings.isNotEmpty((String)xlrz.getReportPosition()) && (ss = xlrz.getReportPosition().split("-")).length == 2 && (commonCode = this.commonCodePbService.getByCode(ss[0], "lkyw-fenju-zfz")) != null) {
            CommonCode c = this.commonCodePbService.getByCodeUnderType(ss[1], ss[0], "lkyw-fenju-zfz");
            b.setSbwz(commonCode.getName() + "-" + c.getName());
        }
        b.setSbrq(Util.getDate((String)"yyyy-MM-dd", (Date)new Date(xlrz.getCreateTimestamp())));
        return b;
    }

    private void complateRyhc(Ryhc ryhc) {
        if (ryhc == null) {
            return;
        }
        Clhc clhc = this.lkywDao.getById(ryhc.getClhzId());
        ryhc.setClhc(clhc);
    }

    private RyhcResultBean transRyhcResult(Ryhc ryhc) {
        if (ryhc == null) {
            return null;
        }
        Clhc clhc = this.lkywDao.getById(ryhc.getClhzId());
        RyhcResultBean b = new RyhcResultBean();
        b.setId(ryhc.getId());
        b.setName(ryhc.getXm());
        b.setIdNo(ryhc.getJszh());
        b.setLxdh(ryhc.getLxdh());
        b.setHcjg(ryhc.getHcjg());
        b.setIsxy(ryhc.getSfxyr());
        b.setZqjj(clhc.getJyxm());
        b.setHcrq(Util.getDate((String)"yyyy-MM-dd", (Date)new Date(ryhc.getCjsj())));
        return b;
    }

    private ClhcResultBean transHcResult(Clhc clhc) {
        this.complateHc(clhc);
        CljcKc kc = clhc.getCljcKc();
        CljcHc hc = clhc.getCljcHc();
        Ryhc ry = clhc.getRyhc();
        ClhcResultBean bean = new ClhcResultBean();
        bean.setId(clhc.getId());
        bean.setCphm(clhc.getCphm());
        bean.setHpzl(clhc.getHpzl());
        bean.setSyxz(clhc.getSyxz());
        if (kc != null && "1".equals(kc.getSflyc())) {
            bean.setIsly("1");
        } else {
            bean.setIsly("0");
        }
        if (ry != null) {
            bean.setJsr(ry.getXm());
            bean.setLxdh(ry.getLxdh());
        }
        bean.setHcjg(clhc.getHcjg());
        String isxy = null;
        if (kc != null) {
            isxy = kc.getSfxycl();
        }
        if (isxy == null && hc != null) {
            isxy = hc.getSfxycl();
        }
        bean.setIsxy(isxy);
        bean.setZqjj(clhc.getJyhm());
        bean.setHcrq(Util.getDate((String)"yyyy-MM-dd", (Date)new Date(clhc.getCjsj())));
        return bean;
    }

    private void complateHc(Clhc clhc) {
        if (clhc != null) {
            CljcKc kc;
            if ("1".equals(clhc.getHclx())) {
                CljcHc hc = this.lkywDao.getjchc(clhc.getId());
                if (hc != null) {
                    List<CljcHcWj> hcwj = this.lkywDao.getjchcwj(hc.getId());
                    if (hcwj != null && !hcwj.isEmpty()) {
                        for (CljcHcWj wj : hcwj) {
                            String wjid = wj.getWjId();
                            if (!Strings.isNotEmpty((String)wjid)) continue;
                            wj.setUrl(this.getWjUrl(wjid));
                        }
                        hc.setCljcHcWjs(hcwj);
                    }
                    clhc.setCljcHc(hc);
                }
            } else if ("0".equals(clhc.getHclx()) && (kc = this.lkywDao.getjckc(clhc.getId())) != null) {
                List<CljcKcWj> kcWjs = this.lkywDao.getjckcwj(kc.getId());
                if (kcWjs != null && !kcWjs.isEmpty()) {
                    for (CljcKcWj wj : kcWjs) {
                        String wjid = wj.getWjId();
                        if (!Strings.isNotEmpty((String)wjid)) continue;
                        wj.setUrl(this.getWjUrl(wjid));
                    }
                    kc.setCljcKcWjs(kcWjs);
                }
                clhc.setCljcKc(kc);
            }
            Ryhc ry = this.lkywDao.getryhc(clhc.getId());
            if (ry != null) {
                clhc.setRyhc(ry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String getWjUrl(String wjid) {
        if (Strings.isEmpty((String)wjid)) {
            return "";
        }
        if (fdfsUtil == null) {
            Class<LkywServiceImpl> clazz = LkywServiceImpl.class;
            // MONITORENTER : pams.function.lkyw.service.impl.LkywServiceImpl.class
            if (fdfsUtil == null) {
                fdfsUtil = FdfsUtil.create((String)this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL"), (String)this.systemConfigService.getValueByCode("FAST_DFG_USRID"), (String)this.systemConfigService.getValueByCode("FAST_DFS_SECRET"));
            }
            // MONITOREXIT : clazz
        }
        if (fdfsUtil != null) return fdfsUtil.getDownloadUrl(wjid);
        return "";
    }
}

