/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.mdp.app.bean.AppFeedBackQueryBean;
import pams.function.mdp.app.bean.AppFeedBackReplyBean;
import pams.function.mdp.app.bean.AppFeedBackReplyQueryBean;
import pams.function.mdp.app.bean.PageBean;
import pams.function.mdp.app.service.FeedBackManagerService;

@Service
public class FeedBackManagerServiceImpl
implements FeedBackManagerService {
    private static Logger logger = LoggerFactory.getLogger(FeedBackManagerServiceImpl.class);
    private SystemConfigService systemConfigService;
    private String MDP_URL;
    private HttpRequestUtil httpRequest = new HttpRequestUtil();

    @Override
    public String getListFeedBack(AppFeedBackQueryBean queryBean) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String ret = this.postJson(this.MDP_URL + "/feedback/pamsContorl/listFeedback.do", JSON.toJSONString((Object)((Object)queryBean)));
        return ret.replace("data", "rows");
    }

    @Override
    public String getFeedBackDetailById(String id) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String ret = this.postJson(this.MDP_URL + "/feedback/pamsContorl/getFeedback.do", "{\"feedbackId\":\"" + id + "\"}");
        ret = JSONObject.parseObject((String)ret).getJSONObject("data").toJSONString();
        return ret;
    }

    @Override
    public String getlistReplyByFeedBackId(AppFeedBackReplyQueryBean queryBean) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String ret = this.postJson(this.MDP_URL + "/feedback/pamsContorl/listReply.do", JSON.toJSONString((Object)((Object)queryBean)));
        return ret.replace("data", "rows");
    }

    @Override
    public PageBean removeFeedBackByID(String feedbackId, String delPersonId) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        JSONObject param = new JSONObject();
        param.put("feedbackId", (Object)feedbackId);
        param.put("delPersonId", (Object)delPersonId);
        String ret = this.postJson(this.MDP_URL + "/feedback/pamsContorl/deleteFeedback.do", param.toJSONString());
        logger.info(ret);
        return (PageBean)JSON.parseObject((String)ret, PageBean.class);
    }

    @Override
    public PageBean removeFeedbackReply(String replyId, String delPersonId) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        JSONObject param = new JSONObject();
        param.put("replyId", (Object)replyId);
        param.put("delPersonId", (Object)delPersonId);
        String result = this.postJson(this.MDP_URL + "/feedback/pamsContorl/deleteReply.do", param.toJSONString());
        return (PageBean)JSON.parseObject((String)result, PageBean.class);
    }

    @Override
    public PageBean addReply(AppFeedBackReplyBean appFeedBackReplyBean) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String result = this.postJson(this.MDP_URL + "/feedback/pamsContorl/reply.do", JSON.toJSONString((Object)appFeedBackReplyBean));
        return (PageBean)JSON.parseObject((String)result, PageBean.class);
    }

    public String postJson(String url, String jsonParam) {
        String ret;
        try {
            ret = this.httpRequest.postJson(url, jsonParam);
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
            ret = "";
        }
        logger.info(ret);
        return ret;
    }

    public String postJson(String url) {
        return this.postJson(url, "{}");
    }

    @Autowired
    public void setSystemConfigService(SystemConfigService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }
}

