/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.mdpcard.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.scms.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.mdp.mdpcard.dao.MdpCardDao;
import pams.function.mdp.mdpcard.entity.ThirdCert;
import pams.function.mdp.mdpcard.entity.ThirdKey;

@Repository
public class MdpCardDaoImpl
implements MdpCardDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<ThirdKey> listKeyByPersonId(String personId) {
        String hql = "from ThirdKey where personId = ? and flag = '0'";
        return this.baseDao.getListByHQL(hql, new Object[]{personId});
    }

    @Override
    public ThirdKey keyDetail(String personId, String cardId) {
        String hql = "from ThirdKey where personId = ? and cardId = ? and flag = '0'";
        return (ThirdKey)this.baseDao.getObjectByHQL(hql, new Object[]{personId, cardId});
    }

    @Override
    public List<ThirdKey> listKeyExt(String personId, String cardId) {
        String hql = "from ThirdKey where 1=1 and flag = '0' ";
        ArrayList<String> list = new ArrayList<String>();
        if (Strings.isNotEmpty((String)personId)) {
            hql = hql + "and personId = ? ";
            list.add(personId);
        }
        if (Strings.isNotEmpty((String)cardId)) {
            hql = hql + " and cardId = ? ";
            list.add(cardId);
        }
        return this.baseDao.getListByHQL(hql, list.toArray(new Object[list.size()]));
    }

    @Override
    public ThirdKey keyDetail(String id) {
        return (ThirdKey)this.baseDao.getObjectById(ThirdKey.class, (Serializable)((Object)id));
    }

    @Override
    public List<ThirdCert> listCertByCardId(String cardId) {
        String hql = "from ThirdCert where cardId = ?";
        return this.baseDao.getListByHQL(hql, new Object[]{cardId});
    }

    @Override
    public void addKey(ThirdKey thirdKey) {
        if (thirdKey != null) {
            this.baseDao.create((Object)thirdKey);
        }
    }

    @Override
    public void addCert(ThirdCert thirdCert) {
        if (thirdCert != null) {
            this.baseDao.create((Object)thirdCert);
        }
    }

    @Override
    public void updateKey(ThirdKey thirdKey) {
        if (thirdKey != null) {
            this.baseDao.update((Object)thirdKey);
        }
    }

    @Override
    public void updateCert(ThirdCert thirdCert) {
        if (thirdCert != null) {
            this.baseDao.update((Object)thirdCert);
        }
    }
}

