/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.rsms.service.impl;

import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syn.entity.MDPAndPolice;
import com.xdja.pams.syn.service.PersonMDPService;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.mdp.rsms.bean.QueryBean;
import pams.function.mdp.rsms.bean.ResApplyBean;
import pams.function.mdp.rsms.bean.ResApplyBeanList;
import pams.function.mdp.rsms.bean.ResApplyQueryRst;
import pams.function.mdp.rsms.bean.ResDataSourceTabRst;
import pams.function.mdp.rsms.bean.ResQueryRst;
import pams.function.mdp.rsms.bean.ResSaveRst;
import pams.function.mdp.rsms.bean.ResourceBean;
import pams.function.mdp.rsms.service.ResourceAPIService;

@Service
public class ResourceAPIServiceImpl
implements ResourceAPIService {
    private static final Logger log = LoggerFactory.getLogger(ResourceAPIServiceImpl.class);
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private PersonMDPService personMDPService;

    @Override
    public ResQueryRst queryResList(QueryBean param, PageParam pageParam) {
        String paramReq = "";
        if (param != null) {
            if (StringUtils.isNotBlank((CharSequence)param.getResRatify())) {
                paramReq = paramReq + "&auditStatus=" + param.getResRatify();
            }
            if (StringUtils.isNotBlank((CharSequence)param.getKeyWord())) {
                paramReq = paramReq + "&keyWord=" + param.getKeyWord();
            }
            if (StringUtils.isNotBlank((CharSequence)param.getCreateDateStart())) {
                paramReq = paramReq + "&startDate=" + param.getCreateDateStart();
            }
            if (StringUtils.isNotBlank((CharSequence)param.getCreateDateEnd())) {
                paramReq = paramReq + "&endDate=" + param.getCreateDateEnd();
            }
            if (pageParam != null) {
                paramReq = paramReq + "&page=" + pageParam.getPage();
                paramReq = paramReq + "&rows=" + pageParam.getRows();
            }
        }
        ResQueryRst rqr = null;
        HashMap map = new HashMap();
        try {
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            String url = prsUrl + "/resource/queryResPkgList.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (ResQueryRst)Util.readValue((String)rst, ResQueryRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage());
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }

    @Override
    public ResourceBean getResById(String id, String auditStatus) {
        String prsUrl = this.systemConfigService.getValueByCode("prs_url");
        String url = prsUrl + "/resource/queryResPkgList.do";
        String paramReq = "id=" + id + "&auditStatus=" + auditStatus;
        HttpRequestUtil httpclient = new HttpRequestUtil();
        ResourceBean resb = null;
        try {
            String creatorId;
            MDPAndPolice mp;
            String rst = httpclient.post(url, paramReq);
            ResQueryRst rqr = (ResQueryRst)Util.readValue((String)rst, ResQueryRst.class);
            if (rqr.getData() != null && rqr.getData().size() > 0 && (mp = this.personMDPService.getMDPAndPoliceById(creatorId = (resb = rqr.getData().get(0)).getCreator())) != null) {
                resb.setCreator(mp.getName());
            }
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u8be6\u60c5\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return resb;
    }

    @Override
    public ResQueryRst queryApplyInfo(QueryBean param, PageParam pageParam) {
        String paramReq = "";
        if (param != null) {
            if (StringUtils.isNotBlank((CharSequence)param.getResRatify())) {
                paramReq = paramReq + "&resRatify=" + param.getResRatify();
            }
            if (StringUtils.isNotBlank((CharSequence)param.getKeyWord())) {
                paramReq = paramReq + "&keyWord=" + param.getKeyWord();
            }
            if (StringUtils.isNotBlank((CharSequence)param.getCreateDateStart())) {
                paramReq = paramReq + "&createDateStart=" + param.getCreateDateStart();
            }
            if (StringUtils.isNotBlank((CharSequence)param.getCreateDateEnd())) {
                paramReq = paramReq + "&createDateEnd=" + param.getCreateDateEnd();
            }
        }
        ResQueryRst rqr = null;
        HashMap map = new HashMap();
        try {
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            String url = prsUrl + "/resource/queryResPkgList.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (ResQueryRst)Util.readValue((String)rst, ResQueryRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }

    @Override
    public ResSaveRst saveResEmpowerInfo(ResApplyBeanList resApplyBeanList) {
        ResSaveRst rqr;
        String prsUrl = this.systemConfigService.getValueByCode("prs_url");
        String url = prsUrl + "/resapply/batchAddApplyInfo.do";
        String json = Util.toJsonStr((Object)resApplyBeanList);
        HttpRequestUtil httpclient = new HttpRequestUtil();
        Object resb = null;
        try {
            String paramReq = "type=json&applyInfoJson=" + json;
            String rst = httpclient.post(url, paramReq);
            rqr = (ResSaveRst)Util.readValue((String)rst, ResSaveRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u8be6\u60c5\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }

    @Override
    public ResApplyQueryRst queryResApplyList(QueryBean param, PageParam pageParam) {
        String paramReq = "";
        if (param != null) {
            if (StringUtils.isNotBlank((CharSequence)param.getResRatify())) {
                paramReq = paramReq + "&applyStatus=" + param.getResRatify();
            }
            if (StringUtils.isNotBlank((CharSequence)param.getKeyWord())) {
                paramReq = paramReq + "&resName=" + param.getKeyWord();
            }
            if (StringUtils.isNotBlank((CharSequence)param.getCreateDateStart())) {
                paramReq = paramReq + "&startDate=" + param.getCreateDateStart();
            }
            if (StringUtils.isNotBlank((CharSequence)param.getCreateDateEnd())) {
                paramReq = paramReq + "&endDate=" + param.getCreateDateEnd();
            }
        }
        if (pageParam != null) {
            paramReq = paramReq + "&page=" + pageParam.getPage();
            paramReq = paramReq + "&rows=" + pageParam.getRows();
        }
        paramReq = paramReq + "&type=json";
        ResApplyQueryRst rqr = null;
        HashMap map = new HashMap();
        try {
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            String url = prsUrl + "/resapply/queryResApplyList.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (ResApplyQueryRst)Util.readValue((String)rst, ResApplyQueryRst.class);
            if (rqr != null) {
                for (ResApplyBean resb : rqr.getData()) {
                    String creatorId = resb.getApplyPersonId();
                    MDPAndPolice mp = this.personMDPService.getMDPAndPoliceById(creatorId);
                    if (mp == null) continue;
                    resb.setApplyPersonName(mp.getName());
                    resb.setApplyCompany(mp.getDepName());
                }
            }
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u7533\u8bf7\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }

    @Override
    public ResApplyBean queryResApplyInfo(String id) {
        String paramReq = "type=json&applyId=" + id;
        ResApplyBean resb = null;
        try {
            String pId;
            MDPAndPolice mp;
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            String url = prsUrl + "/resapply/toResApplyDetail.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            ResApplyQueryRst rqr = (ResApplyQueryRst)Util.readValue((String)rst, ResApplyQueryRst.class);
            if (rqr.getData() != null && rqr.getData().size() > 0 && (mp = this.personMDPService.getMDPAndPoliceById(pId = (resb = rqr.getData().get(0)).getApplyPersonId())) != null) {
                resb.setApplyPersonName(mp.getName());
                resb.setApplyCompany(mp.getDepName());
            }
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return resb;
    }

    @Override
    public ResDataSourceTabRst queryDataResTab(String redId) {
        String paramReq = "type=json&resId=" + redId;
        ResDataSourceTabRst rqr = null;
        try {
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            String url = prsUrl + "/drs/getDataSourceInfo.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (ResDataSourceTabRst)Util.readValue((String)rst, ResDataSourceTabRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u6570\u636e\u5305\u4fe1\u606f\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }
}

