/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.accredit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.framework.commons.utils.http.HttpUtils;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.mdp.accredit.bean.AppUseArea;
import pams.function.mdp.accredit.bean.AppUseAreaAccredit;
import pams.function.mdp.accredit.bean.AppUserAreaBean;
import pams.function.mdp.accredit.bean.PersonLimitsBean;
import pams.function.mdp.accredit.dao.AccreditDao;
import pams.function.mdp.accredit.service.AccreditService;

@Service
public class AccreditServiceImpl
implements AccreditService {
    @Autowired
    private AccreditDao accreditDao;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private SystemConfigService systemConfigService;
    private boolean useMdpAppTreeApi = true;

    @Override
    public String getAppTreeChildJson(String vestInDepId) throws Exception {
        String result = null;
        String param = "";
        String url = "";
        if (this.useMdpAppTreeApi) {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            url = mdpUrl + "/appManagerControl/appTypeTreeWithApp.do" + "?vestInDepId=" + vestInDepId;
            ResponseWrap wrap = HttpUtils.get((String)url).execute();
            int statusCode = wrap.getStatusCode();
            if (statusCode == 404) {
                this.useMdpAppTreeApi = false;
                return this.getAppTreeChildJson(vestInDepId);
            }
            if (statusCode == 200) {
                return wrap.getString();
            }
            throw new RuntimeException("\u83b7\u53d6\u5e94\u7528\u6811\u5f02\u5e38");
        }
        String pamsUrl = this.systemConfigService.getValueByCode("UAS_SERVER_URL");
        url = pamsUrl + "/app/appcontroller/queryAppTree.do";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        return result;
    }

    @Override
    public List<Person> getUseApp(String appId) throws Exception {
        String result = null;
        String pamsUrl = this.systemConfigService.getValueByCode("UAS_SERVER_URL");
        String url = pamsUrl + "/empower/empowercontroller/queryAppEmpower.do";
        String param = "appId=" + appId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        List<Object> list = new ArrayList();
        ArrayList<Person> personList = new ArrayList<Person>();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        AppUserAreaBean appUserAreaBean = (AppUserAreaBean)Util.readValue((String)result, AppUserAreaBean.class);
        if (appUserAreaBean != null && appUserAreaBean.getAppUseArea().size() > 0) {
            list = appUserAreaBean.getAppUseArea();
            for (AppUseArea appUseArea : list) {
                Person person = new Person();
                person.setId(appUseArea.getId());
                person.setCode(appUseArea.getCode());
                person.setName(appUseArea.getName());
                person.setFlag(appUseArea.getType());
                personList.add(person);
            }
        }
        return personList;
    }

    @Override
    public List<Person> getUseAppTmp(String appId) throws Exception {
        String result = null;
        String pamsUrl = this.systemConfigService.getValueByCode("UAS_SERVER_URL");
        String url = pamsUrl + "/empower/empowercontroller/queryAppEmpowerTmp.do";
        String param = "appId=" + appId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        List<Object> list = new ArrayList();
        ArrayList<Person> personList = new ArrayList<Person>();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        AppUserAreaBean appUserAreaBean = (AppUserAreaBean)Util.readValue((String)result, AppUserAreaBean.class);
        if (appUserAreaBean != null && appUserAreaBean.getAppUseArea().size() > 0) {
            list = appUserAreaBean.getAppUseArea();
            for (AppUseArea appUseArea : list) {
                Person person = new Person();
                person.setId(appUseArea.getId());
                person.setCode(appUseArea.getCode());
                person.setName(appUseArea.getName());
                person.setFlag(appUseArea.getType());
                personList.add(person);
            }
        }
        return personList;
    }

    @Override
    public String addUseApp(AppUseAreaAccredit appUseAreaAccredit) throws Exception {
        String result = null;
        String pamsUrl = this.systemConfigService.getValueByCode("UAS_SERVER_URL");
        String url = pamsUrl + "/empower/empowercontroller/saveAppEmpower.do";
        if ("1".equals(appUseAreaAccredit.getIsTmp())) {
            url = pamsUrl + "/empower/empowercontroller/saveAppEmpowerTmp.do";
        }
        String param = "appId=" + appUseAreaAccredit.getAppId() + "&personId=" + appUseAreaAccredit.getPersonId() + "&type=" + appUseAreaAccredit.getType() + appUseAreaAccredit.getAccreditParam();
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        return result;
    }

    @Override
    public String queryAppList(String type, String rows, String page, String code, String name, String id, String vestInDepId) throws Exception {
        String result = null;
        if (this.useMdpAppTreeApi) {
            ResponseWrap wrap;
            int statusCode;
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/appManagerControl/queryAppList.do?type=json";
            if (type != null && !"".equals(type)) {
                url = url + "&appTypeId=" + type;
            }
            url = url + "&page=" + page + "&rows=" + rows + "&vestInDepId=" + vestInDepId + "&appStatus=1&order=obj.appId";
            if (name != null && !"".equals(name)) {
                url = url + "&queryKey=" + name;
            }
            if (id != null && !"".equals(id)) {
                url = url + "&appId=" + id;
            }
            if ((statusCode = (wrap = HttpUtils.get((String)url).execute()).getStatusCode()) == 404) {
                this.useMdpAppTreeApi = false;
                return this.getAppTreeChildJson(vestInDepId);
            }
            if (statusCode == 200) {
                String string = wrap.getString();
                JSONObject object = JSON.parseObject((String)string);
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                map.put("total", Integer.valueOf(object.getIntValue("total")));
                ArrayList data = new ArrayList();
                JSONArray data1 = object.getJSONArray("data");
                for (int i = 0; i < data1.size(); ++i) {
                    JSONObject jsonObject = data1.getJSONObject(i);
                    HashMap<String, String> o = new HashMap<String, String>();
                    o.put("appId", jsonObject.getString("appId"));
                    o.put("appLogoFileName", jsonObject.getString("appLogoFileName"));
                    o.put("description", jsonObject.getString("appDescription"));
                    o.put("name", jsonObject.getString("appName"));
                    data.add(o);
                }
                map.put("rows", data);
                return JSON.toJSONString(map);
            }
            throw new RuntimeException("\u83b7\u53d6\u5e94\u7528\u5217\u8868\u5f02\u5e38");
        }
        String pamsUrl = this.systemConfigService.getValueByCode("UAS_SERVER_URL");
        String url = pamsUrl + "/app/appcontroller/queryAppList.do";
        String param = "type=" + type + "&rows=" + rows + "&page=" + page + "&name=" + name + "&id=" + id + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        return result;
    }

    @Override
    public String getPersonUnEditLimits(String personId) throws Exception {
        String result = null;
        String resultStr = "";
        String pamsUrl = this.systemConfigService.getValueByCode("UAS_SERVER_URL");
        String url = pamsUrl + "/empower/empowercontroller/getPersonUnEditLimits.do";
        String param = "id=" + personId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PersonLimitsBean personLimitsBean = (PersonLimitsBean)Util.readValue((String)result, PersonLimitsBean.class);
        String[] Limits = personLimitsBean.getLimits();
        for (int i = 0; i < Limits.length; ++i) {
            resultStr = resultStr + Limits[i] + ",";
        }
        return resultStr;
    }

    @Override
    public String getPersonLimits(String personId) throws Exception {
        String result = null;
        String resultStr = "";
        String pamsUrl = this.systemConfigService.getValueByCode("UAS_SERVER_URL");
        String url = pamsUrl + "/empower/empowercontroller/getPersonLimits.do";
        String param = "id=" + personId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PersonLimitsBean personLimitsBean = (PersonLimitsBean)Util.readValue((String)result, PersonLimitsBean.class);
        String[] Limits = personLimitsBean.getLimits();
        for (int i = 0; i < Limits.length; ++i) {
            resultStr = resultStr + Limits[i] + ",";
        }
        return resultStr;
    }
}

