/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.acms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.tims.service.MsgPushService;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.acms.bean.AppCommentBean;
import pams.function.mdp.acms.bean.AppCommentQueryListRst;
import pams.function.mdp.acms.bean.AppCommentReplyBean;
import pams.function.mdp.acms.bean.AppCommentRst;
import pams.function.mdp.acms.bean.QueryBean;
import pams.function.mdp.acms.service.AppCommentService;
import pams.function.mdp.app.service.AppAuditService;

@Controller
@Scope(value="session")
public class AppCommentControler
extends BaseControler {
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    AppAuditService appAuditService;
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    MsgPushService sendAppNotice;
    @Autowired
    private AppCommentService acs;
    private static final Logger log = LoggerFactory.getLogger(AppCommentControler.class);

    @RequestMapping(value={"/acms/appCommentControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        String logoUrl = "";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            logoUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        map.put((Object)"logoUrl", (Object)logoUrl);
        return sendUrl;
    }

    @RequestMapping(value={"/acms/appCommentControler/queryList.do"})
    public void queryList(HttpServletRequest request, HttpServletResponse response, PageParam page, QueryBean param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int operateResult = 1;
        try {
            if (param == null) {
                param = new QueryBean();
            }
            param.setVestInDepId(this.getControlDeps(request));
            AppCommentQueryListRst<AppCommentBean> rqr = this.acs.queryAppCommentList(param, page);
            map.put("total", rqr.getTotal());
            map.put("rows", rqr.getData());
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5e94\u7528\u8bc4\u8bba\u4fe1\u606f\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            map.put("total", "0");
            map.put("rows", new ArrayList());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        String json = Util.toJsonStr(map);
        log.debug("\u67e5\u8be2\u6210\u529f" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/acms/appCommentControler/queryDetail.do"})
    public String queryDetail(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, QueryBean param) {
        try {
            AppCommentBean comment = this.acs.queryAppCommentDetail(param);
            map.put((Object)"comment", (Object)comment);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5e94\u7528\u8bc4\u8bba\u4fe1\u606f\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
        }
        return "acms/default/showDetail";
    }

    @RequestMapping(value={"/acms/appCommentControler/queryCommentReply.do"})
    public void queryCommentReply(HttpServletRequest request, HttpServletResponse response, PageParam page, QueryBean param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            AppCommentQueryListRst<AppCommentReplyBean> rqr = this.acs.queryAppCommentReplyList(param, page);
            map.put("total", rqr.getTotal());
            map.put("rows", rqr.getData());
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5e94\u7528\u8bc4\u8bba\u4fe1\u606f\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            map.put("total", "0");
            map.put("rows", new ArrayList());
        }
        String json = Util.toJsonStr(map);
        log.debug("\u67e5\u8be2\u6210\u529f" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/acms/appCommentControler/reply.do"})
    public void reply(HttpServletRequest request, HttpServletResponse response, AppCommentReplyBean reply) {
        HashMap<String, String> map = new HashMap<String, String>();
        int operateResult = 1;
        try {
            if (reply == null) {
                reply = new AppCommentReplyBean();
            }
            reply.setCreatorId(this.person.getId());
            reply.setVestInDepId(this.getControlDeps(request));
            AppCommentRst rst = this.acs.addAppComentReply(reply);
            if ("1".equals(rst.getState())) {
                map.put("rtnCode", "0");
                map.put("rtnMsg", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            } else {
                map.put("rtnCode", "1");
                map.put("rtnMsg", rst.getData());
            }
        }
        catch (Exception e2) {
            log.error("\u56de\u590d\u5e94\u7528\u8bc4\u8bba\u4fe1\u606f\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            map.put("rtnCode", "1");
            map.put("rtnMsg", e2.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(3), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        String json = Util.toJsonStr(map);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/acms/appCommentControler/delReply.do"})
    public void delReply(HttpServletRequest request, HttpServletResponse response, PageParam page, AppCommentReplyBean reply) {
        HashMap<String, String> map = new HashMap<String, String>();
        int operateResult = 1;
        try {
            AppCommentRst rst = this.acs.delAppComentReply(reply);
            if ("1".equals(rst.getState())) {
                map.put("rtnCode", "0");
                map.put("rtnMsg", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            } else {
                map.put("rtnCode", "1");
                map.put("rtnMsg", rst.getData());
            }
        }
        catch (Exception e2) {
            log.error("\u5220\u9664\u5e94\u7528\u8bc4\u8bba\u56de\u590d\u4fe1\u606f\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            map.put("rtnCode", "1");
            map.put("rtnMsg", e2.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(4), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        String json = Util.toJsonStr(map);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/acms/appCommentControler/delComment.do"})
    public void delComment(HttpServletRequest request, HttpServletResponse response, PageParam page, AppCommentBean reply) {
        int operateResult = 1;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (reply == null) {
                reply = new AppCommentBean();
            }
            reply.setVestInDepId(this.getControlDeps(request));
            AppCommentRst rst = this.acs.delAppComent(reply);
            if ("1".equals(rst.getState())) {
                map.put("rtnCode", "0");
                map.put("rtnMsg", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            } else {
                map.put("rtnCode", "1");
                map.put("rtnMsg", rst.getData());
            }
        }
        catch (Exception e2) {
            log.error("\u5220\u9664\u95ee\u9898\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            map.put("rtnCode", "1");
            map.put("rtnMsg", e2.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(4), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        String json = Util.toJsonStr(map);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }
}

