/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.adms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.mdp.adms.bean.AdPicBean;
import pams.function.mdp.adms.bean.AdPicQueryListRst;
import pams.function.mdp.adms.bean.AdPicQueryRst;
import pams.function.mdp.adms.service.AdPicService;

@Controller
@Scope(value="session")
public class AdPicController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(AdPicController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private AdPicService aps;
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    private SystemLogService systemLogService;

    @RequestMapping(value={"/adms/admscontrol/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        String fastdfsUrl = "";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        return sendUrl;
    }

    @RequestMapping(value={"/adms/admscontrol/toAddPage.do"})
    public String toAddPage() {
        return "adms/default/add";
    }

    @RequestMapping(value={"/adms/admscontrol/toEditPage.do"})
    public String toEditPage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        try {
            AdPicBean adPicBean = this.aps.queryAdPicById(id);
            map.put((Object)"adPic", (Object)adPicBean);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5e94\u7528\u5546\u5e97\u5e7f\u544a\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
        }
        return "adms/default/edit";
    }

    @RequestMapping(value={"/adms/admscontrol/save.do"})
    public void saveAdPic(HttpServletRequest request, HttpServletResponse response, @RequestParam MultipartFile file, AdPicBean adPicBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        if (StringUtils.isBlank((CharSequence)adPicBean.getAppId()) || adPicBean.getOrderNum() == null || StringUtils.isBlank((CharSequence)adPicBean.getBannerNote()) || file == null) {
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        } else {
            try {
                adPicBean.setCreateUserId(this.person.getId());
                adPicBean.setCreateUserName(this.person.getName());
                adPicBean.setVestInDepId(this.getControlDeps(request));
                AdPicQueryRst<String> rst = this.aps.saveAdPic(file, adPicBean);
                if ("1".equals(rst.getState())) {
                    rtnResult.setRtnCode("0");
                    rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                } else {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + rst.getData());
                }
            }
            catch (Exception e2) {
                log.error("\u4fdd\u5b58\u5e94\u7528\u5546\u5e97\u5e7f\u544a\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
                operateResult = 0;
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + e2.getMessage());
            }
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        String json = Util.toJsonStr((Object)rtnResult);
        Util.writeUtf8Text1((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/adms/admscontrol/update.do"})
    public void updateAdPic(HttpServletRequest request, HttpServletResponse response, @RequestParam MultipartFile file, AdPicBean adPicBean) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            adPicBean.setVestInDepId(this.getControlDeps(request));
            AdPicQueryRst<String> rst = this.aps.udpateAdPic(file, adPicBean);
            if ("1".equals(rst.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + rst.getData());
            }
        }
        catch (Exception e2) {
            log.error("\u4fee\u6539\u5e94\u7528\u5546\u5e97\u5e7f\u544a\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + e2.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(3), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        String json = Util.toJsonStr((Object)rtnResult);
        Util.writeUtf8Text1((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/adms/admscontrol/delete.do"})
    public void deleteAdPic(HttpServletRequest request, HttpServletResponse response, String id) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            AdPicQueryRst<String> rst = this.aps.deleteAdPic(id, this.getControlDeps(request));
            if ("1".equals(rst.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + rst.getData());
            }
        }
        catch (Exception e2) {
            log.error("\u5220\u9664\u5e94\u7528\u5546\u5e97\u5e7f\u544a\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + e2.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(4), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        String json = Util.toJsonStr((Object)rtnResult);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/adms/admscontrol/query.do"})
    public void queryAdPic(HttpServletRequest request, HttpServletResponse response, PageParam page) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int operateResult = 1;
        try {
            String vestInDepId = this.getControlDeps(request);
            AdPicQueryListRst rqr = this.aps.queryAdPicList(vestInDepId);
            map.put("total", rqr.getTotal());
            map.put("rows", rqr.getData());
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5e94\u7528\u5546\u5e97\u5e7f\u544a\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            map.put("total", "0");
            map.put("rows", new ArrayList());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        String json = Util.toJsonStr(map);
        log.debug("\u67e5\u8be2\u6210\u529f" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/adms/admscontrol/updateDisable.do"})
    public void updateDisable(HttpServletRequest request, HttpServletResponse response, String id, String disable) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            AdPicQueryRst<String> rst = this.aps.updateDisable(id, disable, this.getControlDeps(request));
            if ("1".equals(rst.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + rst.getData());
            }
        }
        catch (Exception e2) {
            log.error("\u542f\u7528/\u505c\u7528\u5e94\u7528\u5546\u5e97\u5e7f\u544a\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + e2.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(4), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        String json = Util.toJsonStr((Object)rtnResult);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }
}

