/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.adms.service.impl;

import com.xdja.pams.common.util.Base64Encrypt;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.net.URLEncoder;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import pams.function.mdp.adms.bean.AdPicBean;
import pams.function.mdp.adms.bean.AdPicQueryListRst;
import pams.function.mdp.adms.bean.AdPicQueryRst;
import pams.function.mdp.adms.service.AdPicService;

@Service
public class AdPicServiceImpl
implements AdPicService {
    private static final Logger log = LoggerFactory.getLogger(AdPicServiceImpl.class);
    @Autowired
    private SystemConfigPbService systemConfigService;

    @Override
    public AdPicQueryListRst queryAdPicList(String vestInDepId) {
        String paramReq = "type=json&vestInDepId=" + vestInDepId;
        AdPicQueryListRst rqr = null;
        try {
            String prsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = prsUrl + "/appBannerControl/getAppBannerList.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (AdPicQueryListRst)Util.readValue((String)rst, AdPicQueryListRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }

    @Override
    public AdPicBean queryAdPicById(String id) {
        String paramReq = "type=json&appBannerId=" + id;
        AdPicQueryListRst rqr = null;
        try {
            String prsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = prsUrl + "/appBannerControl/getAppBannerList.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (AdPicQueryListRst)Util.readValue((String)rst, AdPicQueryListRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        if (rqr != null && rqr.getData() != null && !rqr.getData().isEmpty()) {
            return rqr.getData().get(0);
        }
        return null;
    }

    @Override
    public AdPicQueryRst<String> saveAdPic(MultipartFile file, AdPicBean adPicBean) {
        long fileSize = file.getSize();
        boolean fizeSizeMB = false;
        int timsShareFileMaxSize = Integer.parseInt(this.systemConfigService.getValueByCode("timsShareFileMaxSize"));
        if (fileSize / 0x100000L >= (long)timsShareFileMaxSize) {
            throw new RuntimeException("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7" + timsShareFileMaxSize + "MB\uff0c\u4e0a\u4f20\u5931\u8d25");
        }
        AdPicQueryRst rqr = null;
        try {
            String fileName = file.getOriginalFilename();
            String extension = FilenameUtils.getExtension((String)fileName);
            Base64Encrypt base64Encrypt = new Base64Encrypt();
            String imgBase64 = base64Encrypt.getBase64FromBytes(file.getBytes());
            String paramReq = "type=json&createUserId=" + adPicBean.getCreateUserId();
            paramReq = paramReq + "&createUserName=" + adPicBean.getCreateUserName();
            paramReq = paramReq + "&appId=" + adPicBean.getAppId();
            paramReq = paramReq + "&bannerNote=" + adPicBean.getBannerNote();
            paramReq = paramReq + "&orderNum=" + adPicBean.getOrderNum();
            paramReq = paramReq + "&picSuffix=" + extension;
            paramReq = paramReq + "&picBase64=" + URLEncoder.encode(imgBase64, "utf-8");
            paramReq = paramReq + "&vestInDepId=" + adPicBean.getVestInDepId();
            String prsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = prsUrl + "/appBannerControl/saveAppBanner.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (AdPicQueryRst)Util.readValue((String)rst, AdPicQueryRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }

    @Override
    public AdPicQueryRst<String> udpateAdPic(MultipartFile file, AdPicBean adPicBean) {
        AdPicQueryRst rqr = null;
        try {
            String paramReq = "type=json&appBannerId=" + adPicBean.getAppBannerId();
            paramReq = paramReq + "&appId=" + adPicBean.getAppId();
            paramReq = paramReq + "&bannerNote=" + adPicBean.getBannerNote();
            paramReq = paramReq + "&orderNum=" + adPicBean.getOrderNum();
            paramReq = paramReq + "&vestInDepId=" + adPicBean.getVestInDepId();
            if (file != null) {
                long fileSize = file.getSize();
                boolean fizeSizeMB = false;
                int timsShareFileMaxSize = Integer.parseInt(this.systemConfigService.getValueByCode("timsShareFileMaxSize"));
                if (fileSize / 0x100000L >= (long)timsShareFileMaxSize) {
                    throw new RuntimeException("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7" + timsShareFileMaxSize + "MB\uff0c\u4e0a\u4f20\u5931\u8d25");
                }
                String fileName = file.getOriginalFilename();
                String extension = FilenameUtils.getExtension((String)fileName);
                Base64Encrypt base64Encrypt = new Base64Encrypt();
                String imgBase64 = base64Encrypt.getBase64FromBytes(file.getBytes());
                paramReq = paramReq + "&picSuffix=" + extension;
                paramReq = paramReq + "&picBase64=" + URLEncoder.encode(imgBase64, "utf-8");
            }
            String prsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = prsUrl + "/appBannerControl/updateAppBanner.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (AdPicQueryRst)Util.readValue((String)rst, AdPicQueryRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }

    @Override
    public AdPicQueryRst<String> deleteAdPic(String id, String vestInDepId) {
        AdPicQueryRst rqr = null;
        try {
            String paramReq = "type=json&appBannerId=" + id + "&vestInDepId=" + vestInDepId;
            String prsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = prsUrl + "/appBannerControl/deleteAppBanner.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (AdPicQueryRst)Util.readValue((String)rst, AdPicQueryRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }

    public static void main(String[] args) {
        String rst = "{\"type\":\"json\",\"qUrl\":null,\"pUrl\":null,\"state\":\"1\",\"page\":1,\"rows\":10,\"total\":0,\"pageCount\":0,\"data\":\"111\",\"empty\":true,\"firstResult\":0,\"lastPage\":true,\"firstPage\":true}";
        AdPicQueryRst rqr = (AdPicQueryRst)Util.readValue((String)rst, AdPicQueryRst.class);
        System.out.println(rqr);
    }

    @Override
    public AdPicQueryRst<String> updateDisable(String id, String disable, String vestInDepId) {
        AdPicQueryRst rqr = null;
        try {
            String paramReq = "type=json&appBannerId=" + id + "&disable=" + disable + "&vestInDepId=" + vestInDepId;
            String prsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = prsUrl + "/appBannerControl/updateAppBannerDisable.do";
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String rst = httpclient.post(url, paramReq);
            rqr = (AdPicQueryRst)Util.readValue((String)rst, AdPicQueryRst.class);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage());
        }
        return rqr;
    }
}

