/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.app.bean;

import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PageBeanList<T> {
    public static int DEFAULT_PAGE_INDEX = 1;
    public static int DEFAULT_PAGE_SIZE = 10;
    public static String RESPOSE_TYPE_JSON = "json";
    public static String RESPOSE_TYPE_HTML = "html";
    public static String RESPOSE_TYPE_TEXT = "text";
    public static String RESPOSE_TYPE_JSONP = "jsonp";
    public static String RESPOSE_TYPE_DEFAULT = RESPOSE_TYPE_HTML;
    public static String RESPOSE_URL_DEFAULT = "index";
    public static String RESPOSE_STATE_SUCCESS = "1";
    public static String RESPOSE_STATE_ERROR;
    public static String RESPOSE_STATE_DEFAULT;
    private String type;
    private String qUrl;
    private String pUrl;
    private String state = RESPOSE_STATE_DEFAULT;
    private int page;
    private int rows;
    private int total;
    private int pageCount;
    private List<T> data;
    private String resultJson;

    public String getResultJson() {
        return this.resultJson;
    }

    public void setResultJson(String resultJson) {
        this.resultJson = resultJson;
    }

    public PageBeanList() {
        this(DEFAULT_PAGE_INDEX);
    }

    public PageBeanList(int pageIndex) {
        this(pageIndex, DEFAULT_PAGE_SIZE);
    }

    public PageBeanList(int page, int rows) {
        this.page = page > DEFAULT_PAGE_INDEX ? page : DEFAULT_PAGE_INDEX;
        this.rows = rows < 0 ? rows : DEFAULT_PAGE_SIZE;
    }

    public PageBeanList(String pageIndexStr, String pageSizeStr) {
        int pageIndex = DEFAULT_PAGE_INDEX;
        try {
            pageIndex = Integer.parseInt(pageIndexStr);
        }
        catch (Exception e2) {
            pageIndex = DEFAULT_PAGE_INDEX;
        }
        this.page = pageIndex > DEFAULT_PAGE_INDEX ? pageIndex : DEFAULT_PAGE_INDEX;
        int pageSize = DEFAULT_PAGE_SIZE;
        try {
            pageSize = Integer.parseInt(pageSizeStr);
        }
        catch (Exception e3) {
            pageSize = DEFAULT_PAGE_SIZE;
        }
        this.rows = pageSize < 0 ? pageSize : DEFAULT_PAGE_SIZE;
    }

    public String getType() {
        if (this.type == null || "".equals(this.type)) {
            this.type = RESPOSE_TYPE_DEFAULT;
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getqUrl() {
        return this.qUrl;
    }

    public void setqUrl(String qUrl) {
        this.qUrl = qUrl;
    }

    public String getpUrl() {
        return this.pUrl;
    }

    public void setpUrl(String pUrl) {
        this.pUrl = pUrl;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        int totalCount;
        this.total = totalCount = total > 0 ? total : 0;
        this.pageCount = totalCount / this.rows + (totalCount % this.rows == 0 ? 0 : 1);
        if (totalCount == 0) {
            this.page = DEFAULT_PAGE_INDEX;
        } else if (this.page > this.pageCount) {
            this.page = this.pageCount;
        }
    }

    public boolean isEmpty() {
        return this.total == 0;
    }

    public int getFirstResult() {
        return (this.page - 1) * this.rows;
    }

    public boolean isLastPage() {
        if (this.getPageCount() == 0) {
            return true;
        }
        return this.page == this.getPageCount();
    }

    public boolean isFirstPage() {
        return this.page <= 1;
    }

    static {
        RESPOSE_STATE_DEFAULT = RESPOSE_STATE_ERROR = "0";
    }
}

