/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.mdp.app.bean.AppStatisticsQueryBean;
import pams.function.mdp.app.service.AppStatisticsService;

@Service
public class AppStatisticsServiceImpl
implements AppStatisticsService {
    private static Logger logger = LoggerFactory.getLogger(AppStatisticsServiceImpl.class);
    private SystemConfigService systemConfigService;
    private HttpRequestUtil httpRequest = new HttpRequestUtil();
    private String MDP_URL;

    @Override
    public String getStatisticsList(AppStatisticsQueryBean queryBean) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String ret = this.postJson(this.MDP_URL + "/pamsAppStatisticsContorl/appStatistics.do", JSON.toJSONString((Object)((Object)queryBean)));
        return ret.replace("data", "rows");
    }

    @Override
    public String getAppTypeList() {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        JSONObject queryParam = new JSONObject();
        queryParam.put("dictType", (Object)"APP_FLAG");
        String ret = this.postJson(this.MDP_URL + "/mam/dict/getDictByType.do", queryParam.toJSONString());
        return JSONObject.parseObject((String)ret).getJSONArray("data").toJSONString();
    }

    @Override
    public String getAllAppList(String vestInDepId) {
        this.MDP_URL = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String ret = this.postJson(this.MDP_URL + "/pamsReviewReplyApi/getAllAppList.do" + "?vestInDepId=" + vestInDepId);
        return ret;
    }

    public String postJson(String url, String jsonParam) {
        try {
            if (null == jsonParam) {
                jsonParam = "{}";
            }
            String ret = this.httpRequest.postJson(url, jsonParam);
            logger.info(ret);
            return ret;
        }
        catch (Exception e2) {
            logger.info(e2.getMessage());
            return "";
        }
    }

    public String postJson(String url) {
        return this.postJson(url, "{}");
    }

    @Autowired
    public void setSystemConfigService(SystemConfigService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }
}

