/*
 * Decompiled with CFR 0.152.
 */
package pams.function.mdp.rsms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syn.service.PersonMDPService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.mdp.rsms.bean.QueryBean;
import pams.function.mdp.rsms.bean.ResApplyBean;
import pams.function.mdp.rsms.bean.ResApplyDetail;
import pams.function.mdp.rsms.bean.ResApplyQueryRst;
import pams.function.mdp.rsms.service.ResourceAPIService;

@Controller
@Scope(value="session")
public class ResourceEmpowerMgController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(ResourceEmpowerMgController.class);
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceAPIService resourceAPIService;
    @Autowired
    private PersonMDPService personMDPService;

    @RequestMapping(value={"rsms/resourceempowermgcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        int operateResult = 1;
        String sendUrl = "error/error";
        try {
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)"person", (Object)this.person);
            map.put((Object)"prsUrl", (Object)prsUrl);
        }
        catch (Exception e2) {
            operateResult = 0;
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        return sendUrl;
    }

    @RequestMapping(value={"rsms/resourceempowermgcontroller/query.do"})
    public void queryApplyInfo(HttpServletRequest request, PageParam pageParam, HttpServletResponse response, QueryBean param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            ResApplyQueryRst rqr = this.resourceAPIService.queryResApplyList(param, pageParam);
            map.put("total", rqr.getTotal());
            map.put("rows", rqr.getData());
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f\u5f02\u5e38" + e2.getMessage(), (Throwable)e2);
            map.put("total", "0");
            map.put("rows", new ArrayList());
        }
        String json = Util.toJsonStr(map);
        log.debug("\u67e5\u8be2\u6210\u529f" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"rsms/resourceempowermgcontroller/toCancelPowerPage.do"})
    public String toCancelPowerPage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        try {
            map.addAttribute("person", (Object)this.person);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u7533\u8bf7\u4fe1\u606f\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            return "error/error";
        }
        return "rsms/empower/default/applyInfo";
    }

    @RequestMapping(value={"rsms/resourceempowermgcontroller/toAppResInfoPage.do"})
    public String toAppResInfoPage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String op) {
        try {
            ResApplyBean resApply = this.resourceAPIService.queryResApplyInfo(id);
            HashMap mapResource = new HashMap();
            HashMap mapResApplyDetail = new HashMap();
            for (ResApplyDetail resApplyDetail : resApply.getDetailList()) {
                List<ResApplyDetail> list;
                String resId = resApplyDetail.getResId();
                if (!mapResource.containsKey(resId)) {
                    // empty if block
                }
                if (mapResApplyDetail.containsKey(resId)) {
                    list = (List)mapResApplyDetail.get(resId);
                    list.add(resApplyDetail);
                    continue;
                }
                list = new ArrayList();
                list.add(resApplyDetail);
                mapResApplyDetail.put(resId, list);
            }
            String prsUrl = this.systemConfigService.getValueByCode("prs_url");
            map.put((Object)"prsUrl", (Object)prsUrl);
            map.put((Object)"mapResource", mapResource);
            map.put((Object)"mapResApplyDetail", mapResApplyDetail);
            map.put((Object)"resApply", (Object)resApply);
            map.addAttribute("person", (Object)this.person);
            map.put((Object)"op", (Object)op);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u8d44\u6e90\u7533\u8bf7\u4fe1\u606f\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
            return "error/error";
        }
        return "rsms/empower/default/applyInfo";
    }
}

