/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.common.service.impl;

import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.sbma.common.dao.RegionalismDao;
import pams.function.sbma.common.entity.Regionalism;
import pams.function.sbma.common.service.RegionalismService;

@Service
public class RegionalismServiceImpl
implements RegionalismService {
    @Autowired
    private RegionalismDao regionalismDao;
    @Autowired
    private SystemConfigPbService systemConfigPbService;

    @Override
    public String getNameByCode(String code, boolean isFull) {
        if (isFull) {
            return this.regionalismDao.getFullNameByCode(code, " ");
        }
        return this.regionalismDao.getNameByCode(code);
    }

    @Override
    public List<Regionalism> getAll() {
        return this.regionalismDao.getAll();
    }

    @Override
    public List<Regionalism> getByName(String name) {
        return this.regionalismDao.getByName(name);
    }

    @Override
    public List<Map<String, Object>> getTree(String isSkipLocal) {
        List<Regionalism> all;
        if (Strings.isEmpty((String)isSkipLocal)) {
            all = this.regionalismDao.getAll();
        } else {
            String localCode = this.systemConfigPbService.getValueByCode("regionalismCode");
            all = this.regionalismDao.getAllSkip(localCode);
        }
        return this.createTree(all);
    }

    private List<Map<String, Object>> createTree(List<Regionalism> all) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Regionalism r : all) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", r.getCode());
            map.put("text", r.getName());
            map.put("state", "open");
            Regionalism p = r.findParent(all);
            if (p != null) continue;
            list.add(map);
            List<Regionalism> children = r.findChildren(all);
            if (children == null || children.isEmpty()) continue;
            List<Map<String, Object>> cList = this.buildChildren(children, all);
            map.put("children", cList);
        }
        return list;
    }

    private List<Map<String, Object>> buildChildren(List<Regionalism> children, List<Regionalism> all) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Regionalism r : children) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", r.getCode());
            map.put("text", r.getName());
            map.put("state", "open");
            List<Regionalism> children1 = r.findChildren(all);
            if (children1 != null && !children1.isEmpty()) {
                List<Map<String, Object>> cList = this.buildChildren(children1, all);
                map.put("children", cList);
            }
            list.add(map);
        }
        return list;
    }
}

