/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import pams.function.sbma.common.bean.Pagination;
import pams.function.sbma.common.bean.RestfulQuery;
import pams.function.sbma.common.bean.RestfulResult;
import pams.function.sbma.common.bean.ServiceInterfaceResBean;
import pams.function.sbma.common.dao.BusinessTypeDao;
import pams.function.sbma.common.dao.RegionalismDao;
import pams.function.sbma.common.entity.BusinessType;
import pams.function.sbma.common.entity.Regionalism;
import pams.function.sbma.common.service.SodService;
import pams.function.sbma.resapply.bean.ResourceApplyBean;
import pams.function.sbma.resapply.service.impl.ResourceApplyServiceImpl;

@Service
public class SodServiceImpl
implements SodService {
    private static final Logger logger = LoggerFactory.getLogger(ResourceApplyServiceImpl.class);
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private RegionalismDao regionalismDao;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private BusinessTypeDao businessTypeDao;
    @Autowired
    private BaseDao baseDao;
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss";

    @Override
    public List<Map<String, String>> getDrsList(String regionalismCode, String networkCode) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String sodUrl = this.systemConfigPbService.getValueByCode("sodUrl");
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("networkCode", networkCode);
        param.put("regionalismCode", regionalismCode);
        RestfulQuery<HashMap<String, String>> restfulQuery = new RestfulQuery<HashMap<String, String>>();
        restfulQuery.setMessageId("123");
        restfulQuery.setParameter(param);
        restfulQuery.setVersion("1.0");
        try {
            String returnJson = httpRequestUtil.httpPostJson(sodUrl + "/services/drsList", Util.toJsonStr(restfulQuery));
            logger.debug("sod\u8fd4\u56de\u7ed3\u679c:" + returnJson);
            RestfulResult resBeanRestfulResult = (RestfulResult)JSON.parseObject((String)returnJson, (TypeReference)new TypeReference<RestfulResult<List<ServiceInterfaceResBean>>>(){}, (Feature[])new Feature[0]);
            if (resBeanRestfulResult != null && "200".equals(resBeanRestfulResult.getCode())) {
                List list = (List)resBeanRestfulResult.getData();
                HashMap<String, String> map = null;
                for (ServiceInterfaceResBean resBean : list) {
                    map = new HashMap<String, String>();
                    map.put("code", resBean.getId());
                    map.put("value", resBean.getServiceName());
                    result.add(map);
                }
            } else {
                logger.error("\u83b7\u53d6drs\u5217\u8868\u5931\u8d25" + returnJson);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6drs\u5217\u8868\u5931\u8d25:" + e.getMessage());
        }
        return result;
    }

    @Override
    public List<JSONObject> getAlloPatryList(ResourceApplyBean bean, Page page) {
        String sodUrl = this.systemConfigPbService.getValueByCode("sodUrl");
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pageNo", bean.getPage() + "");
        param.put("pageSize", bean.getRows() + "");
        if (StringUtils.hasText((String)bean.getQueryContent())) {
            param.put("queryContent", bean.getQueryContent());
        }
        if (StringUtils.hasText((String)bean.getRegionalismCode())) {
            param.put("regionalismCode", bean.getRegionalismCode());
        }
        if (bean.getType() != null) {
            param.put("resType", bean.getType() + "");
        }
        RestfulQuery<HashMap<String, String>> restfulQuery = new RestfulQuery<HashMap<String, String>>();
        restfulQuery.setMessageId("123");
        restfulQuery.setParameter(param);
        restfulQuery.setVersion("1.0");
        try {
            String returnJson = httpRequestUtil.httpPostJson(sodUrl + "/resource/allopatryList", Util.toJsonStr(restfulQuery));
            logger.debug("sod\u8fd4\u56de\u7ed3\u679c:" + returnJson);
            RestfulResult resBeanRestfulResult = (RestfulResult)JSON.parseObject((String)returnJson, (TypeReference)new TypeReference<RestfulResult<Pagination>>(){}, (Feature[])new Feature[0]);
            if (resBeanRestfulResult != null && "200".equals(resBeanRestfulResult.getCode())) {
                Pagination pagination = (Pagination)resBeanRestfulResult.getData();
                page.setTotal((int)pagination.getCount());
                List<JSONObject> list = pagination.getData();
                this.format(list);
                return list;
            }
            logger.error("\u83b7\u53d6\u5f02\u5730\u8d44\u6e90\u5217\u8868\u5931\u8d25" + returnJson);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f02\u5730\u8d44\u6e90\u5217\u8868\u5f02\u5e38:" + e.getMessage());
        }
        return new ArrayList<JSONObject>();
    }

    private void format(List<JSONObject> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (JSONObject bean : list) {
            bean.put("regionalismName", (Object)this.regionalismDao.getNameByCode(bean.getString("regionalismCode")));
        }
    }

    @Override
    public JSONObject queryDetail(String resourceId, String regionalismCode) {
        String sodUrl = this.systemConfigPbService.getValueByCode("sodUrl");
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("resId", resourceId);
        param.put("regionalismCode", regionalismCode);
        RestfulQuery<HashMap<String, String>> restfulQuery = new RestfulQuery<HashMap<String, String>>();
        restfulQuery.setMessageId("123");
        restfulQuery.setParameter(param);
        restfulQuery.setVersion("1.0");
        try {
            String returnJson = httpRequestUtil.httpPostJson(sodUrl + "/resource/detail/addressLess", Util.toJsonStr(restfulQuery));
            logger.debug("sod\u8fd4\u56de\u7ed3\u679c:" + returnJson);
            return RestfulResult.checkCodeAndGetData(returnJson);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f02\u5730\u8d44\u6e90\u8be6\u60c5\u5f02\u5e38:" + e.getMessage());
            return null;
        }
    }

    @Override
    @Transactional
    public void syncRegionalism() {
        String sodUrl = this.systemConfigPbService.getValueByCode("sodUrl");
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        RestfulQuery restfulQuery = new RestfulQuery();
        restfulQuery.setMessageId("123");
        restfulQuery.setVersion("1.0");
        try {
            String returnJson = httpRequestUtil.httpPostJson(sodUrl + "/regionalism/list", Util.toJsonStr(restfulQuery));
            logger.debug("sod\u8fd4\u56de\u7ed3\u679c:" + returnJson);
            RestfulResult resBeanRestfulResult = (RestfulResult)JSON.parseObject((String)returnJson, (TypeReference)new TypeReference<RestfulResult<List<Regionalism>>>(){}, (Feature[])new Feature[0]);
            if (resBeanRestfulResult != null && "200".equals(resBeanRestfulResult.getCode())) {
                List list = (List)resBeanRestfulResult.getData();
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return;
                }
                this.regionalismDao.removeAll();
                this.regionalismDao.saveBatch(list);
            } else {
                logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f\u5931\u8d25" + returnJson);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
    }

    @Override
    @Transactional
    public void syncBusinessType() {
        String sodUrl = this.systemConfigPbService.getValueByCode("sodUrl");
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        HashMap<String, String> param = new HashMap<String, String>();
        RestfulQuery<HashMap<String, String>> restfulQuery = new RestfulQuery<HashMap<String, String>>();
        restfulQuery.setMessageId("123");
        restfulQuery.setParameter(param);
        restfulQuery.setVersion("1.0");
        try {
            param.put("lastTimestamp", this.businessTypeDao.getMaxLastUpdateTime() + "");
            restfulQuery.setParameter(param);
            String returnJson = httpRequestUtil.httpPostJson(sodUrl + "/businessType/list", Util.toJsonStr(restfulQuery));
            logger.debug("sod\u8fd4\u56de\u7ed3\u679c:" + returnJson);
            RestfulResult resBeanRestfulResult = (RestfulResult)JSON.parseObject((String)returnJson, (TypeReference)new TypeReference<RestfulResult<List<BusinessType>>>(){}, (Feature[])new Feature[0]);
            if (resBeanRestfulResult != null && "200".equals(resBeanRestfulResult.getCode())) {
                List list = (List)resBeanRestfulResult.getData();
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return;
                }
                for (BusinessType businessType : list) {
                    BusinessType local = this.businessTypeDao.getById(businessType.getCode());
                    if (local != null) {
                        BeanUtils.copyProperties((Object)businessType, (Object)local);
                        this.baseDao.update((Object)local);
                        continue;
                    }
                    this.baseDao.create((Object)businessType);
                }
            } else {
                logger.error("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f\u5931\u8d25" + returnJson);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
    }

    private String getOpenFlagName(Integer openFlag) {
        if (openFlag == null) {
            return "";
        }
        int openFlagI = openFlag;
        return openFlagI == 0 ? "\u4e0d\u516c\u5f00" : (openFlagI == 1 ? "\u516c\u5f00" : "");
    }

    private String getNetWorkName(String netWorkCode) {
        if ("1".equals(netWorkCode)) {
            return "\u4e00\u7c7b";
        }
        if ("2".equals(netWorkCode)) {
            return "\u4e8c\u7c7b";
        }
        if ("3".equals(netWorkCode)) {
            return "\u4e09\u7c7b";
        }
        return "";
    }

    private String getStatusName(Integer status) {
        if (status == null) {
            return "";
        }
        int s = status;
        if (s == 4) {
            return "\u5df2\u4e0a\u67b6";
        }
        if (s == 5) {
            return "\u5df2\u4e0b\u67b6";
        }
        return "";
    }
}

