/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.dict.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.net.URLDecoder;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.sbma.dict.bean.MdpDictBean;
import pams.function.sbma.dict.service.MdpDictService;
import pams.function.sbma.resappmanager.bean.PageBean;

@Service
public class MdpDictServiceImpl
implements MdpDictService {
    private static final Logger logger = LoggerFactory.getLogger(MdpDictServiceImpl.class);
    @Autowired
    private SystemConfigPbService systemConfigService;

    @Override
    public List<MdpDictBean> queryMdpDictList(MdpDictBean mdpDictBean) {
        try {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/sbma/dict/queryDictList.do";
            String param = "?type=json";
            if (StringUtils.isNotBlank((String)mdpDictBean.getParentDictId())) {
                param = param + "&parentDictId=" + mdpDictBean.getParentDictId();
            }
            if (StringUtils.isNotBlank((String)mdpDictBean.getDictId())) {
                param = param + "&dictId=" + mdpDictBean.getDictId();
            }
            if (StringUtils.isNotBlank((String)mdpDictBean.getName())) {
                param = param + "&name=" + mdpDictBean.getName();
            }
            logger.debug("\u83b7\u53d6mdp\u6570\u636e\u5b57\u5178\u5217\u8868url: \u3010{}\u3011, param: \u3010{}\u3011", (Object)url, (Object)param);
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
            JSONObject jsonObject = JSON.parseObject((String)result);
            JSONArray obj = jsonObject.getJSONArray("data");
            List listMdpDictBean = obj.toJavaList(MdpDictBean.class);
            return listMdpDictBean;
        }
        catch (Exception e) {
            logger.error("\u4ecemdp\u83b7\u53d6\u6570\u636e\u5b57\u5178\u5217\u8868\u5931\u8d25: {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateDict(MdpDictBean mdpDictBean) {
        try {
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            String url = mdpUrl + "/sbma/dict/updateDict.do";
            String param = "?type=json&code=" + mdpDictBean.getCode() + "&name=" + mdpDictBean.getName() + "&note=" + mdpDictBean.getNote();
            if (StringUtils.isNotBlank((String)mdpDictBean.getParentDictId())) {
                param = param + "&parentDictId=" + mdpDictBean.getParentDictId();
            }
            if (StringUtils.isNotBlank((String)mdpDictBean.getDictId())) {
                param = param + "&dictId=" + mdpDictBean.getDictId();
            }
            logger.debug("\u4fdd\u5b58/\u66f4\u65b0mdp\u6570\u636e\u5b57\u5178url: \u3010{}\u3011, param: \u3010{}\u3011", (Object)url, (Object)param);
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
            PageBean pageBean = (PageBean)JSON.parseObject((String)result, PageBean.class);
            if (null == pageBean || !PageBean.RESPOSE_STATE_SUCCESS.equals(pageBean.getState())) {
                throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u5931\u8d25: {}", (Throwable)e);
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
        }
    }
}

