/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappapply.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.framework.commons.utils.http.HttpUtils;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.sbma.common.dao.BusinessTypeDao;
import pams.function.sbma.common.dao.RegionalismDao;
import pams.function.sbma.common.service.SodService;
import pams.function.sbma.oplog.entity.OperatLog;
import pams.function.sbma.oplog.service.OperatLogService;
import pams.function.sbma.oplog.service.impl.OperatLogUtil;
import pams.function.sbma.resappapply.bean.AppResourceApplyBean;
import pams.function.sbma.resappapply.dao.AppResourceApplyDao;
import pams.function.sbma.resappapply.dao.AppResourceDao;
import pams.function.sbma.resappapply.entity.AppResource;
import pams.function.sbma.resappapply.entity.AppResourceApply;
import pams.function.sbma.resappapply.service.AppResourceApplyService;
import pams.function.sbma.resmanager.service.ResourceService;

@Service
public class AppResourceApplyServiceImpl
implements AppResourceApplyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppResourceApplyServiceImpl.class);
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private AppResourceApplyDao appResourceApplyDao;
    @Autowired
    private AppResourceDao appResourceDao;
    @Autowired
    private RegionalismDao regionalismDao;
    @Autowired
    private BusinessTypeDao businessTypeDao;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private OperatLogService operatLogService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SodService sodService;

    @Override
    public List<AppResourceApply> appResourceApplyList(AppResourceApplyBean bean, Page page) {
        List<AppResourceApply> list = this.appResourceApplyDao.pageAppResourceApply(bean, page);
        for (AppResourceApply apply : list) {
            this.setApplyInfo(apply, false);
        }
        return list;
    }

    @Override
    public List<AppResourceApply> appResourceApplyListFromMdp(AppResourceApplyBean bean, Page page) {
        block7: {
            try {
                String mdpUrl = this.systemConfigPbService.getValueByCode("MDP_SERVER_URL");
                String url = mdpUrl + "/appResource/applyList.do";
                String result = this.getMdpData(url, bean);
                if (Strings.isEmpty((String)result)) {
                    throw new Exception("\u83b7\u53d6\u5e94\u7528\u8d44\u6e90\u7533\u8bf7\u5217\u8868\u5f02\u5e38");
                }
                JSONObject jsonObject = JSON.parseObject((String)result);
                String code = jsonObject.getString("code");
                if (!"500".equals(code)) {
                    int total = jsonObject.getIntValue("total");
                    page.setTotal(total);
                    JSONArray jsonArray = jsonObject.getJSONArray("applyList");
                    if (jsonArray != null && !jsonArray.isEmpty()) {
                        List list = jsonArray.toJavaList(AppResourceApply.class);
                        if (list != null && !list.isEmpty()) {
                            for (AppResourceApply apply : list) {
                                this.setApplyInfo(apply, false);
                            }
                        }
                        return list;
                    }
                    break block7;
                }
                throw new Exception(jsonObject.getString("message"));
            }
            catch (Exception e) {
                LOGGER.error("\u4ecemdp\u83b7\u53d6\u8d44\u6e90\u5e94\u7528\u7533\u8bf7\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return Collections.emptyList();
    }

    private String getMdpData(String url, Object param) {
        try {
            ResponseWrap responseWrap = HttpUtils.post((String)url).addJson(param).execute();
            int code = responseWrap.getStatusCode();
            if (200 == code) {
                return responseWrap.getString();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4ecemdp\u83b7\u53d6\u6570\u636e\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    @Override
    public AppResourceApply getById(String applyId) {
        AppResourceApply apply = this.appResourceApplyDao.getByApplyId(applyId);
        this.setApplyInfo(apply, true);
        return apply;
    }

    @Override
    public JSONObject getResouceDetail(String resourceId, String resourceRegionalismCode) throws Exception {
        String localRegionalCode = this.systemConfigPbService.getValueByCode("regionalismCode");
        if (resourceRegionalismCode.equals(localRegionalCode)) {
            return this.resourceService.queryById(resourceId);
        }
        return this.sodService.queryDetail(resourceId, resourceRegionalismCode);
    }

    @Override
    public List<AppResourceApply> getResourceOfAppByAppInfo(String regionalismCode, String appId) {
        List<AppResourceApply> list = this.appResourceApplyDao.getAppResourceApplyInfo(regionalismCode, appId);
        for (AppResourceApply apply : list) {
            this.setApplyInfo(apply, false);
        }
        return list;
    }

    @Override
    public List<AppResourceApply> getResourceOfAppByAppInfoFromMdp(String appId) throws Exception {
        String mdpUrl = this.systemConfigPbService.getValueByCode("MDP_SERVER_URL");
        String url = mdpUrl + "/appResource/applyList.do";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appId", appId);
        param.put("page", 1);
        param.put("rows", Integer.MAX_VALUE);
        String result = this.getMdpData(url, param);
        if (Strings.isEmpty((String)result)) {
            throw new Exception("\u83b7\u53d6\u5e94\u7528\u8d44\u6e90\u7533\u8bf7\u5217\u8868\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        String code = jsonObject.getString("code");
        if (!"500".equals(code)) {
            JSONArray jsonArray = jsonObject.getJSONArray("applyList");
            if (jsonArray != null && !jsonArray.isEmpty()) {
                List list = jsonArray.toJavaList(AppResourceApply.class);
                if (list != null && !list.isEmpty()) {
                    for (AppResourceApply apply : list) {
                        this.setApplyInfo(apply, false);
                    }
                }
                return list;
            }
        } else {
            throw new Exception(jsonObject.getString("message"));
        }
        return null;
    }

    private String getStatusName(Integer status) {
        if (status == null) {
            return "";
        }
        int s = status;
        if (s == 5) {
            return "\u7981\u7528(\u4e0b\u67b6)";
        }
        if (s == 4) {
            return "\u542f\u7528(\u4e0a\u67b6)";
        }
        return "";
    }

    private String getOpenFlagName(Integer openFlag) {
        if (openFlag == null) {
            return "";
        }
        int openFlagI = openFlag;
        return openFlagI == 0 ? "\u4e0d\u516c\u5f00" : (openFlagI == 1 ? "\u516c\u5f00" : "");
    }

    private void setApplyInfo(AppResourceApply apply, boolean isFullDivisionName) {
        try {
            String resRegionalName;
            String appRegionalName = this.regionalismDao.getFullNameByCode(apply.getAppRegionalismCode(), " ");
            apply.setAppRegionalismName(appRegionalName);
            if (isFullDivisionName) {
                resRegionalName = this.regionalismDao.getFullNameByCode(apply.getResourceRegionalismCode(), " ");
                apply.setResourceRegionalismName(resRegionalName);
            } else {
                resRegionalName = this.regionalismDao.getNameByCode(apply.getResourceRegionalismCode());
                apply.setResourceRegionalismName(resRegionalName);
            }
            String resBusinessTypeName = this.businessTypeDao.getNameByCode(apply.getResourceBusinessType());
            apply.setResourceBusinessTypeName(resBusinessTypeName);
            String localRegionalCode = this.systemConfigPbService.getValueByCode("regionalismCode");
            apply.setIsLocalApp(apply.getAppRegionalismCode().equals(localRegionalCode) ? "1" : "0");
            apply.setIsLocalRes(apply.getResourceRegionalismCode().equals(localRegionalCode) ? "1" : "0");
            String statusName = "";
            if (0 == apply.getApplyStatus()) {
                statusName = "\u5ba1\u6838\u4e2d";
            }
            if (1 == apply.getApplyStatus()) {
                statusName = "\u901a\u8fc7";
            }
            if (2 == apply.getApplyStatus()) {
                statusName = "\u62d2\u7edd";
            }
            if (3 == apply.getApplyStatus()) {
                statusName = "\u53d6\u6d88";
            }
            apply.setStatusShow(statusName);
            String typeName = this.commonCodePbService.getCodeNameByCode(apply.getResourceType() + "", "sbma_restype");
            apply.setResourceTypeShow(typeName);
            apply.setCreateTimeShow(Util.getDate((String)FORMAT, (Date)new Date(apply.getCreateTime())));
            apply.setLastUpdateTimeShow(Util.getDate((String)FORMAT, (Date)new Date(apply.getLastUpdateTime())));
            apply.setResourceNetWorkName(this.getNetWorkName(apply.getResourceNetworkCode()));
            apply.setAppNetWorkName(this.getNetWorkName(apply.getAppNetworkCode()));
            JSONObject resource = null;
            if (StringUtils.isEmpty((String)apply.getResourceName()) || StringUtils.isEmpty((String)apply.getResourceTypeShow())) {
                resource = this.resourceService.queryById(apply.getResourceId());
            }
            if (StringUtils.isEmpty((String)apply.getResourceName()) && resource != null) {
                apply.setResourceName(resource.getString("name"));
            }
            if (StringUtils.isEmpty((String)apply.getResourceTypeShow()) && resource != null) {
                apply.setResourceTypeShow(this.commonCodePbService.getCodeNameByCode(resource.getString("type") + "", "sbma_restype"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4fe1\u606f\u8be6\u60c5\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String getNetWorkName(String netWorkCode) {
        if ("1".equals(netWorkCode)) {
            return "\u4e00\u7c7b";
        }
        if ("2".equals(netWorkCode)) {
            return "\u4e8c\u7c7b";
        }
        if ("3".equals(netWorkCode)) {
            return "\u4e09\u7c7b";
        }
        return "";
    }

    @Override
    @Transactional
    public void doAccredit(Person opt, String applyId, int status) throws Exception {
        AppResourceApply apply = this.appResourceApplyDao.getByApplyId(applyId);
        if (apply == null) {
            throw new Exception("\u6ca1\u6709\u5bf9\u5e94\u7684\u7533\u8bf7\u8bb0\u5f55");
        }
        if (!this.isApplyStatusLegal(status)) {
            throw new Exception("\u64cd\u4f5c\u72b6\u6001\u5f02\u5e38");
        }
        apply.setApplyStatus(status);
        boolean isUpdate = this.appResourceApplyDao.updateAppResourceApply(apply);
        if (isUpdate) {
            boolean flag;
            OperatLog log = OperatLogUtil.createLog(opt, apply.getResourceId(), apply.getResourceName(), apply.getAppId(), apply.getAppName(), apply.getAppRegionalismCode(), apply.getResourceRegionalismCode(), null);
            LOGGER.debug("\u4fee\u6539\u5e94\u7528\u8d44\u6e90\u6388\u6743\u72b6\u6001\u6210\u529f");
            if (status == 1) {
                AppResource appResource = this.appResourceDao.getAppResource(apply.getAppId(), apply.getAppRegionalismCode(), apply.getAppNetworkCode(), apply.getResourceId(), apply.getResourceRegionalismCode(), apply.getResourceNetworkCode());
                if (appResource != null) {
                    appResource.setStatus(1);
                    flag = this.appResourceDao.updateAppResource(appResource);
                } else {
                    AppResource res = this.applyToFormal(apply);
                    flag = this.appResourceDao.applyToFormal(res);
                }
                log.setType("6");
            } else if (status == 3) {
                flag = this.appResourceDao.removeFormalAppResource(apply.getAppId(), apply.getAppRegionalismCode(), apply.getAppNetworkCode(), apply.getResourceId(), apply.getResourceRegionalismCode(), apply.getResourceNetworkCode());
                log.setType("7");
            } else {
                flag = true;
                log.setType("8");
            }
            if (!flag) {
                throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
            }
            this.operatLogService.addOptLog(log);
        }
    }

    @Override
    public void doAccreditToSmd(Person opt, String applyId, int status, String appRegionalismCode, String applyDesc) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appResourceApplyId", applyId);
        param.put("appRegionalismCode", appRegionalismCode);
        param.put("applyResult", applyDesc);
        param.put("status", status);
        String smdUrl = this.systemConfigPbService.getValueByCode("smdUrl");
        String url = smdUrl + "/appResource/auditFeedback";
        ResponseWrap responseWrap = HttpUtils.post((String)url).addJson(param).execute();
        if (200 == responseWrap.getStatusCode()) {
            String result = responseWrap.getString();
            LOGGER.debug("smd\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            JSONObject jsonObject = JSON.parseObject((String)result);
            boolean flag = jsonObject.getBoolean("result");
            if (!flag) {
                throw new Exception("\u64cd\u4f5c\u5931\u8d25");
            }
            return;
        }
        throw new Exception("\u64cd\u4f5c\u5931\u8d25");
    }

    private AppResource applyToFormal(AppResourceApply apply) {
        AppResource res = new AppResource();
        res.setAppId(apply.getAppId());
        res.setAppNetworkCode(apply.getAppNetworkCode());
        res.setAppRegionalismCode(apply.getAppRegionalismCode());
        res.setCreateTime(System.currentTimeMillis());
        res.setResourceId(apply.getResourceId());
        res.setResourceNetworkCode(apply.getResourceNetworkCode());
        res.setResourceRegionalismCode(apply.getResourceRegionalismCode());
        res.setStatus(1);
        return res;
    }

    private boolean isApplyStatusLegal(int status) {
        return status == 3 || status == 2 || status == 0 || status == 1;
    }
}

