/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resapply.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.common.bean.RestfulResult;
import pams.function.sbma.oplog.entity.OperatLog;
import pams.function.sbma.oplog.service.OperatLogService;
import pams.function.sbma.oplog.service.impl.OperatLogUtil;
import pams.function.sbma.resapply.bean.ResourceApplyBean;
import pams.function.sbma.resapply.bean.ReviewResBean;
import pams.function.sbma.resapply.service.ResourceApplyService;
import pams.function.sbma.resmanager.service.ResourceService;
import pams.function.sbma.resregist.service.RegistService;

@Controller
@Scope(value="session")
public class ResourceApplyController
extends BaseControler {
    private static Logger logger = LoggerFactory.getLogger(ResourceApplyController.class);
    @Autowired
    private ResourceApplyService resourceApplyService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private OperatLogService operatLogService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private RegistService registService;

    @RequestMapping(value={"/sbma/ResourceApplyController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            modelMap.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/queryList.do"})
    public void queryList(ResourceApplyBean queryBean, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            JSONObject jsonObject = this.resourceApplyService.queryList(queryBean);
            result.put("total", jsonObject.get((Object)"count"));
            result.put("rows", jsonObject.get((Object)"data"));
            result.put("flag", "1");
        }
        catch (Exception e) {
            result.put("total", "0");
            result.put("rows", Collections.EMPTY_LIST);
            result.put("flag", "0");
            logger.error("\u83b7\u53d6\u8fc7\u7a0b\u8d44\u6e90\u5217\u8868\u5931\u8d25" + e.getMessage());
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/toApproval.do"})
    public String toApproval(String resourceApplyId, ModelMap map) {
        map.put((Object)"resourceApplyId", (Object)resourceApplyId);
        return "sbma/resapply/default/approval";
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/toDetail.do"})
    public String toDetail(String resourceApplyId, ModelMap map) {
        try {
            map.put((Object)"resourceApplyId", (Object)resourceApplyId);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8df3\u8f6c\u8be6\u60c5\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "sbma/resapply/default/detail";
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/getDetail.do"})
    public void getDetail(String resourceApplyId, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject jsonObject = this.registService.getResApply(resourceApplyId);
            map.put("res", jsonObject);
            map.put("flag", true);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u7533\u8bf7\u8be6\u60c5\u5931\u8d25" + e.getMessage());
            map.put("flag", false);
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/sbma/ResourceApplyController/getResourceDetail.do"})
    public void getResourceDetail(String resourceApplyId, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject applyBeam = this.registService.getResApply(resourceApplyId);
            JSONObject resourceInfo = this.resourceService.queryById(applyBeam.getString("resourceId"));
            map.put("res", resourceInfo);
            map.put("flag", true);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u8be6\u60c5\u5931\u8d25" + e.getMessage());
            map.put("flag", false);
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sbma/ResourceApplyController/approval.do"})
    public void approval(ReviewResBean reviewResBean, HttpServletResponse response, HttpServletRequest request, ModelMap map) {
        String restfulResult;
        try {
            String identifier = this.getOperator(request).getPerson().getIdentifier();
            String depCode = this.getOperator(request).getPerson().getDepartment().getCode();
            reviewResBean.setApproverIdentifier(Strings.isEmpty((String)identifier) ? "0" : identifier);
            reviewResBean.setOwnerDepCode(depCode);
            reviewResBean.setOwnerIdentifier(Strings.isEmpty((String)identifier) ? "0" : identifier);
            restfulResult = this.resourceApplyService.review(reviewResBean);
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u8d44\u6e90\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            restfulResult = JSON.toJSONString(RestfulResult.create("", "", "500", e.getMessage(), null));
        }
        finally {
            this.saveOperatLog(reviewResBean.getResourceApplyId(), "1");
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)restfulResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sbma/ResourceApplyController/publish.do"})
    public void publish(String resourceApplyId, HttpServletResponse response, HttpServletRequest request, ModelMap map) {
        String restfulResult;
        try {
            String operatorId = this.getOperator(request).getPerson().getId();
            restfulResult = this.resourceApplyService.publish(resourceApplyId, operatorId);
        }
        catch (Exception e) {
            logger.error("\u53d1\u5e03\u8d44\u6e90\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            restfulResult = JSON.toJSONString(RestfulResult.create("", "", "500", e.getMessage(), null));
        }
        finally {
            this.saveOperatLog(resourceApplyId, "2");
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)restfulResult);
    }

    private void saveOperatLog(String resourceApplyId, String type) {
        JSONObject jsonObject = this.registService.getResApply(resourceApplyId);
        if (jsonObject != null) {
            OperatLog operatLog = OperatLogUtil.createLog(this.operator.getPerson(), jsonObject.getString("resourceId"), jsonObject.getString("name"), "", "", "", jsonObject.getString("regionalismCode"), type);
            this.operatLogService.addOptLog(operatLog);
        }
    }
}

