/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resmanager.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.common.bean.RestfulResult;
import pams.function.sbma.common.entity.Regionalism;
import pams.function.sbma.common.service.RegionalismService;
import pams.function.sbma.oplog.entity.OperatLog;
import pams.function.sbma.oplog.service.OperatLogService;
import pams.function.sbma.oplog.service.impl.OperatLogUtil;
import pams.function.sbma.resapply.bean.ResourceApplyBean;
import pams.function.sbma.resmanager.service.ResourceService;

@Controller
@Scope(value="session")
public class SbmaResourceController
extends BaseControler {
    private static Logger logger = LoggerFactory.getLogger(SbmaResourceController.class);
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private RegionalismService regionalismService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private OperatLogService operatLogService;

    @RequestMapping(value={"/sbma/ResourceController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            modelMap.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/ResourceController/queryList.do"})
    public void queryList(ResourceApplyBean queryBean, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            JSONObject jsonObject = this.resourceService.queryList(queryBean);
            result.put("rows", jsonObject.get((Object)"data"));
            result.put("total", jsonObject.get((Object)"count"));
            result.put("flag", "1");
        }
        catch (Exception e) {
            result.put("flag", "0");
            result.put("rows", Collections.emptyList());
            result.put("total", "0");
            logger.error("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u5217\u8868\u5931\u8d25" + e.getMessage());
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/sbma/ResourceController/toDetail.do"})
    public String toDetail(String resourceId, ModelMap map) {
        try {
            map.put((Object)"resourceId", (Object)resourceId);
        }
        catch (Exception e) {
            logger.error("\u524d\u5f80\u8d44\u6e90\u8be6\u60c5\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "sbma/resmanager/default/detail";
    }

    @RequestMapping(value={"/sbma/ResourceController/getDetail.do"})
    public void getDetail(String resourceId, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject bean = this.resourceService.queryById(resourceId);
            map.put("res", bean);
            map.put("flag", true);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u8be6\u60c5\u5931\u8d25" + e.getMessage());
            map.put("flag", false);
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sbma/ResourceController/upOrDown.do"})
    public void upOrDown(ResourceApplyBean queryBean, HttpServletResponse response, HttpServletRequest request, ModelMap map) {
        String result;
        try {
            queryBean.setOperatorId(this.getOperator(request).getPerson().getId());
            result = this.resourceService.upOrDown(queryBean);
            this.saveOperatLog(queryBean.getResourceId(), queryBean.getStatus() == 4 ? "3" : "4");
        }
        catch (Exception e) {
            try {
                logger.error("\u4fee\u6539\u8d44\u6e90\u72b6\u6001\u5f02\u5e38" + e.getMessage());
                result = JSON.toJSONString(RestfulResult.create("", "", "500", e.getMessage(), null));
                this.saveOperatLog(queryBean.getResourceId(), queryBean.getStatus() == 4 ? "3" : "4");
            }
            catch (Throwable throwable) {
                this.saveOperatLog(queryBean.getResourceId(), queryBean.getStatus() == 4 ? "3" : "4");
                throw throwable;
            }
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)result);
    }

    @RequestMapping(value={"/sbma/ResourceController/toSetPublishScope.do"})
    public String toSetPublishScope(String resourceId, String networkCode, String regionalismCode, ModelMap modelMap) {
        try {
            List<Regionalism> allReleaseScope = this.regionalismService.getAll();
            JSONObject jsonObject = this.resourceService.queryResourceScopeList(resourceId);
            JSONArray scopes = jsonObject.getJSONArray("scopes");
            modelMap.put((Object)"allRegionalismScope", (Object)JSON.toJSONString(allReleaseScope));
            modelMap.put((Object)"networkCode", (Object)networkCode);
            modelMap.put((Object)"regionalismCode", (Object)regionalismCode);
            modelMap.put((Object)"regionalismCodes", (Object)this.getRegionalismCodes(scopes));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "error/error";
        }
        return "sbma/resmanager/default/releaseScope";
    }

    @RequestMapping(value={"/sbma/ResourceController/toEdit.do"})
    public String toEdit(String id, String type, ModelMap modelMap) {
        try {
            modelMap.addAttribute("id", (Object)id);
            modelMap.addAttribute("type", (Object)type);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "error/error";
        }
        return "sbma/resmanager/default/resApplyInfo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sbma/ResourceController/setPublishScope.do"})
    public void setPublishScope(ResourceApplyBean queryBean, HttpServletResponse response, HttpServletRequest request, ModelMap map) {
        String result;
        try {
            result = this.resourceService.setPublishScope(queryBean);
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u53d1\u5e03\u8d44\u6e90\u8303\u56f4\u5f02\u5e38" + e.getMessage());
            result = JSON.toJSONString(RestfulResult.create("", "", "500", e.getMessage(), null));
        }
        finally {
            this.saveOperatLog(queryBean.getResourceId(), "5");
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)result);
    }

    private String getRegionalismCodes(JSONArray resReleaseScope) {
        if (CollectionUtils.isEmpty((Collection)resReleaseScope)) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (Object o : resReleaseScope) {
            String scope = (String)o;
            str.append(scope).append(",");
        }
        return str.substring(0, str.length() - 1);
    }

    private List<Map<String, String>> getAllNetworkScope(String networkCode) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> allNetworkScope1 = new HashMap<String, String>();
        if ("1".equals(networkCode) || "2".equals(networkCode)) {
            allNetworkScope1.put("code", "1");
            allNetworkScope1.put("name", "\u4e00\u7c7b\u533a\u57df");
            list.add(allNetworkScope1);
            HashMap<String, String> allNetworkScope2 = new HashMap<String, String>();
            allNetworkScope2.put("code", "2");
            allNetworkScope2.put("name", "\u4e8c\u7c7b\u533a\u57df");
            list.add(allNetworkScope2);
        } else if ("3".equals(networkCode)) {
            HashMap<String, String> allNetworkScope2 = new HashMap<String, String>();
            allNetworkScope2.put("code", "2");
            allNetworkScope2.put("name", "\u4e8c\u7c7b\u533a\u57df");
            list.add(allNetworkScope2);
            HashMap<String, String> allNetworkScope3 = new HashMap<String, String>();
            allNetworkScope3.put("code", "3");
            allNetworkScope3.put("name", "\u4e09\u7c7b\u533a\u57df");
            list.add(allNetworkScope3);
        }
        return list;
    }

    private void saveOperatLog(String resourceId, String type) {
        JSONObject resourceBean = this.resourceService.queryById(resourceId);
        if (resourceBean != null) {
            OperatLog operatLog = OperatLogUtil.createLog(this.operator.getPerson(), resourceBean.getString("resourceId"), resourceBean.getString("name"), "", "", "", resourceBean.getString("regionalismCode"), type);
            this.operatLogService.addOptLog(operatLog);
        }
    }
}

