/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.dict.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.dict.bean.MdpDictBean;
import pams.function.sbma.dict.service.MdpDictService;

@Controller
@Scope(value="session")
public class MdpDictControl
extends BaseControler {
    private static final Logger logger = LoggerFactory.getLogger(MdpDictControl.class);
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private MdpDictService mdpDictService;

    @RequestMapping(value={"/sbma/mdpDictControl/index.do"})
    public String index(ModelMap map, PageParam pageParam, HttpServletRequest request) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, pageParam.getMenuId(), pageParam.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/mdpDictControl/queryMdpDictList.do"})
    public void queryMdpDictList(MdpDictBean mdpDictBean, HttpServletResponse response) {
        try {
            List<MdpDictBean> listMdpDictBean = this.mdpDictService.queryMdpDictList(mdpDictBean);
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(listMdpDictBean));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6mdp\u6570\u636e\u5b57\u5178\u5217\u8868\u5931\u8d25: {}", (Throwable)e);
        }
    }

    @RequestMapping(value={"/sbma/mdpDictControl/queryMdpDictListByDictName.do"})
    public void queryMdpDictListByDictName(String q, HttpServletResponse response) {
        try {
            MdpDictBean mdpDictBean = new MdpDictBean();
            mdpDictBean.setName(q);
            mdpDictBean.setParentDictId("0");
            List<MdpDictBean> listMdpDictBean = this.mdpDictService.queryMdpDictList(mdpDictBean);
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(listMdpDictBean));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6mdp\u6570\u636e\u5b57\u5178\u5217\u8868\u5931\u8d25: {}", (Throwable)e);
        }
    }

    @RequestMapping(value={"/sbma/mdpDictControl/queryMdpDictByDictId.do"})
    public void queryMdpDictByDictId(MdpDictBean mdpDictBean, HttpServletResponse response) {
        try {
            List<MdpDictBean> listMdpDictBean = this.mdpDictService.queryMdpDictList(mdpDictBean);
            MdpDictBean mdpDictBean2 = null;
            if (null != listMdpDictBean && listMdpDictBean.size() == 1) {
                mdpDictBean2 = listMdpDictBean.get(0);
            }
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mdpDictBean2));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6mdp\u6570\u636e\u5b57\u5178\u8be6\u60c5\u5931\u8d25: {}", (Throwable)e);
        }
    }

    @RequestMapping(value={"/sbma/mdpDictControl/getTreeChild.do"})
    public void getTreeChild(String id, HttpServletResponse response) {
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                id = "0";
            }
            MdpDictBean mdpDictBean = new MdpDictBean();
            mdpDictBean.setParentDictId(id);
            List<MdpDictBean> listMdpDictBean = this.mdpDictService.queryMdpDictList(mdpDictBean);
            ArrayList treelist = new ArrayList();
            for (MdpDictBean code : listMdpDictBean) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", code.getDictId());
                map.put("text", code.getName());
                map.put("state", "closed");
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("selectAble", "true");
                attributes.put("code", code.getCode());
                attributes.put("name", code.getName());
                map.put("attributes", attributes);
                treelist.add(map);
            }
            String jsonlist = Util.toJsonStr(treelist);
            if (StringUtils.isBlank((CharSequence)id)) {
                jsonlist = "[{\"text\":\"\u5b57\u5178\u7c7b\u578b\",\"checked\":\"true\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
            } else {
                MdpDictBean mdpDictBean2 = new MdpDictBean();
                mdpDictBean2.setDictId(id);
                List<MdpDictBean> listMdpDictBean2 = this.mdpDictService.queryMdpDictList(mdpDictBean2);
                if (null != listMdpDictBean2 && listMdpDictBean2.size() == 1) {
                    mdpDictBean2 = listMdpDictBean2.get(0);
                    jsonlist = "[{\"id\":\"" + mdpDictBean2.getDictId() + "\",\"text\":\"" + mdpDictBean2.getName() + "\",\"checked\":\"true\",\"attributes\":{\"selectAble\":\"true\"},\"children\":" + jsonlist + "}]";
                }
            }
            Util.writeUtf8Text((HttpServletResponse)response, (String)jsonlist);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6mdp\u6570\u636e\u5b57\u5178\u5217\u8868\u5931\u8d25: {}", (Throwable)e);
        }
    }

    @RequestMapping(value={"/sbma/mdpDictControl/addType.do"})
    public String addType(String dictId, ModelMap map) {
        if (StringUtils.isNotBlank((CharSequence)dictId)) {
            map.put((Object)"dictId", (Object)dictId);
        }
        return "sbma/dict/default/addType";
    }

    @RequestMapping(value={"/sbma/mdpDictControl/addCode.do"})
    public String addCode(MdpDictBean mdpDictBean, ModelMap map) {
        map.put((Object)"parentDictId", (Object)mdpDictBean.getParentDictId());
        MdpDictBean mdpDictBean2 = new MdpDictBean();
        mdpDictBean2.setDictId(mdpDictBean.getParentDictId());
        List<MdpDictBean> listMdpDictBeans = this.mdpDictService.queryMdpDictList(mdpDictBean2);
        if (null != listMdpDictBeans && listMdpDictBeans.size() == 1) {
            map.put((Object)"parentDictName", (Object)listMdpDictBeans.get(0).getName());
        }
        if (StringUtils.isNotBlank((CharSequence)mdpDictBean.getDictId())) {
            map.put((Object)"dictId", (Object)mdpDictBean.getDictId());
        }
        return "sbma/dict/default/addCode";
    }

    @RequestMapping(value={"/sbma/mdpDictControl/updateDict.do"})
    public void updateDict(MdpDictBean mdpDictBean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        HashMap<String, String> rst = new HashMap<String, String>();
        try {
            if (StringUtils.isBlank((CharSequence)mdpDictBean.getCode()) || StringUtils.isBlank((CharSequence)mdpDictBean.getName())) {
                rst.put("flag", "0");
                rst.put("message", "\u53c2\u6570\u9519\u8bef");
                logger.error("\u4fdd\u5b58mdp\u6570\u636e\u5b57\u5178\u5931\u8d25\uff0c\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
            }
            this.mdpDictService.updateDict(mdpDictBean);
            rst.put("flag", "1");
            rst.put("message", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58mdp\u6570\u636e\u5b57\u5178\u5931\u8d25: {}", (Throwable)e);
            rst.put("flag", "0");
            rst.put("message", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(rst));
    }
}

