/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappmanager.dao.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basedao.BaseDao;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.sbma.resappmanager.bean.PowerBean;
import pams.function.sbma.resappmanager.dao.AppPowerViewDao;
import pams.function.sbma.resappmanager.entity.AppPowerView;

@Repository
public class AppPowerViewDaoImpl
implements AppPowerViewDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public void insert(AppPowerView appPowerView) {
        this.baseDao.create((Object)appPowerView);
    }

    @Override
    public void insertBatch(List<AppPowerView> appPowerViewList) {
        this.baseDao.createBatch(appPowerViewList);
    }

    @Override
    public void delete(AppPowerView appPowerView) {
        this.baseDao.delete((Object)appPowerView);
    }

    @Override
    public List<PowerBean> query(AppPowerView appPowerView) {
        StringBuilder sql = new StringBuilder();
        if ("person".equals(appPowerView.getType())) {
            sql.append("select p.id,p.code,p.name from t_person p left join T_SBMA_APP_POWER_VIEW t on p.id = t.area_id where p.flag = '0'");
        } else if ("dep".equals(appPowerView.getType())) {
            sql.append("select d.id,d.code,d.name from t_department d left join T_SBMA_APP_POWER_VIEW t on d.id = t.area_id where d.flag = '0'");
        } else if ("group".equals(appPowerView.getType())) {
            sql.append("select g.id,g.name from t_bims_group g left join T_SBMA_APP_POWER_VIEW t on g.id = t.area_id where g.flag = '0'");
        } else {
            sql.append("select c.id,c.code,c.name, from t_commoncode c left join T_SBMA_APP_POWER_VIEW t on c.id = t.area_id where g.status = '1'");
        }
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)appPowerView.getAppId())) {
            sql.append(" and t.app_id = ?");
            params.add(appPowerView.getAppId());
        }
        if (StringUtils.isNotBlank((CharSequence)appPowerView.getAppRegionalismCode())) {
            sql.append(" and t.app_regionalism_code = ?");
            params.add(appPowerView.getAppRegionalismCode());
        }
        if (StringUtils.isNotBlank((CharSequence)appPowerView.getType())) {
            sql.append(" and t.type = ?");
            params.add(appPowerView.getType());
        }
        return this.baseDao.getListBySQL(sql.toString(), params.toArray(), PowerBean.class);
    }

    @Override
    public List<Person> queryPersonIdBySql(String sql) {
        return this.baseDao.getListBySQL(sql, null, Person.class);
    }

    @Override
    public void deleteBatch(List<String> areaIds, String type, String appId, String appRegionalismCode) {
        ArrayList<Object> params = new ArrayList<Object>();
        String sql = "delete from T_SBMA_APP_POWER_VIEW t where t.app_id=? and t.app_regionalism_code = ? and t.type = ? and t.area_id in(:areaIds) ";
        params.add(appId);
        params.add(appRegionalismCode);
        params.add(type);
        params.add(areaIds);
        ArrayList<String> nameKeys = new ArrayList<String>();
        nameKeys.add("areaIds");
        this.baseDao.updateBySql(sql, params.toArray(), nameKeys);
    }
}

