/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.RestfulQuery;
import com.xdja.pams.common.bean.RestfulResult;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.getwayapi.httpservice.client.HttpRequestUtil;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.syn.service.PersonMDPService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import pams.function.sbma.common.entity.Regionalism;
import pams.function.sbma.common.service.RegionalismService;
import pams.function.sbma.resappmanager.bean.AppBean;
import pams.function.sbma.resappmanager.bean.AppUseArea;
import pams.function.sbma.resappmanager.bean.AppUseAreaForm;
import pams.function.sbma.resappmanager.bean.GreyAppBeanResult;
import pams.function.sbma.resappmanager.bean.GreyAppParam;
import pams.function.sbma.resappmanager.bean.GreyPersonDeviceInfo;
import pams.function.sbma.resappmanager.bean.GreyReleasedParam;
import pams.function.sbma.resappmanager.bean.PageBean;
import pams.function.sbma.resappmanager.bean.PageBeanList;
import pams.function.sbma.resappmanager.bean.RegionalismBean;
import pams.function.sbma.resappmanager.bean.TmpAppPicture;
import pams.function.sbma.resappmanager.bean.TmpAppUsesPermission;
import pams.function.sbma.resappmanager.service.SbmaAppManagerService;

@Service
public class SbmaAppManagerServiceImpl
implements SbmaAppManagerService {
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    CommonCodePbService commonCodePbService;
    @Autowired
    UserManageService userManageService;
    @Autowired
    PersonMDPService personMDPService;
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private RegionalismService regionalismService;
    private static final Logger log = LoggerFactory.getLogger(SbmaAppManagerServiceImpl.class);
    @Autowired
    private BaseDao baseDao;

    @Override
    public String queryList(AppBean appBean, PageParam page) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/queryAppListTmp.do?type=json";
        if ("1".equals(appBean.getApplyStatus()) && "1".equals(appBean.getPublishStatus())) {
            url = pamsUrl + "/appManagerControl/queryAppList.do?type=json";
        }
        if ("1".equals(appBean.getApplyStatus()) && "1".equals(appBean.getPublishStatus()) && "2".equals(appBean.getPublishType())) {
            return this.getGreyReleased(appBean, page);
        }
        String param = "&mdpOperatorUserId=" + appBean.getMdpOperatorUserId();
        param = param + "&vestInDepId=" + appBean.getVestInDepId();
        if (!Util.varCheckEmp((String)appBean.getQueryKey())) {
            param = param + "&queryKey=" + appBean.getQueryKey();
        }
        if (!Util.varCheckEmp((String)appBean.getApplyStatus())) {
            param = param + "&applyStatus=" + appBean.getApplyStatus();
        }
        param = !Util.varCheckEmp((String)appBean.getPublishStatus()) ? param + "&publishStatus=" + appBean.getPublishStatus() : param + "&publishStatus=0";
        if (!Util.varCheckEmp((String)appBean.getAppStatus())) {
            param = param + "&appStatus=" + appBean.getAppStatus();
        }
        if (!Util.varCheckEmp((String)page.getRows())) {
            param = param + "&rows=" + page.getRows();
        }
        if (!Util.varCheckEmp((String)page.getPage())) {
            param = param + "&page=" + page.getPage();
        }
        if (!Util.varCheckEmp((String)appBean.getCreateTimeStart())) {
            param = param + "&createTimeStart=" + appBean.getCreateTimeStart();
        }
        if (!Util.varCheckEmp((String)appBean.getCreateTimeEnd())) {
            param = param + "&createTimeEnd=" + appBean.getCreateTimeEnd();
        }
        if (!Util.varCheckEmp((String)appBean.getCreateUserId())) {
            param = param + "&createUserId=" + appBean.getCreateUserId();
        }
        if (!Util.varCheckEmp((String)appBean.getAppRecommendStatus())) {
            param = param + "&appRecommendStatus=" + appBean.getAppRecommendStatus();
        }
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        result = result.replace("data", "rows");
        return result;
    }

    @Override
    public String queryAppFirstAuditList(AppBean appBean, PageParam page) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/queryFirstAppListTmp.do?type=json";
        String param = "&mdpOperatorUserId=" + appBean.getMdpOperatorUserId();
        if (!Util.varCheckEmp((String)appBean.getQueryKey())) {
            param = param + "&queryKey=" + appBean.getQueryKey();
        }
        if (!Util.varCheckEmp((String)appBean.getApplyStatus())) {
            param = param + "&applyStatus=" + appBean.getApplyStatus();
        }
        if (!Util.varCheckEmp((String)page.getRows())) {
            param = param + "&rows=" + page.getRows();
        }
        if (!Util.varCheckEmp((String)page.getPage())) {
            param = param + "&page=" + page.getPage();
        }
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        result = result.replace("data", "rows");
        return result;
    }

    @Override
    public String queryHistoryList(String appId, PageParam page, String operator, String vestInDepId) throws Exception {
        Page p = new Page(page.getPage(), page.getRows());
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/queryAppHistory.do?type=json";
        String param = "&mdpOperatorUserId=" + operator;
        param = param + "&appId=" + appId + "&rows=" + p.getPage() + "&page=" + p.getRp() + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        result = result.replace("data", "rows");
        return result;
    }

    @Override
    public AppBean getAppManager(String appId, String vestInDepId) throws Exception {
        return this.getAppManager(null, appId, null, null, vestInDepId);
    }

    @Override
    public AppBean getAppManager(String applyId, String appId, String operator, String isGrey, String vestInDepId) throws Exception {
        Object greyAppBeanResult;
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String picUrl = "";
        String url = "";
        String param = "";
        AppBean appBean = null;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        if (!"1".equals(isGrey)) {
            PageBeanList picPageBean;
            if (!Util.varCheckEmp((String)applyId)) {
                url = pamsUrl + "/appManagerControl/queryAppTmp.do?type=json";
                picUrl = pamsUrl + "/appManagerControl/queryAppPictureListTmp.do?type=json";
                param = "applyId=" + applyId;
            } else {
                url = pamsUrl + "/appManagerControl/queryApp.do?type=json";
                param = "appId=" + appId;
                picUrl = pamsUrl + "/publicAppCenter/queryAppPictureList.do?type=json";
            }
            param = param + "&mdpOperatorUserId=" + operator + "&vestInDepId=" + vestInDepId;
            result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
            PageBean pageBean = (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{AppBean.class});
            if (pageBean != null) {
                appBean = (AppBean)pageBean.getData();
            }
            if (appBean != null && (picPageBean = (PageBeanList)Util.readValue((String)(result = URLDecoder.decode(httpRequestUtil.post(picUrl, param), "utf-8")), PageBeanList.class, (Class[])new Class[]{TmpAppPicture.class})) != null) {
                if (!Util.varCheckEmp((String)applyId)) {
                    appBean.setTmpAppPictures(picPageBean.getData());
                } else {
                    appBean.setAppPictures(picPageBean.getData());
                }
            }
        } else {
            url = pamsUrl + "/appManagerControl/queryGrayApp.do?type=json";
            picUrl = pamsUrl + "/appManagerControl/queryAppGrayPictureList.do?type=json";
            GreyReleasedParam p = GreyReleasedParam.builder().addParam("appId", appId).addParam("mdpOperatorUserId", operator).addParam("vestInDepId", vestInDepId).build();
            result = URLDecoder.decode(httpRequestUtil.postJson(url, JSON.toJSONString((Object)p)), "utf-8");
            if (result == null) {
                log.error("\u83b7\u53d6\u7070\u5ea6\u5e94\u7528\u5f02\u5e38");
                throw new Exception("\u83b7\u53d6\u7070\u5ea6\u5e94\u7528\u8be6\u60c5\u5f02\u5e38");
            }
            greyAppBeanResult = (GreyAppBeanResult)JSON.parseObject((String)result, GreyAppBeanResult.class);
            if (!"200".equals(((GreyAppBeanResult)greyAppBeanResult).getCode())) {
                log.error("\u83b7\u53d6\u7070\u5ea6\u5e94\u7528\u5f02\u5e38:{}", (Object)((GreyAppBeanResult)greyAppBeanResult).getMessage());
            }
            if ((appBean = ((GreyAppBeanResult)greyAppBeanResult).getData()) != null) {
                GreyReleasedParam picParam = GreyReleasedParam.builder().addParam("appId", appId).addParam("mdpOperatorUserId", operator).addParam("vestInDepId", vestInDepId).build();
                result = URLDecoder.decode(httpRequestUtil.postJson(picUrl, JSON.toJSONString((Object)picParam)), "utf-8");
                if (result != null) {
                    JSONObject object = JSON.parseObject((String)result);
                    if (!"200".equals(object.getString("code"))) {
                        log.error("\u83b7\u53d6\u7070\u5ea6\u5e94\u7528\u56fe\u7247\u5f02\u5e38:{}", object.get((Object)"message"));
                    } else {
                        JSONArray data = object.getJSONArray("data");
                        List tmpAppPictures = data.toJavaList(TmpAppPicture.class);
                        appBean.setAppPictures(tmpAppPictures);
                    }
                } else {
                    log.info("\u83b7\u53d6\u7070\u5ea6\u5e94\u7528\u56fe\u7247\u4e3a\u7a7a");
                }
            }
        }
        if (appBean != null) {
            List<TmpAppUsesPermission> tmp = appBean.getTmpAppUsesPermission();
            if (tmp == null) {
                tmp = appBean.getAppUsesPermission();
            }
            if (tmp != null) {
                greyAppBeanResult = tmp.iterator();
                while (greyAppBeanResult.hasNext()) {
                    TmpAppUsesPermission tmpAppUsesPermission;
                    CommonCode code = this.commonCodePbService.getByCode((tmpAppUsesPermission = (TmpAppUsesPermission)greyAppBeanResult.next()).getUsesPermission(), "ANDROID_PERMISSION");
                    tmpAppUsesPermission.setUsesPermission(code == null ? tmpAppUsesPermission.getUsesPermission() : code.getName());
                }
            }
            if (StringUtils.isEmpty((String)appBean.getHasIcon())) {
                appBean.setHasIconName("");
            } else {
                String hasIconName = appBean.getHasIcon().equals("1") ? "\u662f" : "\u5426";
                appBean.setHasIconName(hasIconName);
            }
        }
        return appBean;
    }

    @Override
    public PageBean recommend(String appId, String recommend, String creatorId, String vestInDepId) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/topApp.do?type=json";
        if ("0".equals(recommend)) {
            url = pamsUrl + "/appManagerControl/downApp.do?type=json";
        }
        String param = "appId=" + appId;
        param = param + "&mdpOperatorUserId=" + creatorId + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        return (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
    }

    @Override
    public PageBean zjbb(String appId, String recommend, String creatorId, String vestInDepId) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + this.systemConfigService.getValueByCode("MDP_APP_ZJBB");
        String param = "appId=" + appId + "&recommend=" + recommend + "&creatorId=" + creatorId + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        return (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
    }

    @Override
    public PageBean upAndDownApp(String appId, String showStatus, String creatorId, String vestInDepId) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/disableApp.do?type=json";
        if ("1".equals(showStatus)) {
            url = pamsUrl + "/appManagerControl/enableApp.do?type=json";
        }
        String param = "appId=" + appId;
        param = param + "&mdpOperatorUserId=" + creatorId + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        return (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
    }

    @Override
    public PageBean appAduit(String auditUserId, String applyId, String auditResult, String approveStatus, String lockVersion, String vestInDepId) throws Exception {
        String resultStr = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/approved.do?type=json";
        String param = "applyId=" + applyId + "&mdpOperatorUserId=" + auditUserId + "&lockVersion=" + lockVersion + "&vestInDepId=" + vestInDepId;
        if ("2".equals(approveStatus)) {
            url = pamsUrl + "/appManagerControl/disapproved.do?type=json";
            param = param + "&auditResult=" + auditResult;
        }
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        resultStr = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        return (PageBean)Util.readValue((String)resultStr, PageBean.class, (Class[])new Class[]{Object.class});
    }

    @Override
    public PageBean createApp(String appId, String applyId, String operator, String lockVersion, String vestInDepId) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/createApp.do?type=json";
        String param = "appId=" + appId + "&applyId=" + applyId;
        param = param + "&mdpOperatorUserId=" + operator + "&lockVersion=" + lockVersion + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PageBean pageBean = (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
        return pageBean;
    }

    @Override
    public PageBean updateApp(String appId, String applyId, String operator, String lockVersion, String vestInDepId) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/updateApp.do?type=json";
        String param = "appId=" + appId + "&applyId=" + applyId;
        param = param + "&mdpOperatorUserId=" + operator + "&lockVersion=" + lockVersion + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PageBean pageBean = (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
        return pageBean;
    }

    @Override
    public PageBean setAppEnableOrDisable(String appId, String able, String operator) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/disableApp.do?type=json";
        if ("1".equals(able)) {
            url = pamsUrl + "/appManagerControl/enableApp.do?type=json";
        }
        String param = "appId=" + appId;
        param = param + "&mdpOperatorUserId=" + operator;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PageBean pageBean = (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
        return pageBean;
    }

    @Override
    public PageBean setAppResEnableOrDisable(String appId, String able, String operator, String vestInDepId) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/disableAppRes.do?type=json";
        if ("1".equals(able)) {
            url = pamsUrl + "/appManagerControl/enableAppRes.do?type=json";
        }
        String param = "appId=" + appId;
        param = param + "&mdpOperatorUserId=" + operator + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PageBean pageBean = (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
        return pageBean;
    }

    @Override
    public PageBean setAppVersionRollback(String appId, String operator, String vestInDepId) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/rollbackApp.do?type=json";
        String param = "appId=" + appId;
        param = param + "&mdpOperatorUserId=" + operator + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PageBean pageBean = (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
        return pageBean;
    }

    @Override
    public PageBean silentInstall(String appId, String silentInstall, String updateId, String vestInDepId) throws Exception {
        String result = "";
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = pamsUrl + "/appManagerControl/silentInstall.do?type=json";
        String param = "appId=" + appId + "&silentInstall=" + silentInstall + "&createUserId=" + updateId + "&vestInDepId=" + vestInDepId;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        result = URLDecoder.decode(httpRequestUtil.post(url, param), "utf-8");
        PageBean pageBean = (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
        return pageBean;
    }

    @Override
    public List<Map<String, Object>> getMdpDictByType(String type) throws Exception {
        String pamsUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        pamsUrl = pamsUrl + "/common/dict/getDictByType.do";
        String param = "type=json&dictType=" + type;
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.post(pamsUrl, param), "utf-8");
        PageBean pageBean = (PageBean)Util.readValue((String)result, PageBean.class, (Class[])new Class[]{Object.class});
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        if (pageBean.getData() != null) {
            listMap = (List)pageBean.getData();
        }
        return listMap;
    }

    @Override
    public void setReleaseScope(String appId, String area, String vestInDepId) throws Exception {
        List<String> divisionCodes = Arrays.asList(area.split(","));
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        mdpUrl = mdpUrl + "/appManagerControl/sbma/editPublishArea.do";
        RestfulQuery restfulQuery = new RestfulQuery();
        restfulQuery.setMessageId(Util.getUUID());
        restfulQuery.setVersion("1.0");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appId", (Object)appId);
        jsonObject.put("regionalisms", divisionCodes);
        jsonObject.put("vestInDepId", (Object)vestInDepId);
        restfulQuery.setParameter((Object)jsonObject);
        com.xdja.pams.sso.util.HttpRequestUtil httpRequestUtil = new com.xdja.pams.sso.util.HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(mdpUrl, JSON.toJSONString((Object)restfulQuery)), "utf-8");
        log.debug("\u8bbe\u7f6e\u53d1\u5e03\u8303\u56f4\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result)) {
            throw new RuntimeException("\u8bbe\u7f6e\u5e94\u7528\u53d1\u5e03\u8303\u56f4\u51fa\u9519\uff1a\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
        }
        RestfulResult restfulResult = (RestfulResult)JSON.parseObject((String)result, (TypeReference)new TypeReference<RestfulResult<JSONObject>>(){}, (Feature[])new Feature[0]);
        if (!"200".equals(restfulResult.getCode())) {
            throw new RuntimeException(restfulResult.getMessage());
        }
    }

    @Override
    public Object getAppReleaseScope(String appId) throws Exception {
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        mdpUrl = mdpUrl + "/appManagerControl/sbma/getPublishArea.do";
        RestfulQuery restfulQuery = new RestfulQuery();
        restfulQuery.setVersion("1.0");
        restfulQuery.setMessageId(Util.getUUID());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appId", (Object)appId);
        restfulQuery.setParameter((Object)jsonObject);
        com.xdja.pams.sso.util.HttpRequestUtil httpRequestUtil = new com.xdja.pams.sso.util.HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(mdpUrl, JSON.toJSONString((Object)restfulQuery)), "utf-8");
        log.debug("\u83b7\u53d6\u5e94\u7528\u53d1\u5e03\u8303\u56f4\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result)) {
            throw new RuntimeException("\u83b7\u53d6\u5e94\u7528\u53d1\u5e03\u8303\u56f4\u51fa\u9519\uff1a\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
        }
        RestfulResult restfulResult = (RestfulResult)JSON.parseObject((String)result, (TypeReference)new TypeReference<RestfulResult<JSONObject>>(){}, (Feature[])new Feature[0]);
        if (!"200".equals(restfulResult.getCode())) {
            throw new RuntimeException(restfulResult.getMessage());
        }
        return restfulResult.getData();
    }

    @Override
    public Object getAllReleaseScope() throws Exception {
        List<Regionalism> regionalisms = this.regionalismService.getAll();
        ArrayList<RegionalismBean> regionalismBeans = new ArrayList<RegionalismBean>();
        for (Regionalism regionalism : regionalisms) {
            RegionalismBean regionalismBean = new RegionalismBean();
            regionalismBean.setCode(regionalism.getCode());
            regionalismBean.setName(regionalism.getName());
            regionalismBean.setParentCode(regionalism.getParentCode());
            regionalismBeans.add(regionalismBean);
        }
        ArrayList<RegionalismBean> root = new ArrayList<RegionalismBean>();
        HashMap<String, RegionalismBean> map = new HashMap<String, RegionalismBean>();
        for (RegionalismBean regionalismBean : regionalismBeans) {
            map.put(regionalismBean.getCode(), regionalismBean);
        }
        for (RegionalismBean regionalismBean : regionalismBeans) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)regionalismBean.getParentCode())) {
                root.add(regionalismBean);
                continue;
            }
            RegionalismBean parent = (RegionalismBean)map.get(regionalismBean.getParentCode());
            if (parent == null) {
                log.warn("\u672a\u627e\u5230\u8be5\u884c\u653f\u533a\u5212\u7684\u7236\u7ea7\u8282\u70b9");
                continue;
            }
            parent.getCitys().add(regionalismBean);
        }
        return root;
    }

    @Override
    public String getDivisionCode() throws UnsupportedEncodingException {
        return this.systemConfigService.getValueByCode("regionalismCode");
    }

    @Override
    public List<Person> greyReleasedShowBack(String appId) throws Exception {
        GreyReleasedParam param;
        String mdp = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = mdp + "/appManagerControl/getGrayObject.do?type=json";
        String resultFromMdp = this.getResultFromMdp(url, param = GreyReleasedParam.builder().addParam("appId", appId).build());
        if (resultFromMdp == null) {
            throw new Exception("\u83b7\u53d6\u7ed3\u679c\u5f02\u5e38");
        }
        JSONObject json = JSON.parseObject((String)resultFromMdp);
        if (!"200".equals(json.getString("code"))) {
            throw new Exception("\u83b7\u53d6\u7ed3\u679c\u5f02\u5e38");
        }
        JSONArray data = json.getJSONArray("data");
        ArrayList<Person> personList = new ArrayList<Person>();
        for (int i = 0; i < data.size(); ++i) {
            List<Person> persons = this.parsePerson(data.getJSONObject(i));
            if (persons.size() <= 0) continue;
            personList.addAll(persons);
        }
        return personList;
    }

    private List<Person> parsePerson(JSONObject object) {
        ArrayList<Person> persons = new ArrayList<Person>();
        String type = object.getString("type");
        JSONArray items = object.getJSONArray("items");
        List strings = items.toJavaList(String.class);
        if (strings != null && !strings.isEmpty()) {
            HashSet set = new HashSet(strings);
            for (String s : set) {
                persons.add(this.makeScope(type, s));
            }
        }
        return persons;
    }

    private Person makeScope(String type, String id) {
        Person person = new Person();
        person.setFlag(type);
        if ("person".equals(type)) {
            PersonBean personById = this.userManageService.getPersonById(id);
            person.setId(id);
            person.setCode(personById.getCODE());
            person.setName(personById.getNAME());
        } else if ("dep".equals(type)) {
            Department department = this.depManageService.queryDepById(id);
            person.setId(department.getId());
            person.setCode(department.getCode());
            person.setName(department.getName());
        } else {
            CommonCode commonCode = this.commonCodePbService.getByPCodeAndCIDInPersonType(type, id);
            person.setId(commonCode.getCode());
            person.setCode(commonCode.getCode());
            person.setName(commonCode.getName());
        }
        return person;
    }

    private String getResultFromMdp(String url, Object param) throws Exception {
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = httpRequestUtil.postJson(url, JSON.toJSONString((Object)param));
        if (result == null) {
            throw new Exception("\u83b7\u53d6\u7ed3\u679c\u5f02\u5e38");
        }
        return result;
    }

    private String getGreyReleased(AppBean appBean, PageParam page) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        GreyReleasedParam param = GreyReleasedParam.make(map);
        String mdp = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String url = mdp + "/appManagerControl/listGrayApp.do?type=json";
        map.put("pageNo", page.getPage());
        map.put("pageSize", page.getRows());
        map.put("queryKey", appBean.getQueryKey());
        map.put("mdpOperatorUserId", appBean.getMdpOperatorUserId());
        map.put("timeStart", appBean.getCreateTimeStart());
        map.put("timeEnd", appBean.getCreateTimeEnd());
        map.put("vestInDepId", appBean.getVestInDepId());
        String result = this.getResultFromMdp(url, param);
        JSONObject object = this.resolveCommonMdpResult(result);
        HashMap<String, Object> rmap = new HashMap<String, Object>();
        object = object.getJSONObject("data");
        rmap.put("page", page.getPage());
        rmap.put("total", object.getIntValue("count"));
        JSONArray data = object.getJSONArray("data");
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                jsonObject.put("greeey", (Object)"1");
            }
        }
        rmap.put("rows", data);
        return JSON.toJSONString(rmap);
    }

    @Override
    public void createAppGreyVersion(AppUseAreaForm form) throws Exception {
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        mdpUrl = mdpUrl + "/appManagerControl/createGrayApp.do?type=json";
        this.doCreateOrModify(mdpUrl, form);
    }

    @Override
    public void modifyAppGreyScope(AppUseAreaForm form) throws Exception {
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        mdpUrl = mdpUrl + "/appManagerControl/editGrayObject.do?type=json";
        this.doCreateOrModify(mdpUrl, form);
    }

    private void doCreateOrModify(String url, AppUseAreaForm form) throws Exception {
        List<AppUseArea> appUseArea;
        GreyAppParam greyAppParam = new GreyAppParam();
        GreyReleasedParam param = GreyReleasedParam.make(greyAppParam);
        if (form.getAppId() != null && !"".equals(form.getAppId())) {
            greyAppParam.setAppId(form.getAppId());
        }
        if (form.getAppId() != null && !"".equals(form.getApplyId())) {
            greyAppParam.setApplyId(form.getApplyId());
        }
        if (form.getLockVersion() != null) {
            greyAppParam.setLockVersion(form.getLockVersion());
        }
        if (form.getPersonId() != null && !"".equals(form.getPersonId())) {
            greyAppParam.setMdpOperatorUserId(form.getPersonId());
        }
        if (form.getVestInDepId() != null && !"".equals(form.getVestInDepId())) {
            greyAppParam.setVestInDepId(form.getVestInDepId());
        }
        if ((appUseArea = form.getAppUseArea()) != null && !appUseArea.isEmpty()) {
            for (AppUseArea area : appUseArea) {
                greyAppParam.addItem(area.getType(), area.getAreaId());
            }
        }
        this.getPersonInfo(greyAppParam);
        String result = this.getResultFromMdp(url, param);
        if (result == null) {
            throw new Exception("\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38");
        }
        JSONObject json = JSON.parseObject((String)result);
        String code = json.getString("code");
        if (!"200".equals(code)) {
            log.error("\u521b\u5efa\u7070\u5ea6\u7248\u672c\u5f02\u5e38,\u7ed3\u679c:{}", (Object)result);
            throw new Exception(json.getString("message"));
        }
    }

    @Override
    public void greyToFormal(String appId, String lockVersion, String optPersonId, String vestInDepId) throws Exception {
        GreyReleasedParam param;
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        String result = this.getResultFromMdp(mdpUrl = mdpUrl + "/appManagerControl/publishAppFromGray.do?type=json", param = GreyReleasedParam.builder().addParam("appId", appId).addParam("mdpOperatorUserId", optPersonId).addParam("lockVersion", Integer.parseInt(lockVersion)).addParam("vestInDepId", vestInDepId).build());
        if (result == null) {
            throw new Exception("\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38");
        }
        JSONObject json = JSON.parseObject((String)result);
        String code = json.getString("code");
        if (!"200".equals(code)) {
            log.error("\u7070\u5ea6\u7248\u672c\u8f6c\u6b63\u5f0f\u5f02\u5e38,\u7ed3\u679c:{}", (Object)result);
            throw new Exception(json.getString("message"));
        }
    }

    private void getPersonInfo(GreyAppParam greyAppParam) {
        ArrayList<String> temp;
        Iterator<String> iterator;
        Map<String, GreyAppParam.GreyAppParamItem> map = greyAppParam.itemMap();
        GreyAppParam.GreyAppParamItem deps = map.get("dep");
        GreyAppParam.GreyAppParamItem persons = map.get("person");
        ArrayList<GreyAppParam.GreyAppParamItem> propItems = new ArrayList<GreyAppParam.GreyAppParamItem>();
        Set<Map.Entry<String, GreyAppParam.GreyAppParamItem>> entries = map.entrySet();
        for (Map.Entry<String, GreyAppParam.GreyAppParamItem> entry : entries) {
            String key = entry.getKey();
            if ("person".equals(key) || "dep".equals(key)) continue;
            propItems.add(entry.getValue());
        }
        HashSet<GreyPersonDeviceInfo> all = new HashSet<GreyPersonDeviceInfo>();
        if (deps != null && deps.getItems() != null && !deps.getItems().isEmpty()) {
            Set<String> depIds = deps.getItems();
            iterator = depIds.iterator();
            temp = new ArrayList<String>();
            int i = 1;
            while (iterator.hasNext()) {
                if (i % 20 == 0) {
                    all.addAll(this.doFind(temp, propItems));
                    temp.clear();
                }
                temp.add(iterator.next());
                ++i;
            }
            Set<GreyPersonDeviceInfo> greyPersonDeviceInfos = this.doFind(temp, propItems);
            if (!CollectionUtils.isEmpty(greyPersonDeviceInfos)) {
                all.addAll(greyPersonDeviceInfos);
            }
        }
        if (persons != null && persons.getItems() != null && !persons.getItems().isEmpty()) {
            Set<String> personIds = persons.getItems();
            iterator = personIds.iterator();
            temp = new ArrayList();
            int i = 1;
            while (iterator.hasNext()) {
                if (i % 20 == 0) {
                    all.addAll(this.findPerson(temp));
                    temp.clear();
                }
                temp.add(iterator.next());
                ++i;
            }
            Set<GreyPersonDeviceInfo> pps = this.findPerson(temp);
            if (pps != null && !pps.isEmpty()) {
                all.addAll(pps);
            }
        }
        this.setOrganizationName(all);
        greyAppParam.addGrayPersonInfo(all);
    }

    private void setOrganizationName(Collection<GreyPersonDeviceInfo> all) {
        Department department = this.depManageService.queryTopDep();
        if (all != null) {
            for (GreyPersonDeviceInfo info : all) {
                info.setOrganizationName(department.getName());
            }
        }
    }

    private Set<GreyPersonDeviceInfo> findPerson(List<String> personIds) {
        ArrayList<Object> param = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder("select ");
        sb.append(" p.id as \"userId\", p.name as \"userName\", dep.name as \"departmentName\", dev.id as \"deviceId\", dev.card_id as \"cardNo\", dev.imei as \"imei\", dev.imsi as \"imsi\"");
        sb.append(" from t_person p join t_department dep on p.dep_id = dep.id left join t_device dev on p.id = dev.person_id and dev.imei is not null ");
        sb.append(" where p.flag = '0' ");
        sb.append(" and p.id in (");
        for (int i = 0; i < personIds.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
            param.add(personIds.get(i));
        }
        sb.append(")");
        return this.doQuery(sb.toString(), param);
    }

    private Set<GreyPersonDeviceInfo> doFind(List<String> temp, List<GreyAppParam.GreyAppParamItem> propItems) {
        HashSet<GreyPersonDeviceInfo> tempAll = new HashSet<GreyPersonDeviceInfo>();
        if (propItems.isEmpty()) {
            Set<GreyPersonDeviceInfo> greyPersonDeviceInfos = this.greyPersonDeviceInfoFindByOnlyDep(temp);
            if (greyPersonDeviceInfos != null && !greyPersonDeviceInfos.isEmpty()) {
                tempAll.addAll(greyPersonDeviceInfos);
            }
        } else {
            for (GreyAppParam.GreyAppParamItem propItem : propItems) {
                Set<GreyPersonDeviceInfo> greyPersonDeviceInfosProp;
                if (propItem.getItems().isEmpty() || (greyPersonDeviceInfosProp = this.greyPersonDeviceInfoFindByDeyProp(temp, propItem.getType(), propItem.getItems())) == null || greyPersonDeviceInfosProp.isEmpty()) continue;
                tempAll.addAll(greyPersonDeviceInfosProp);
            }
        }
        return tempAll;
    }

    private Set<GreyPersonDeviceInfo> greyPersonDeviceInfoFindByOnlyDep(List<String> depIds) {
        StringBuilder sb = new StringBuilder("select ");
        sb.append(" p.id as \"userId\", p.name as \"userName\", dep.name as \"departmentName\", dev.id as \"deviceId\", dev.card_id as \"cardNo\", dev.imei as \"imei\", dev.imsi as \"imsi\"");
        sb.append(" from t_person p join t_department dep on p.dep_id = dep.id left join t_device dev on p.id = dev.person_id and dev.imei is not null ");
        sb.append(" where p.flag = '0' ");
        sb.append(" and  ( ");
        ArrayList<Object> param = new ArrayList<Object>();
        for (int i = 0; i < depIds.size(); ++i) {
            if (i > 0) {
                sb.append(" or ");
            }
            sb.append(" dep.tree_id like  ? ");
            param.add("%" + depIds.get(i) + "%");
        }
        sb.append(" ) ");
        String sql = sb.toString();
        return this.doQuery(sql, param);
    }

    private Set<GreyPersonDeviceInfo> greyPersonDeviceInfoFindByDeyProp(List<String> depIds, String type, Set<String> typeValues) {
        StringBuilder sb = new StringBuilder("select ");
        sb.append(" p.id as \"userId\", p.name as \"userName\", dep.name as \"departmentName\", dev.id as \"deviceId\", dev.card_id as \"cardNo\", dev.imei as \"imei\", dev.imsi as \"imsi\"");
        sb.append(" from t_person p join t_department dep on p.dep_id = dep.id left join t_device dev on p.id = dev.person_id  and dev.imei is not null ");
        sb.append(" where p.flag = '0' ");
        sb.append(" and ( ");
        int count = 0;
        ArrayList<Object> param = new ArrayList<Object>();
        for (String dep : depIds) {
            for (String typeValue : typeValues) {
                if (count > 0) {
                    sb.append(" or ");
                }
                sb.append(" dep.tree_id like ? and p.").append(type).append("=?");
                param.add("%" + dep + "%");
                param.add(typeValue);
                ++count;
            }
        }
        sb.append(" )");
        String sql = sb.toString();
        return this.doQuery(sql, param);
    }

    private Set<GreyPersonDeviceInfo> doQuery(String sql, List<Object> param) {
        List list = this.baseDao.getListBySQL(sql, param.toArray(new Object[0]), GreyPersonDeviceInfo.class);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return new HashSet<GreyPersonDeviceInfo>(list);
    }

    @Override
    public void greyRecommend(String appId, String label, String creatorId, String vestInDepId) throws Exception {
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        mdpUrl = mdpUrl + "/appManagerControl/setAppGrayTopStatus.do?type=json";
        String status = "0".equals(label) ? "down" : "top";
        GreyReleasedParam param = GreyReleasedParam.builder().addParam("appId", appId).addParam("mdpOperatorUserId", creatorId).addParam("status", status).addParam("vestInDepId", vestInDepId).build();
        this.resolveCommonMdpResult(this.getResultFromMdp(mdpUrl, param));
    }

    @Override
    public void greyUpAndDownApp(String appId, String showStatus, String creatorId, String vestInDepId) throws Exception {
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        mdpUrl = mdpUrl + "/appManagerControl/setAppGrayEnableStatus.do?type=json";
        String status = "0".equals(showStatus) ? "disable" : "enable";
        GreyReleasedParam param = GreyReleasedParam.builder().addParam("appId", appId).addParam("mdpOperatorUserId", creatorId).addParam("status", status).addParam("vestInDepId", vestInDepId).build();
        this.resolveCommonMdpResult(this.getResultFromMdp(mdpUrl, param));
    }

    @Override
    public void greySilentInstall(String appId, String silentInstall, String updateId, String vestInDepId) throws Exception {
        String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        mdpUrl = mdpUrl + "/appManagerControl/setGrayAppSilentInstall.do?type=json";
        String status = "0".equals(silentInstall) ? "down" : "top";
        GreyReleasedParam param = GreyReleasedParam.builder().addParam("appId", appId).addParam("mdpOperatorUserId", updateId).addParam("status", status).addParam("vestInDepId", vestInDepId).build();
        this.resolveCommonMdpResult(this.getResultFromMdp(mdpUrl, param));
    }

    private JSONObject resolveCommonMdpResult(String result) {
        JSONObject object = JSON.parseObject((String)result);
        if (!"200".equals(object.getString("code"))) {
            String msg = object.getString("message");
            log.error("\u7070\u5ea6\u5e94\u7528\u63a8\u8350/\u4e0a\u4e0b\u67b6/\u9759\u9ed8\u5b89\u88c5\u64cd\u4f5c\u5931\u8d25:{}", (Object)msg);
            throw new RuntimeException(msg);
        }
        return object;
    }
}

