/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.bean.RestfulQuery;
import com.xdja.pams.common.bean.RestfulResult;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import pams.function.sbma.resappmanager.bean.ChangePowerBean;
import pams.function.sbma.resappmanager.bean.PowerBean;
import pams.function.sbma.resappmanager.bean.RoamAppAuthInfo;
import pams.function.sbma.resappmanager.bean.RoamAppAuthInfoNew;
import pams.function.sbma.resappmanager.bean.RoamAppInfo;
import pams.function.sbma.resappmanager.bean.RoamAppInfoResult;
import pams.function.sbma.resappmanager.bean.RoamAppSearchBean;
import pams.function.sbma.resappmanager.bean.RoamPersonInfo;
import pams.function.sbma.resappmanager.dao.AppPowerViewDao;
import pams.function.sbma.resappmanager.entity.AppPowerView;
import pams.function.sbma.resappmanager.service.SbmaOtherPlaceAppAuthService;

@Service
public class SbmaOtherPlaceAppAuthServiceImpl
implements SbmaOtherPlaceAppAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SbmaOtherPlaceAppAuthServiceImpl.class);
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private AppPowerViewDao appPowerViewDao;
    @Autowired
    private CommonCodeService commonCodeService;

    @Override
    public List<RoamAppInfo> listOtherPlaceAppInfo(RoamAppSearchBean searchBean, Page page) {
        try {
            String mdpUrl = this.systemConfigPbService.getValueByCode("sodUrl");
            String url = this.spellUrl(mdpUrl, "app/queryRoamAppList");
            RestfulQuery restfulQuery = new RestfulQuery();
            String messageId = UUIDUtil.random();
            restfulQuery.setMessageId(messageId);
            restfulQuery.setVersion("1.0");
            restfulQuery.setParameter((Object)searchBean);
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String result = httpRequestUtil.httpPostJson(url, JSON.toJSONString((Object)restfulQuery));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("sod\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            }
            RestfulResult restfulResult = RestfulResult.getInstance((String)result, RoamAppInfoResult.class);
            Assert.notNull((Object)restfulResult, (String)"\u4ecesod\u83b7\u53d6\u5f02\u5730\u5e94\u7528\u7ed3\u679c\u4e3a\u7a7a");
            Assert.state((boolean)messageId.equals(restfulResult.getMessageId()), (String)"sod\u8fd4\u56de\u7684\u8bf7\u6c42ID\u5f02\u5e38");
            Assert.state((boolean)"200".equals(restfulResult.getCode()), (String)String.format("sod\u8fd4\u56de\u72b6\u6001\u5f02\u5e38:%s", restfulResult.getMessage()));
            RoamAppInfoResult roamAppInfoResult = (RoamAppInfoResult)restfulResult.getData();
            Assert.notNull((Object)roamAppInfoResult, (String)"mdp\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            page.setTotal(roamAppInfoResult.getCount().intValue());
            return roamAppInfoResult.getData();
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f02\u5730\u5e94\u7528\u5217\u8868\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void changePower(RoamAppInfo roamAppInfo, List<String> personIds) throws Exception {
        try {
            Assert.notNull((Object)roamAppInfo, (String)"\u53c2\u6570\u5f02\u5e38");
            String localRegionalismCode = this.systemConfigPbService.getValueByCode("regionalismCode");
            RoamAppAuthInfo rpi = new RoamAppAuthInfo();
            rpi.setAppId(roamAppInfo.getAppId());
            rpi.setAppName(roamAppInfo.getAppName());
            rpi.setAppNetworkCode(roamAppInfo.getAppNetworkCode());
            rpi.setAppPackageName(roamAppInfo.getAppPackage());
            rpi.setAppRegionalismCode(roamAppInfo.getAppRegionalismCode());
            rpi.setPersonRegionalismCode(localRegionalismCode);
            ArrayList<RoamPersonInfo> personInfos = new ArrayList<RoamPersonInfo>();
            if (!personIds.isEmpty()) {
                for (String personId : personIds) {
                    if (Strings.isEmpty((String)personId)) continue;
                    Person person = this.userManageService.getPersonByPersonId(personId);
                    RoamPersonInfo rp = new RoamPersonInfo();
                    Department department = person.getDepartment();
                    rp.setDepCode(department.getCode());
                    rp.setDepId(department.getId());
                    rp.setDepName(department.getName());
                    rp.setMobile(((Mobile)person.getMobiledList().get(0)).getMobile());
                    rp.setPersonCode(person.getCode());
                    rp.setPersonId(person.getId());
                    rp.setPersonIdentifier(person.getIdentifier());
                    rp.setPersonName(person.getName());
                    rp.setPersonType(person.getPersonType());
                    rp.setPolice(person.getPolice());
                    rp.setPosition(person.getPosition());
                    rp.setSex(person.getSex());
                    rp.setType("1");
                    personInfos.add(rp);
                }
            }
            rpi.setPersonInfos(personInfos);
            RestfulQuery restfulQuery = new RestfulQuery();
            String messageId = UUIDUtil.random();
            restfulQuery.setMessageId(messageId);
            restfulQuery.setVersion("1.0");
            restfulQuery.setParameter((Object)rpi);
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String uasUrl = this.systemConfigPbService.getValueByCode("UAS_SERVER_URL");
            String url = this.spellUrl(uasUrl, "/roamAppAuth/applyPower.do");
            String result = httpRequestUtil.postJson(url, JSON.toJSONString((Object)restfulQuery));
            LOGGER.debug("uas\u8fd4\u56de\u6743\u9650\u53d8\u66f4\u7ed3\u679c:{}", (Object)result);
            RestfulResult restfulResult = RestfulResult.getInstance((String)result, Map.class);
            Assert.notNull((Object)restfulResult, (String)"uas\u53d8\u66f4\u6743\u9650\u7ed3\u679c\u4e3a\u7a7a");
            Assert.state((boolean)"200".equals(restfulResult.getCode()), (String)String.format("\u53bbuas\u53d8\u66f4\u6743\u9650\u7ed3\u679c\u5f02\u5e38: %s", restfulResult.getMessage()));
            Map map = (Map)restfulResult.getData();
            String code = (String)map.get("code");
            String message = (String)map.get("message");
            Assert.state((boolean)"1".equals(code), (String)String.format("uas\u53d8\u66f4\u6743\u9650\u5931\u8d25: %s", message));
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void changePower(RoamAppInfo roamAppInfo, List<String> addPersonIds, List<String> cancelPersonIds) throws Exception {
        ArrayList<RoamAppAuthInfoNew> param = new ArrayList<RoamAppAuthInfoNew>();
        String local = this.systemConfigPbService.getValueByCode("regionalismCode");
        try {
            RoamAppAuthInfoNew r;
            for (String ap : addPersonIds) {
                if (Strings.isEmpty((String)ap)) continue;
                r = new RoamAppAuthInfoNew();
                r.setAppId(roamAppInfo.getAppId());
                r.setAppRegionalismCode(roamAppInfo.getAppRegionalismCode());
                r.setPersonId(ap);
                r.setPersonRegionalismCode(local);
                r.setType("1");
                param.add(r);
            }
            for (String cp : cancelPersonIds) {
                if (Strings.isEmpty((String)cp)) continue;
                r = new RoamAppAuthInfoNew();
                r.setAppId(roamAppInfo.getAppId());
                r.setAppRegionalismCode(roamAppInfo.getAppRegionalismCode());
                r.setPersonId(cp);
                r.setPersonRegionalismCode(local);
                r.setType("3");
                param.add(r);
            }
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            HashMap<String, String> headers = new HashMap<String, String>();
            String messageId = UUIDUtil.random();
            headers.put("messageId", messageId);
            headers.put("appCredential", "1234");
            String uasUrl = this.systemConfigPbService.getValueByCode("UAS_SERVER_URL");
            String url = this.spellUrl(uasUrl, "/v1/authUserAppController/applyUserPower.do");
            Map result = httpRequestUtil.httpPostJsonRet(url, JSON.toJSONString(param), headers);
            String resultCode = (String)result.get("code");
            String message = (String)result.get("message");
            if (!"0".equals(resultCode)) {
                throw new Exception("\u64cd\u4f5c\u5931\u8d25" + message);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public List<Person> getAuthedPerson(RoamAppInfo appInfo) throws Exception {
        String localRegionalismCode = this.systemConfigPbService.getValueByCode("regionalismCode");
        String uasUrl = this.systemConfigPbService.getValueByCode("UAS_SERVER_URL");
        String url = this.spellUrl(uasUrl, "/roamAppAuth/getAuthedPerson.do");
        try {
            RoamAppAuthInfo roamAppAuthInfo = new RoamAppAuthInfo();
            roamAppAuthInfo.setPersonRegionalismCode(localRegionalismCode);
            roamAppAuthInfo.setAppRegionalismCode(appInfo.getAppRegionalismCode());
            roamAppAuthInfo.setAppNetworkCode(appInfo.getAppNetworkCode());
            roamAppAuthInfo.setAppId(appInfo.getAppId());
            RestfulQuery query = new RestfulQuery();
            String messageId = UUIDUtil.random();
            query.setMessageId(messageId);
            query.setVersion("1.0");
            query.setParameter((Object)roamAppAuthInfo);
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String result = httpRequestUtil.postJson(url, JSON.toJSONString((Object)query));
            LOGGER.debug("uas\u8fd4\u56de\u83b7\u53d6\u5df2\u6388\u6743\u4eba\u5458\u7ed3\u679c:{}", (Object)result);
            RestfulResult restfulResult = RestfulResult.getInstanceListDate((String)result, String.class);
            Assert.notNull((Object)restfulResult, (String)"uas\u83b7\u53d6\u5df2\u6388\u6743\u4eba\u5458\u4e3a\u7a7a");
            Assert.state((boolean)"200".equals(restfulResult.getCode()), (String)String.format("\u53bbuas\u83b7\u53d6\u5df2\u6388\u6743\u4eba\u5458\u5f02\u5e38: %s", restfulResult.getMessage()));
            List list = (List)restfulResult.getData();
            ArrayList<Person> personList = new ArrayList<Person>();
            if (list != null && !list.isEmpty()) {
                for (String id : list) {
                    Person p = this.userManageService.getPersonByPersonId(id);
                    if (p == null) continue;
                    Person pp = new Person();
                    pp.setId(p.getId());
                    pp.setCode(p.getCode());
                    pp.setName(p.getName());
                    personList.add(pp);
                }
            }
            return personList;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public Map<String, Object> getAppAuth(String appId, String appRegionalismCode) {
        AppPowerView appPowerView = new AppPowerView();
        appPowerView.setAppId(appId);
        appPowerView.setAppRegionalismCode(appRegionalismCode);
        return this.queryAppAuth(appId, appRegionalismCode);
    }

    private List<String> getPowerType() {
        ArrayList<String> powerType = new ArrayList<String>(Arrays.asList("person", "dep", "group"));
        List commonCodes = this.commonCodeService.queryByType("personType");
        if (!CollectionUtils.isEmpty((Collection)commonCodes)) {
            for (CommonCode commonCode : commonCodes) {
                powerType.add(commonCode.getCode());
            }
        }
        return powerType;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePower(Map<String, ChangePowerBean> powerBeans, String appId, String appRegionalismCode) throws Exception {
        try {
            ChangePowerBean personPowerBean;
            ChangePowerBean groupPowerBean;
            this.updateAppPowerView(powerBeans, appId, appRegionalismCode);
            ArrayList<RoamAppAuthInfoNew> roamAppAuthList = new ArrayList<RoamAppAuthInfoNew>();
            StringBuilder addSql = new StringBuilder();
            StringBuilder deleteSql = new StringBuilder();
            ChangePowerBean depPowerBean = powerBeans.get("dep");
            if (depPowerBean != null) {
                Object deleteDepIds;
                List<String> addDepIds = depPowerBean.getAddList();
                if (!CollectionUtils.isEmpty(addDepIds)) {
                    addSql.append("select p.* from t_person p join t_department d on p.dep_id = d.id where p.flag = '0' and d.flag = '0' ");
                    addSql.append(" and d.id in(").append(Util.listToString(addDepIds)).append(")");
                }
                if (!CollectionUtils.isEmpty((Collection)(deleteDepIds = depPowerBean.getDeleteList()))) {
                    deleteSql.append("select p.* from t_person p join t_department d on p.dep_id = d.id where p.flag = '0' and d.flag = '0'");
                    deleteSql.append("and d.id in(").append(Util.listToString((List)deleteDepIds)).append(")");
                }
            }
            List commonCodes = this.commonCodeService.queryByType("personType");
            for (CommonCode commonCode : commonCodes) {
                ChangePowerBean personTypePower = powerBeans.get(commonCode.getCode());
                if (personTypePower == null) continue;
                List<String> addTypes = personTypePower.getAddList();
                List<String> deleteTypes = personTypePower.getDeleteList();
                if (!CollectionUtils.isEmpty(addTypes)) {
                    if (StringUtils.isBlank((CharSequence)addSql)) {
                        addSql.append("select p.* from t_person p where 1=1 ");
                    }
                    addSql.append(" and p.").append(commonCode.getCode()).append("in(").append(Util.listToString(addTypes)).append(")");
                }
                if (!CollectionUtils.isEmpty(deleteTypes)) continue;
                if (StringUtils.isBlank((CharSequence)deleteSql)) {
                    deleteSql.append("select p.* from t_person p where  1=1 ");
                }
                deleteSql.append(" and p.").append(commonCode.getCode()).append("in(").append(Util.listToString(deleteTypes)).append(")");
            }
            if (StringUtils.isNotBlank((CharSequence)addSql)) {
                List<Person> addPersons = this.appPowerViewDao.queryPersonIdBySql(addSql.toString());
                List<String> addPersonIds = this.getPersonIds(addPersons);
                this.addAppAuthParam(roamAppAuthList, addPersonIds, "1", appId, appRegionalismCode);
            }
            if (StringUtils.isNotBlank((CharSequence)deleteSql)) {
                List<Person> deletePersons = this.appPowerViewDao.queryPersonIdBySql(deleteSql.toString());
                List<String> deletePersonIds = this.getPersonIds(deletePersons);
                this.addAppAuthParam(roamAppAuthList, deletePersonIds, "3", appId, appRegionalismCode);
            }
            if ((groupPowerBean = powerBeans.get("group")) != null) {
                List<String> deleteGroupIdList;
                List<String> addGroupIdList = groupPowerBean.getAddList();
                if (!CollectionUtils.isEmpty(addGroupIdList)) {
                    String sql = "select p.* from t_person p where p.flag = '0' and p.id in (select person_id from T_BIMS_GROUP_MEMBER g where g.group_id in(" + Util.listToString(addGroupIdList) + ") )";
                    List<Person> addGroupPersons = this.appPowerViewDao.queryPersonIdBySql(sql);
                    List<String> addGroupPersonIds = this.getPersonIds(addGroupPersons);
                    this.addAppAuthParam(roamAppAuthList, addGroupPersonIds, "1", appId, appRegionalismCode);
                }
                if (!CollectionUtils.isEmpty(deleteGroupIdList = groupPowerBean.getDeleteList())) {
                    String sql = "select p.* from t_person p where p.flag = '0' and p.id in (select person_id from T_BIMS_GROUP_MEMBER g where g.group_id in(" + Util.listToString(deleteGroupIdList) + ") )";
                    List<Person> deleteGroupPersons = this.appPowerViewDao.queryPersonIdBySql(sql);
                    List<String> deleteGroupPersonIds = this.getPersonIds(deleteGroupPersons);
                    this.addAppAuthParam(roamAppAuthList, deleteGroupPersonIds, "3", appId, appRegionalismCode);
                }
            }
            if ((personPowerBean = powerBeans.get("person")) != null) {
                List<String> deletePersonIdList;
                List<String> addPersonIdList = personPowerBean.getAddList();
                if (!CollectionUtils.isEmpty(addPersonIdList)) {
                    this.addAppAuthParam(roamAppAuthList, addPersonIdList, "1", appId, appRegionalismCode);
                }
                if (!CollectionUtils.isEmpty(deletePersonIdList = personPowerBean.getDeleteList())) {
                    this.addAppAuthParam(roamAppAuthList, deletePersonIdList, "3", appId, appRegionalismCode);
                }
            }
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String uasUrl = this.systemConfigPbService.getValueByCode("UAS_SERVER_URL");
            HashMap<String, String> headers = new HashMap<String, String>();
            String messageId = UUIDUtil.random();
            headers.put("appCredential", "1234");
            headers.put("messageId", messageId);
            String url = this.spellUrl(uasUrl, "/v1/authUserAppController/applyUserPower.do");
            Map result = httpRequestUtil.httpPostJsonRet(url, JSON.toJSONString(roamAppAuthList), headers);
            String message = (String)result.get("message");
            String resultCode = (String)result.get("code");
            if (!"0".equals(resultCode)) {
                throw new Exception("\u8c03\u7528UAS\u63a5\u53e3\u6388\u6743\u5931\u8d25" + message);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private List<String> getPersonIds(List<Person> personList) {
        ArrayList<String> personIds = new ArrayList<String>();
        for (Person person : personList) {
            personIds.add(person.getId());
        }
        return personIds;
    }

    private void updateAppPowerView(Map<String, ChangePowerBean> powerBeans, String appId, String appRegionalismCode) {
        List<String> powerTypes = this.getPowerType();
        for (String type : powerTypes) {
            List<String> deletePowers;
            ChangePowerBean changePowerBean = powerBeans.get(type);
            if (changePowerBean == null) continue;
            List<String> addPowers = changePowerBean.getAddList();
            if (!CollectionUtils.isEmpty(addPowers)) {
                ArrayList<AppPowerView> addPowerList = new ArrayList<AppPowerView>();
                for (String addPower : addPowers) {
                    AppPowerView appPowerView = new AppPowerView();
                    appPowerView.setType(type);
                    appPowerView.setAppRegionalismCode(appRegionalismCode);
                    appPowerView.setAppId(appId);
                    appPowerView.setAreaId(addPower);
                    addPowerList.add(appPowerView);
                }
                this.appPowerViewDao.insertBatch(addPowerList);
            }
            if (CollectionUtils.isEmpty(deletePowers = changePowerBean.getDeleteList())) continue;
            this.appPowerViewDao.deleteBatch(deletePowers, type, appId, appRegionalismCode);
        }
    }

    private void addAppAuthParam(List<RoamAppAuthInfoNew> powerList, List<String> personIds, String type, String appId, String appRegionalismCode) {
        String localRegionalismCode = this.systemConfigPbService.getValueByCode("regionalismCode");
        for (String personId : personIds) {
            RoamAppAuthInfoNew appAuthInfo = new RoamAppAuthInfoNew();
            appAuthInfo.setAppId(appId);
            appAuthInfo.setAppRegionalismCode(appRegionalismCode);
            appAuthInfo.setType(type);
            appAuthInfo.setPersonId(personId);
            appAuthInfo.setPersonRegionalismCode(localRegionalismCode);
            powerList.add(appAuthInfo);
        }
    }

    private Map<String, Object> queryAppAuth(String appId, String appRegionalismCode) {
        AppPowerView appPowerView = new AppPowerView();
        appPowerView.setAppId(appId);
        appPowerView.setAppRegionalismCode(appRegionalismCode);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> powerTypes = this.getPowerType();
        for (String type : powerTypes) {
            appPowerView.setType(type);
            List<PowerBean> powerList = this.appPowerViewDao.query(appPowerView);
            result.put(type, powerList);
        }
        return result;
    }

    private String spellUrl(String part1, String part2) {
        StringBuilder sb = new StringBuilder();
        if (part1.endsWith("/")) {
            sb.append(part1.substring(0, part1.lastIndexOf("/")));
        } else {
            sb.append(part1);
        }
        if (part2.startsWith("/")) {
            sb.append(part2);
        } else {
            sb.append("/").append(part2);
        }
        return sb.toString();
    }
}

