/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resregist.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.RestfulResult;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.resregist.bean.ResourceTmpBean;
import pams.function.sbma.resregist.service.RegistService;

@Controller
@Scope(value="session")
public class RegistResController
extends BaseControler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistResController.class);
    @Autowired
    private RegistService registService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;

    @RequestMapping(value={"/sbma/ResRegistController/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            LOGGER.error("\u8df3\u8f6c\u5230\u8d44\u6e90\u6ce8\u518c\u9875\u9762\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/ResRegistController/query.do"})
    public void queryList(String resName, Integer status, Integer page, Integer rows, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject jsonObject = this.registService.getList(resName, status, page, rows);
            map.put("rows", jsonObject.get((Object)"data"));
            map.put("total", jsonObject.get((Object)"count"));
            map.put("flag", 1);
        }
        catch (Exception e) {
            map.put("flag", 0);
            map.put("total", 0);
            map.put("rows", Collections.EMPTY_LIST);
            LOGGER.error("\u83b7\u53d6\u5217\u8868\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/sbma/ResRegistController/toDetail.do"})
    public String toDetail(String id, String type, ModelMap modelMap) {
        modelMap.addAttribute("id", (Object)id);
        modelMap.addAttribute("type", (Object)type);
        return "sbma/resregist/default/resApplyInfo";
    }

    @RequestMapping(value={"/sbma/ResRegistController/getDetailSync.do"})
    public void getDetailSync(String id, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (!StringUtils.isEmpty((String)id)) {
                JSONObject jsonObject = this.registService.getResApply(id);
                if (jsonObject != null) {
                    map.put("flag", "1");
                    map.put("res", (String)jsonObject);
                }
            } else {
                map.put("flag", "0");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8d44\u6e90\u8be6\u60c5\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            map.put("flag", "0");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/sbma/ResRegistController/add_edit.do"})
    public void doAddOrEdit(@RequestBody String param, HttpServletResponse response) {
        String result;
        try {
            ResourceTmpBean resourceApply = (ResourceTmpBean)JSON.parseObject((String)param, ResourceTmpBean.class);
            if (resourceApply == null) {
                throw new Exception("\u53c2\u6570\u5f02\u5e38");
            }
            resourceApply.setCreatorId(this.operator.getPerson().getId());
            resourceApply.setCreatorName(this.operator.getPerson().getName());
            resourceApply.setOwnerDepCode(this.operator.getPerson().getDepartment().getCode());
            resourceApply.setOwnerIdentifier(this.operator.getPerson().getIdentifier());
            resourceApply.setApproverIdentifier(this.operator.getPerson().getIdentifier());
            result = StringUtils.isEmpty((String)resourceApply.getResourceId()) ? this.registService.addResApply(resourceApply) : this.registService.updateResApply(resourceApply);
        }
        catch (Exception e) {
            LOGGER.error("\u8d44\u6e90\u6ce8\u518c\u5931\u8d25:{}", (Object)e.getMessage());
            result = JSON.toJSONString((Object)RestfulResult.create((String)"", (String)"", (String)"500", (String)e.getMessage(), null));
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)result);
    }
}

