/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.allopatric.apply.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.pams.common.bean.RestfulQuery;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import pams.function.sbma.allopatric.common.AllopaticParam;
import pams.function.sbma.common.dao.RegionalismDao;

@Service
public class AllopatricApplyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllopatricApplyService.class);
    public static final String PARAM_TYPE_PAGE = "page";
    public static final String PARAM_TYPE_REPORT = "page";
    @Autowired
    private RegionalismDao regionalismDao;
    @Autowired
    private SystemConfigPbService systemConfigPbService;

    public Object listApp(AllopaticParam query) {
        String url = this.systemConfigPbService.getValueByCode("sodUrl");
        url = url + "/das/appScope/queryReport";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        try {
            String returnJson = httpRequestUtil.httpPostJson(url, Util.toJsonStr((Object)this.makeQuerySodParam(query)));
            return this.analysisResultPage(returnJson);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public Object listResource(AllopaticParam query) {
        String url = this.systemConfigPbService.getValueByCode("sodUrl");
        url = url + "/das/resourceScope/queryReport";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        try {
            String returnJson = httpRequestUtil.httpPostJson(url, Util.toJsonStr((Object)this.makeQuerySodParam(query)));
            return this.analysisResultPage(returnJson);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public void giveNotice(AllopaticParam query) throws Exception {
        String url = this.systemConfigPbService.getValueByCode("sodUrl");
        if (query.getAppId() != null && query.getAppId().length() > 0) {
            url = url + "/das/appScope/retryReport";
        } else if (query.getResourceId() != null && query.getResourceId().length() > 0) {
            url = url + "/das/appScope/retryReport";
        } else {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38");
        }
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        try {
            String returnJson = httpRequestUtil.httpPostJson(url, Util.toJsonStr((Object)this.makeQuerySodParam(query)));
            this.analysisResult(returnJson);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5f02\u5e38:{}", (Object)e.getMessage());
            throw e;
        }
    }

    public Object listNoticeMeRecordApp(AllopaticParam query) {
        String url = this.systemConfigPbService.getValueByCode("sodUrl");
        url = url + "/das/appScope/applyResult";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        try {
            String returnJson = httpRequestUtil.httpPostJson(url, Util.toJsonStr((Object)this.makeQuerySodParam(query)));
            return this.analysisResultPage(returnJson);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public Object listNoticeMeRecordResource(AllopaticParam query) {
        String url = this.systemConfigPbService.getValueByCode("sodUrl");
        url = url + "/das/resourceScope/applyResult";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        try {
            String returnJson = httpRequestUtil.httpPostJson(url, Util.toJsonStr((Object)this.makeQuerySodParam(query)));
            return this.analysisResultPage(returnJson);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    private Map<String, Object> analysisResultPage(String returnJson) {
        JSONObject pagination = this.analysisResult(returnJson);
        this.format(pagination.getJSONArray("data"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", pagination.get((Object)"count"));
        map.put("rows", pagination.getJSONArray("data"));
        return map;
    }

    private JSONObject analysisResult(String returnJson) {
        JSONObject jsonObject = JSON.parseObject((String)returnJson);
        if (jsonObject != null && "200".equals(jsonObject.getString("code"))) {
            return jsonObject.getJSONObject("data");
        }
        LOGGER.error("\u8bf7\u6c42sod\u5f02\u5e38: {}", (Object)returnJson);
        if (jsonObject != null) {
            throw new RuntimeException(jsonObject.getString("message"));
        }
        throw new RuntimeException("\u8bf7\u6c42sod\u5f02\u5e38");
    }

    private void format(JSONArray list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (Object object : list) {
            JSONObject bean = (JSONObject)object;
            String applyRegionalismCode = bean.getString("applyRegionalismCode");
            if (applyRegionalismCode == null || applyRegionalismCode.length() == 0) {
                applyRegionalismCode = bean.getString("execRegionalismCode");
            }
            bean.put("regionalismName", (Object)this.regionalismDao.getNameByCode(applyRegionalismCode));
        }
    }

    private Object makeQuerySodParam(AllopaticParam query) {
        JSONObject jsonObject = new JSONObject();
        if ("page".equals(query.getType())) {
            jsonObject.put("pageNo", (Object)query.getPage());
            jsonObject.put("pageSize", (Object)query.getRows());
            jsonObject.put("applyRegionalismCode", (Object)query.getApplyRegionalismCode());
            jsonObject.put("status", (Object)query.getStatus());
        } else {
            jsonObject.put("id", (Object)query.getId());
            jsonObject.put("approveId", (Object)query.getApproveId());
            jsonObject.put("appId", (Object)query.getAppId());
            jsonObject.put("applyId", (Object)query.getApplyId());
            jsonObject.put("applyRegionalismCode", (Object)query.getApplyRegionalismCode());
        }
        RestfulQuery restfulQuery = new RestfulQuery();
        restfulQuery.setMessageId(UUIDUtil.random());
        restfulQuery.setVersion("1.0");
        restfulQuery.setParameter((Object)jsonObject);
        return restfulQuery;
    }
}

