/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.common.control;

import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.framework.commons.utils.http.HttpUtils;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import com.xdja.pams.bims.dao.DepartmentDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.common.entity.BusinessType;
import pams.function.sbma.common.entity.Regionalism;
import pams.function.sbma.common.service.BusinessTypeService;
import pams.function.sbma.common.service.RegionalismService;

@Controller
@Scope(value="session")
public class SbmaCommonController
extends BaseControler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SbmaCommonController.class);
    @Autowired
    private BusinessTypeService businessTypeService;
    @Autowired
    private RegionalismService regionalismService;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private SystemConfigService systemConfigService;

    @RequestMapping(value={"/sbma/commonController/businessTypes.do"})
    public void getAllBusinessType(HttpServletResponse response) {
        List<BusinessType> list = this.businessTypeService.getAll();
        BusinessType r = new BusinessType();
        r.setCode("");
        r.setName("---\u8bf7\u9009\u62e9---");
        list.add(0, r);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(list));
    }

    @RequestMapping(value={"/sbma/commonController/resourceTypes.do"})
    public void getAllresourceType(HttpServletResponse response) {
        List list = this.commonCodeService.queryByType("sbma_restype");
        CommonCode r = new CommonCode();
        r.setCode("");
        r.setName("---\u8bf7\u9009\u62e9---");
        list.add(0, r);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)list));
    }

    @RequestMapping(value={"/sbma/commonController/all_regionalism.do"})
    public void queryAllRegionalism(HttpServletResponse response) {
        List<Regionalism> list = this.regionalismService.getAll();
        Regionalism r = new Regionalism();
        r.setCode("");
        r.setName("---\u8bf7\u9009\u62e9---");
        list.add(0, r);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(list));
    }

    @RequestMapping(value={"/sbma/commonController/all_topLevel_regionalism.do"})
    public void queryAllTopLevelRegionalism(HttpServletResponse response) {
        List<Regionalism> list = this.regionalismService.getAllTopLevel();
        Regionalism r = new Regionalism();
        r.setCode("");
        r.setName("---\u8bf7\u9009\u62e9---");
        list.add(0, r);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(list));
    }

    @RequestMapping(value={"/sbma/commonController/regionalism.do"})
    public void queryRegionalism(String q, HttpServletResponse response) {
        List<Regionalism> list = this.regionalismService.getByName(q);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(list));
    }

    @RequestMapping(value={"/sbma/commonController/regionalismTree.do"})
    public void getRegionalismTree(String isSkipLocal, HttpServletResponse response) {
        List<Map<String, Object>> tree = this.regionalismService.getTree(isSkipLocal);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(tree));
    }

    @RequestMapping(value={"/sbma/commonController/serviceDepChoseWin.do"})
    public String toServiceChosePage(String choseDepId, ModelMap map) {
        List level2Dep = this.departmentDao.getLevel2Dep();
        Department department = this.departmentDao.topDep();
        map.put((Object)"top", (Object)department);
        map.put((Object)"deps", (Object)level2Dep);
        map.put((Object)"chose", (Object)choseDepId);
        return "sbma/common/service_dep_chose";
    }

    @RequestMapping(value={"/sbma/commonController/setServiceDep.do"})
    public void setServiceDep(String id, String type, String depId, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        try {
            ResponseWrap execute;
            String mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
            if ("app".equals(type)) {
                mdpUrl = mdpUrl + "/appManagerControl/editAppDep.do";
                execute = HttpUtils.post((String)mdpUrl).addParameter("appId", id).addParameter("vestInDepId", depId).addParameter("mdpOperatorUserId", this.getOperator(request).getPerson().getId()).execute();
            } else {
                mdpUrl = mdpUrl + "/resource/manager/editResourceDep.do";
                HashMap<String, Object> param = new HashMap<String, Object>(3);
                param.put("messageId", UUIDUtil.random());
                param.put("version", "v1.0");
                HashMap<String, String> p = new HashMap<String, String>(3);
                p.put("resourceId", id);
                p.put("vestInDepId", depId);
                p.put("operatorId", this.getOperator(request).getPerson().getId());
                param.put("parameter", p);
                execute = HttpUtils.post((String)mdpUrl).setContentType(ContentType.APPLICATION_JSON).addJson(param).execute();
            }
            int statusCode = execute.getStatusCode();
            if (statusCode != 200) {
                result.put("flag", false);
                result.put("msg", "\u8fdc\u7a0b\u670d\u52a1\u8fd4\u56de\u72b6\u6001\u5f02\u5e38");
                LOGGER.error("\u8bf7\u6c42mdp\u5f02\u5e38\uff1a{}-{}", (Object)statusCode, (Object)execute.getString());
            } else {
                result.put("flag", true);
                result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u7f6e\u670d\u52a1\u5355\u4f4d\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            result.put("flag", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }
}

