/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.common.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.sbma.common.dao.RegionalismDao;
import pams.function.sbma.common.entity.Regionalism;

@Repository
public class RegionalismDaoImpl
implements RegionalismDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public String getNameByCode(String code) {
        String hql = "from Regionalism where code = ?";
        Regionalism regionalism = (Regionalism)this.baseDao.getObjectByHQL(hql, new Object[]{code});
        return regionalism == null ? "" : regionalism.getName();
    }

    @Override
    public Regionalism getById(String code) {
        return (Regionalism)this.baseDao.getObjectById(Regionalism.class, (Serializable)((Object)code));
    }

    @Override
    public String getFullNameByCode(String code, String reg) {
        String sql = "select * from T_SBMA_REGIONALISM start with CODE = ? connect by  CODE = prior PARENT_CODE";
        List nameList = this.baseDao.getListBySQL(sql, new Object[]{code}, Regionalism.class);
        StringBuilder sb = new StringBuilder("");
        if (nameList != null) {
            for (int i = nameList.size() - 1; i >= 0; --i) {
                Regionalism s = (Regionalism)nameList.get(i);
                sb.append(s.getName()).append(reg);
            }
        }
        return sb.toString();
    }

    @Override
    public List<Regionalism> getByName(String name) {
        String hql = "from Regionalism where status=1 ";
        if (StringUtils.isNotBlank((CharSequence)name)) {
            hql = hql + "and name like '%" + name + "%'";
        }
        return this.baseDao.getListByHQL(hql, null);
    }

    @Override
    public List<Regionalism> getAll() {
        String hql = "from Regionalism where status=1 order by code asc";
        return this.baseDao.getListByHQL(hql, null);
    }

    @Override
    public List<Regionalism> getAllTopLevel() {
        String hql = "from Regionalism where status=1 and parentCode is null order by code asc";
        return this.baseDao.getListByHQL(hql, null);
    }

    @Override
    public List<Regionalism> getAllSkip(String skipCode) {
        String hql = "from Regionalism where status=1 and code <> ? order by code asc";
        return this.baseDao.getListByHQL(hql, new Object[]{skipCode});
    }

    @Override
    public void removeAll() {
        String sql = "delete from T_SBMA_REGIONALISM";
        this.baseDao.updateBySql(sql, (Object[])new String[0]);
    }

    @Override
    public Long getMaxLastUpdateTime() {
        String sql = "select max(last_update_time) from T_SBMA_REGIONALISM ";
        String result = this.baseDao.getSingleValue(sql);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return Long.parseLong(result);
        }
        return 0L;
    }

    @Override
    public void saveBatch(List<Regionalism> regionalisms) {
        this.baseDao.createBatch(regionalisms);
    }
}

