/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappapply.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;
import pams.function.sbma.resappapply.bean.AppResourceApplyBean;
import pams.function.sbma.resappapply.dao.AppResourceApplyDao;
import pams.function.sbma.resappapply.entity.AppResourceApply;

@Repository
public class AppResourceApplyDaoImpl
implements AppResourceApplyDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppResourceApplyDaoImpl.class);
    @Autowired
    private BaseDao baseDao;
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_TAIL_DAYSTART = " 00:00:00";
    private static final String TIME_TAIL_DAYEND = " 23:59:59";

    @Override
    public List<AppResourceApply> pageAppResourceApply(AppResourceApplyBean bean, Page page) {
        try {
            StringBuilder from = new StringBuilder(" from T_SBMA_APP_RESOURCE_APPLY ara where 1=1");
            ArrayList<Object> args = new ArrayList<Object>();
            if (StringUtils.hasText((String)bean.getResName())) {
                from.append(" and ara.RESOURCE_NAME like ? ");
                args.add("%" + bean.getResName() + "%");
            }
            if (StringUtils.hasText((String)bean.getResType())) {
                from.append(" and ara.RESOURCE_TYPE = ? ");
                args.add(bean.getResType());
            }
            if (StringUtils.hasText((String)bean.getApplyTimeStartString())) {
                from.append(" and ara.CREATE_TIME >= ? ");
                args.add(Util.parseDate((String)(bean.getApplyTimeStartString() + TIME_TAIL_DAYSTART), (String)DATE_TIME_FORMAT).getTime());
            }
            if (StringUtils.hasText((String)bean.getApplyTimeEndString())) {
                from.append(" and ara.CREATE_TIME <= ? ");
                args.add(Util.parseDate((String)(bean.getApplyTimeEndString() + TIME_TAIL_DAYEND), (String)DATE_TIME_FORMAT).getTime());
            }
            if (StringUtils.hasText((String)bean.getAppName())) {
                from.append(" and ara.APP_NAME like ?");
                args.add("%" + bean.getAppName() + "%");
            }
            if (StringUtils.hasText((String)bean.getResourceRegionalismCode())) {
                from.append(" and ara.RESOURCE_REGIONALISM_CODE = ?");
                args.add(bean.getResourceRegionalismCode());
            }
            if (StringUtils.hasText((String)bean.getAppRegionalismCode())) {
                from.append(" and ara.APP_REGIONALISM_CODE = ?");
                args.add(bean.getAppRegionalismCode());
            }
            if (StringUtils.hasText((String)bean.getResNetWork())) {
                from.append(" and ara.RESOURCE_NETWORK_CODE = ?");
                args.add(bean.getResNetWork());
            }
            if (StringUtils.hasText((String)bean.getAppNetWork())) {
                from.append(" and ara.APP_NETWORK_CODE = ?");
                args.add(bean.getAppNetWork());
            }
            if (StringUtils.hasText((String)bean.getApplyStatus())) {
                from.append(" and ara.STATUS = ?");
                args.add(bean.getApplyStatus());
            }
            from.append(" order by ara.LAST_UPDATE_TIME desc, CREATE_TIME desc, APP_RESOURCE_APPLY_ID");
            StringBuilder countSql = new StringBuilder("select count(1)").append((CharSequence)from);
            StringBuilder selectSql = new StringBuilder("select * ").append((CharSequence)from);
            return this.baseDao.getListBySQL(countSql.toString(), selectSql.toString(), args.toArray(new Object[args.size()]), page, AppResourceApply.class);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5e94\u7528\u8d44\u6e90\u7533\u8bf7\u5217\u8868DAO\u5c42\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public AppResourceApply getByApplyId(String applyId) {
        return (AppResourceApply)this.baseDao.getObjectById(AppResourceApply.class, (Serializable)((Object)applyId));
    }

    @Override
    public boolean updateAppResourceApply(AppResourceApply apply) {
        try {
            apply.setLastUpdateTime(System.currentTimeMillis());
            this.baseDao.update((Object)apply);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5e94\u7528\u8d44\u6e90\u7533\u8bf7\u72b6\u6001DAO\u5c42\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean accredit(String applyId, String status) {
        String sql = "update T_SBMA_APP_RESOURCE_APPLY set STATUS = ?, LAST_UPDATE_TIME = ? where APP_RESOURCE_APPLY_ID = ?";
        Object[] param = new Object[]{status, new Date(), applyId};
        try {
            BigDecimal bigDecimal = (BigDecimal)this.baseDao.updateBySql(sql, param);
            if (bigDecimal != null) {
                return bigDecimal.intValue() == 1;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5e94\u7528\u8d44\u6e90\u6388\u6743DAO\u5c42\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return false;
    }

    @Override
    public List<AppResourceApply> getAppResourceApplyInfo(String regionalismCode, String appId) {
        String hql = "from AppResourceApply where appRegionalismCode = ? and appId = ?";
        return this.baseDao.getListByHQL(hql, new Object[]{regionalismCode, appId});
    }
}

