/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappapply.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.sbma.resappapply.dao.AppResourceDao;
import pams.function.sbma.resappapply.entity.AppResource;

@Repository
public class AppResourceDaoImpl
implements AppResourceDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppResourceDaoImpl.class);
    @Autowired
    private BaseDao baseDao;

    @Override
    public AppResource getAppResource(String appId, String appDivisionCode, String appNetWork, String resId, String resDivisionCode, String resNetWork) {
        StringBuilder hql = new StringBuilder("from AppResource ");
        hql.append(" where appId = ? and appRegionalismCode = ? and appNetworkCode = ? ");
        hql.append("  and resourceId = ? and resourceRegionalismCode = ? and resourceNetworkCode = ? ");
        AppResource appResource = (AppResource)this.baseDao.getObjectByHQL(hql.toString(), new Object[]{appId, appDivisionCode, appNetWork, resId, resDivisionCode, resNetWork});
        return appResource;
    }

    @Override
    public boolean applyToFormal(AppResource appResource) {
        try {
            appResource.setLastUpdateTime(System.currentTimeMillis());
            this.baseDao.create((Object)appResource);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e94\u7528\u6388\u6743\u6b63\u5f0f\u6570\u636eDAO\u5c42\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean removeFormalAppResource(String appId, String appDivisionCode, String appNetWork, String resId, String resDivisionCode, String resNetWork) {
        try {
            StringBuilder sql = new StringBuilder("update T_SBMA_APP_RESOURCE set STATUS = 0, LAST_UPDATE_TIME = ? ");
            sql.append(" where APP_ID = ? and APP_REGIONALISM_CODE = ? and APP_NETWORK_CODE = ? ");
            sql.append("  and RESOURCE_ID = ? and RESOURCE_REGIONALISM_CODE = ? and RESOURCE_NETWORK_CODE = ? ");
            Object[] args = new Object[]{System.currentTimeMillis(), appId, appDivisionCode, appNetWork, resId, resDivisionCode, resNetWork};
            this.baseDao.updateBySql(sql.toString(), args);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5e94\u7528\u8d44\u6e90\u6388\u6743\u4fe1\u606fDAO\u5c42\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean updateAppResource(AppResource appResource) {
        appResource.setLastUpdateTime(System.currentTimeMillis());
        this.baseDao.update((Object)appResource);
        return true;
    }
}

