/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resapply.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.framework.commons.utils.http.HttpUtils;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import com.xdja.pams.common.bean.RestfulQuery;
import com.xdja.pams.common.bean.RestfulResult;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.sbma.resapply.bean.ResourceApplyBean;
import pams.function.sbma.resapply.bean.ReviewResBean;
import pams.function.sbma.resapply.service.ResourceApplyService;

@Service
public class ResourceApplyServiceImpl
implements ResourceApplyService {
    @Autowired
    private SystemConfigService systemConfigService;
    private static final Logger logger = LoggerFactory.getLogger(ResourceApplyServiceImpl.class);
    private String mdpUrl;

    @Override
    public JSONObject queryList(ResourceApplyBean queryBean) {
        RestfulQuery restfulQuery;
        ResponseWrap responseWrap;
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/queryResourceApplyList.do";
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("pageNo", queryBean.getPage());
        parameter.put("pageSize", queryBean.getRows());
        parameter.put("status", queryBean.getStatus());
        parameter.put("resourceName", queryBean.getName());
        parameter.put("networkCode", queryBean.getNetworkCode());
        parameter.put("vestInDepId", queryBean.getVestInDepId());
        if (queryBean.getType() != null) {
            parameter.put("type", new Integer[]{queryBean.getType()});
        }
        if (200 != (responseWrap = this.postRequest(url, restfulQuery = RestfulQuery.getRestfulQuery(parameter))).getStatusCode()) {
            logger.error("\u83b7\u53d6\u6240\u6709\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u83b7\u53d6\u6240\u6709\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u83b7\u53d6\u6240\u6709\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u83b7\u53d6\u6240\u6709\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u7533\u8bf7\u8d44\u6e90\u5217\u8868\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return RestfulResult.checkCodeAndGetData((String)result);
    }

    @Override
    public String publish(String resourceApplyId, String operatorId, String vestInDepId) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/publish.do";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("resourceApplyId", resourceApplyId);
        parameter.put("operatorId", operatorId);
        parameter.put("vestInDepId", vestInDepId);
        RestfulQuery restfulQuery = RestfulQuery.getRestfulQuery(parameter);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u53d1\u5e03\u8d44\u6e90\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u53d1\u5e03\u8d44\u6e90\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u53d1\u5e03\u8d44\u6e90\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u53d1\u5e03\u8d44\u6e90\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u5e03\u8d44\u6e90\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return result;
    }

    @Override
    public String review(ReviewResBean reviewResBean) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/review.do";
        RestfulQuery restfulQuery = RestfulQuery.getRestfulQuery((Object)reviewResBean);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u5ba1\u6838\u8d44\u6e90\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u5ba1\u6838\u8d44\u6e90\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u5ba1\u6838\u8d44\u6e90\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u5ba1\u6838\u8d44\u6e90\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u5ba1\u6838\u8d44\u6e90\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return result;
    }

    private void setMdpUrl() {
        this.mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        if (StringUtils.isBlank((CharSequence)this.mdpUrl)) {
            throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25\uff0c\u7cfb\u7edf\u672a\u914d\u7f6emdp\u5730\u5740");
        }
    }

    private ResponseWrap postRequest(String url, RestfulQuery restfulQuery) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)restfulQuery));
        }
        return HttpUtils.post((String)url).setConnectTimeout(500).addJson((Object)restfulQuery).execute();
    }
}

