/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resappmanager.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.tims.bean.AppNoticeBean;
import com.xdja.pams.tims.service.MsgPushService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.resappapply.entity.AppResourceApply;
import pams.function.sbma.resappapply.service.AppResourceApplyService;
import pams.function.sbma.resappmanager.bean.AddGreyScopeException;
import pams.function.sbma.resappmanager.bean.AppBean;
import pams.function.sbma.resappmanager.bean.AppUseAreaForm;
import pams.function.sbma.resappmanager.bean.PageBean;
import pams.function.sbma.resappmanager.service.SbmaAppManagerService;

@Controller
@Scope(value="session")
public class SbmaAppManagerControler
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(SbmaAppManagerControler.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SbmaAppManagerService appManagerService;
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    private MsgPushService msgPushService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    MsgPushService sendAppNotice;
    @Autowired
    private AppResourceApplyService appResourceApplyService;

    @RequestMapping(value={"/sbma/AppResourceManagerController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        String fastdfsUrl = "";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/queryAppList.do"})
    public void queryAppList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, AppBean appBean) {
        int operateResult = 1;
        this.setOperator(request);
        String resultJson = null;
        try {
            appBean.setMdpOperatorUserId(this.person.getId());
            appBean.setVestInDepId(this.getControlDeps(request));
            resultJson = this.appManagerService.queryList(appBean, page);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u5e94\u7528\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)resultJson);
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/upAndDownApp.do"})
    public void upAndDownApp(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String showStatus) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            PageBean pageBean = this.appManagerService.upAndDownApp(appId, showStatus, this.person.getId(), this.getControlDeps(request));
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u7528\u4e0a\u67b6\u4e0b\u67b6\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/recommend.do"})
    public void recommend(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String recommend) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            PageBean pageBean = this.appManagerService.recommend(appId, recommend, this.person.getId(), this.getControlDeps(request));
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u63a8\u8350\u6216\u53d6\u6d88\u63a8\u8350\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/zjbb.do"})
    public void zjbb(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String label) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            PageBean pageBean = this.appManagerService.zjbb(appId, label, this.person.getId(), this.getControlDeps(request));
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u63a8\u8350\u6216\u53d6\u6d88\u63a8\u8350\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/queryHistoryList.do"})
    public void queryHistoryList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, String appId) {
        int operateResult = 1;
        this.setOperator(request);
        String resultJson = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            resultJson = this.appManagerService.queryHistoryList(appId, page, personId, this.getControlDeps(request));
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u5e94\u7528\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)resultJson);
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toDetails.do"})
    public String toDetails(String applyId, String appId, String isGrey, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        AppBean appBean = new AppBean();
        String fastdfsUrl = "";
        try {
            String vestInDepId = this.getControlDeps(request);
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
            String personId = this.person != null ? this.person.getId() : null;
            appBean = this.appManagerService.getAppManager(applyId, appId, personId, isGrey, vestInDepId);
            appBean.setApplyId(applyId);
            SystemConfig systemConfig = this.systemConfigService.getByCode("sodUrl");
            if (systemConfig == null) {
                map.put((Object)"hasResource", (Object)false);
            } else {
                map.put((Object)"hasResource", (Object)true);
                List<AppResourceApply> list = this.appResourceApplyService.getResourceOfAppByAppInfoFromMdp(appBean.getAppId());
                map.put((Object)"appResource", list);
            }
            String string = this.systemConfigService.getValueByCode("regionalismCode");
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e);
        }
        map.put((Object)"appBean", (Object)appBean);
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        if (!Util.varCheckEmp((String)applyId)) {
            return "sbma/resappmanager/defaulte/detailsTmp";
        }
        return "sbma/resappmanager/defaulte/details";
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toAudit.do"})
    public String toAudit(String applyId, String resApplyId, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        AppBean appBean = new AppBean();
        String fastdfsUrl = "";
        try {
            String personId = this.person != null ? this.person.getId() : null;
            appBean = this.appManagerService.getAppManager(applyId, null, personId, null, this.getControlDeps(request));
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
            appBean.setApplyId(resApplyId);
            String localRegionalism = this.systemConfigService.getValueByCode("regionalismCode");
            List<AppResourceApply> list = this.appResourceApplyService.getResourceOfAppByAppInfoFromMdp(appBean.getAppId());
            map.put((Object)"appResource", list);
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e);
        }
        map.put((Object)"appBean", (Object)appBean);
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        return "sbma/resappmanager/defaulte/audit";
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toView.do"})
    public String toView(String appId, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        map.put((Object)"appId", (Object)appId);
        return "sbma/resappmanager/defaulte/view";
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/appAduit.do"})
    public void appAduit(ModelMap map, HttpServletRequest request, HttpServletResponse response, String auditUserId, String applyId, String auditResult, String approveStatus, String lockVersion) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            pageBean = this.appManagerService.appAduit(this.person.getId(), applyId, auditResult, approveStatus, lockVersion, this.getControlDeps(request));
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/createApp.do"})
    public void createApp(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String applyId, String lockVersion) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            pageBean = this.appManagerService.createApp(appId, applyId, personId, lockVersion, this.getControlDeps(request));
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/updateApp.do"})
    public void updateApp(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String applyId, String lockVersion) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            pageBean = this.appManagerService.updateApp(appId, applyId, personId, lockVersion, this.getControlDeps(request));
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
                AppBean appBean = this.appManagerService.getAppManager(appId, this.getControlDeps(request));
                AppNoticeBean appNoticeBean = new AppNoticeBean();
                appNoticeBean.setAppId(appId);
                appNoticeBean.setAppName(appBean.getAppName());
                appNoticeBean.setPackageName(appBean.getAppPackage());
                appNoticeBean.setMsg(sendContent);
                try {
                    this.msgPushService.sendUpdateAppNotice(appNoticeBean);
                }
                catch (Exception e) {
                    log.error("\u5e94\u7528\u53d1\u5e03\u53d1\u9001\u5347\u7ea7\u63a8\u9001\u5931\u8d25\uff01", (Throwable)e);
                }
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/setAppResEnableOrDisable.do"})
    public void setAppResEnableOrDisable(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String able) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            pageBean = this.appManagerService.setAppResEnableOrDisable(appId, able, personId, this.getControlDeps(request));
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/setAppVersionRollback.do"})
    public void setAppVersionRollback(ModelMap map, HttpServletRequest request, HttpServletResponse response, String appId, String able) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        String sendContent = "";
        PageBean pageBean = null;
        try {
            String personId = this.person != null ? this.person.getId() : null;
            pageBean = this.appManagerService.setAppVersionRollback(appId, personId, this.getControlDeps(request));
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u7248\u672c\u56de\u9000\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/silentInstall.do"})
    public void silentInstall(HttpServletRequest request, HttpServletResponse response, String appId, String silentInstall) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            PageBean pageBean = this.appManagerService.silentInstall(appId, silentInstall, this.person.getId(), this.getControlDeps(request));
            if ("1".equals(pageBean.getState())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                operateResult = 1;
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(pageBean.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("\u9759\u9ed8\u5b89\u88c5\u8bbe\u7f6e\u51fa\u9519", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/getMdpDictByType.do"})
    public void getDictByType(String type, HttpServletResponse response) {
        String jsonList = "";
        try {
            List<Map<String, Object>> mapList = this.appManagerService.getMdpDictByType(type);
            jsonList = JSON.toJSONString(mapList);
        }
        catch (Exception e) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + type + "\u3011\uff1a" + e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)jsonList);
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toSetReleaseScope.do"})
    public String toSetReleaseScope(String appId, String roamingAble, ModelMap modelMap) {
        try {
            String divisionCode = this.appManagerService.getDivisionCode();
            Object allReleaseScope = this.appManagerService.getAllReleaseScope();
            Object appReleaseScope = this.appManagerService.getAppReleaseScope(appId);
            modelMap.put((Object)"allReleaseScope", (Object)JSON.toJSONString((Object)allReleaseScope));
            modelMap.put((Object)"divisionCode", (Object)divisionCode);
            modelMap.put((Object)"appReleaseScope", (Object)JSON.toJSONString((Object)appReleaseScope));
            modelMap.put((Object)"roamingAble", (Object)roamingAble);
            modelMap.put((Object)"hasOtherPublishArea", (Object)this.hasOtherPublishArea(divisionCode, appReleaseScope));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "error/error";
        }
        return "sbma/resappmanager/defaulte/releaseScope";
    }

    private boolean hasOtherPublishArea(String local, Object appReleaseScope) {
        try {
            String s = JSON.toJSONString((Object)appReleaseScope);
            JSONObject jsonObject = JSON.parseObject((String)s);
            JSONArray regionalisms = jsonObject.getJSONArray("regionalisms");
            if (regionalisms.isEmpty()) {
                return false;
            }
            if (regionalisms.size() == 1) {
                Object o = regionalisms.get(0);
                return regionalisms.get(0) == null || !local.equals(o);
            }
            for (int i = 0; i < regionalisms.size(); ++i) {
                Object o = regionalisms.get(i);
                if (o == null || local.equals(o)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u662f\u5426\u6709\u9664\u672c\u5730\u4e4b\u5916\u7684\u53d1\u5e03\u8303\u56f4\u9519\u8bef");
            return false;
        }
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/setReleaseScope.do"})
    public void setReleaseScope(String appId, String area, String roamingAble, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            if (roamingAble != null && roamingAble.length() > 0) {
                this.appManagerService.setAppRoamingAble(appId, roamingAble, this.getControlDeps(request));
                if (!"1".equals(roamingAble)) {
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
                    Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
                    return;
                }
            }
            this.appManagerService.setReleaseScope(appId, area, this.getControlDeps(request));
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u53d1\u5e03\u8303\u56f4\u51fa\u9519", (Throwable)e);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(3), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toResDetailPage.do"})
    public String toResDetailPage(String appResApplyId, String resourceId, String resourceRegionalismCode, ModelMap map) {
        map.addAttribute("appResApplyId", (Object)appResApplyId);
        map.addAttribute("resourceId", (Object)resourceId);
        map.addAttribute("resourceRegionalismCode", (Object)resourceRegionalismCode);
        return "sbma/resappmanager/defaulte/resInfo";
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/createGreyVersion.do"})
    public void createGreyVersion(AppUseAreaForm form, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            if (form == null || form.getAppUseArea() == null || form.getAppUseArea().isEmpty()) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg("\u6388\u6743\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u7a7a");
            } else {
                String personId = this.person.getId();
                form.setPersonId(personId);
                form.setVestInDepId(this.getControlDeps(request));
                this.appManagerService.createAppGreyVersion(form);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7070\u5ea6\u53d1\u5e03\u7248\u672c\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            if (e instanceof AddGreyScopeException) {
                rtnResult.setRtnMsg(e.getMessage());
            }
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/toGroupMemberNew.do"})
    public String toGroupMemberNew(String appId, String maxCount, String isCreate, String additional, ModelMap map) {
        List<Person> list = null;
        try {
            if (!"1".equals(isCreate)) {
                list = this.appManagerService.greyReleasedShowBack(appId);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7070\u5ea6\u5e94\u7528\u8303\u56f4\u5f02\u5e38", (Throwable)e);
        }
        if (list == null) {
            list = new ArrayList<Person>();
        }
        map.put((Object)"personList", list);
        int i_maxCount = 100;
        if (StringUtils.isNotBlank((CharSequence)maxCount)) {
            try {
                i_maxCount = Integer.parseInt(maxCount);
            }
            catch (NumberFormatException e) {
                log.error("\u7070\u5ea6\u5e94\u7528\u8303\u56f4\u5f02\u5e38", (Throwable)e);
            }
        }
        map.put((Object)"maxCount", (Object)i_maxCount);
        StringBuffer personStrList = new StringBuffer("#");
        StringBuffer nowShowPersonStrList = new StringBuffer("#");
        StringBuffer depStrList = new StringBuffer("#");
        StringBuffer personTypeStrList = new StringBuffer("#");
        StringBuffer sexStrList = new StringBuffer("#");
        StringBuffer policeStrList = new StringBuffer("#");
        HashMap personMapAll = new HashMap();
        int i = 0;
        ArrayList personMapList = new ArrayList();
        for (Person person : list) {
            HashMap<String, String> personMap = new HashMap<String, String>();
            if ("person".equals(person.getFlag())) {
                personMap.put("id", person.getId());
                personMap.put("name", person.getName());
                personMap.put("code", person.getCode());
                personMap.put("flag", person.getFlag());
                if (i < 10) {
                    personMapList.add(personMap);
                } else {
                    nowShowPersonStrList.append(person.getId()).append("#");
                }
                ++i;
                personStrList.append(person.getId()).append("#");
                personMapAll.put(person.getId(), personMap);
                continue;
            }
            personMap.put("id", person.getId());
            personMap.put("name", person.getName());
            personMap.put("code", person.getCode());
            personMap.put("flag", person.getFlag());
            personMapList.add(personMap);
            if ("dep".equals(person.getFlag())) {
                depStrList.append(person.getId()).append("#");
                continue;
            }
            if ("police".equals(person.getFlag())) {
                policeStrList.append(person.getCode()).append("#");
                continue;
            }
            if ("sex".equals(person.getFlag())) {
                sexStrList.append(person.getCode()).append("#");
                continue;
            }
            if (!"PERSON_TYPE".equals(person.getFlag())) continue;
            personTypeStrList.append(person.getCode()).append("#");
        }
        map.put((Object)"personStrList", (Object)personStrList);
        map.put((Object)"depStrList", (Object)depStrList);
        map.put((Object)"policeStrList", (Object)policeStrList);
        map.put((Object)"sexStrList", (Object)sexStrList);
        map.put((Object)"personTypeStrList", (Object)personTypeStrList);
        map.put((Object)"nowShowPersonStrList", (Object)nowShowPersonStrList);
        map.put((Object)"personMapAll", (Object)Util.toJsonStr(personMapAll));
        map.put((Object)"personListJson", (Object)Util.toJsonStr(personMapList));
        map.put((Object)"isAdditional", (Object)additional);
        if ("1".equals(additional)) {
            return "sbma/resappmanager/defaulte/groupMemberNew_additional";
        }
        return "sbma/resappmanager/defaulte/groupMemberNew";
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/modifyGreyScope.do"})
    public void modifyGreyScope(AppUseAreaForm form, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            if (form == null || form.getAppUseArea() == null || form.getAppUseArea().isEmpty()) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg("\u6388\u6743\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u7a7a");
            } else {
                form.setVestInDepId(this.getControlDeps(request));
                this.appManagerService.modifyAppGreyScope(form);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u7070\u5ea6\u53d1\u5e03\u8303\u56f4\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            if (e instanceof AddGreyScopeException) {
                rtnResult.setRtnMsg(e.getMessage());
            }
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/greyToFormal.do"})
    public void greyToFormal(String appId, String lockVersion, HttpServletResponse response, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.appManagerService.greyToFormal(appId, lockVersion, this.person.getId(), this.getControlDeps(request));
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("\u7070\u5ea6\u7248\u672c\u8f6c\u6b63\u5f0f\u7248\u672c", (Throwable)e);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/greyUpAndDownApp.do"})
    public void greyUpAndDownApp(HttpServletResponse response, String appId, String showStatus, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            this.appManagerService.greyUpAndDownApp(appId, showStatus, this.person.getId(), this.getControlDeps(request));
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u7528\u4e0a\u67b6\u4e0b\u67b6\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/greySilentInstall.do"})
    public void greySilentInstall(HttpServletResponse response, String appId, String silentInstall, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            this.appManagerService.greySilentInstall(appId, silentInstall, this.person.getId(), this.getControlDeps(request));
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u9759\u9ed8\u5b89\u88c5\u8bbe\u7f6e\u51fa\u9519", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/greyRecommend.do"})
    public void greyRecommend(HttpServletResponse response, String appId, String recommend, HttpServletRequest request) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            this.appManagerService.greyRecommend(appId, recommend, this.person.getId(), this.getControlDeps(request));
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u63a8\u8350\u6216\u53d6\u6d88\u63a8\u8350\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(2), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/sbma/appFirstAuditController/index.do"})
    public String toAppFirstAuditIndex(HttpServletRequest request, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        String fastdfsUrl = "";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL") + "/";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        map.put((Object)"fastdfsUrl", (Object)fastdfsUrl);
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/AppResourceManagerController/queryAppFirstAuditList.do"})
    public void queryAppFirstAuditList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page, AppBean appBean) {
        this.setOperator(request);
        String resultJson = null;
        try {
            appBean.setMdpOperatorUserId(this.person.getId());
            appBean.setVestInDepId(this.getControlDeps(request));
            resultJson = this.appManagerService.queryAppFirstAuditList(appBean, page);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5e94\u7528\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, resultJson);
    }
}

