/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resmanager.control;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.sbma.common.service.SodService;
import pams.function.sbma.resapply.bean.ResourceApplyBean;

@Controller
@Scope(value="session")
public class SbmaAlloPatryResourceController
extends BaseControler {
    private static Logger logger = LoggerFactory.getLogger(SbmaAlloPatryResourceController.class);
    @Autowired
    private SodService sodService;
    @Autowired
    private ResourceBundleMessageSource message;

    @RequestMapping(value={"/sbma/AlloPatryResourceController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            modelMap.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/sbma/AlloPatryResourceController/queryList.do"})
    public void queryList(ResourceApplyBean queryBean, HttpServletResponse response) {
        try {
            Page page = new Page(queryBean.getPage(), queryBean.getRows());
            HashMap<String, Object> result = new HashMap<String, Object>();
            List<JSONObject> list = this.sodService.getAlloPatryList(queryBean, page);
            result.put("total", page.getTotal());
            result.put("rows", list);
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f02\u5730\u8d44\u6e90\u5217\u8868\u5931\u8d25" + e.getMessage());
        }
    }

    @RequestMapping(value={"/sbma/AlloPatryResourceController/toDetail.do"})
    public String toDetail(String resourceId, String regionalismCode, ModelMap map) {
        try {
            JSONObject bean = this.sodService.queryDetail(resourceId, regionalismCode);
            map.put((Object)"bean", (Object)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f02\u5730\u8d44\u6e90\u5931\u8d25" + e.getMessage());
        }
        return "sbma/allopatryres/default/detail";
    }

    @RequestMapping(value={"/sbma/AlloPatryResourceController/getDetail.do"})
    public void getDetail(String resourceId, String regionalismCode, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject bean = this.sodService.queryDetail(resourceId, regionalismCode);
            map.put("res", bean);
            map.put("flag", true);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f02\u5730\u8d44\u6e90\u8be6\u60c5\u5931\u8d25" + e.getMessage());
            map.put("flag", false);
            map.put("msg", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }
}

