/*
 * Decompiled with CFR 0.152.
 */
package pams.function.sbma.resmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xdja.framework.commons.utils.http.HttpUtils;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import com.xdja.pams.common.bean.RestfulQuery;
import com.xdja.pams.common.bean.RestfulResult;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigService;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.sbma.resapply.bean.ResourceApplyBean;
import pams.function.sbma.resmanager.service.ResourceService;

@Service
public class ResourceServiceImpl
implements ResourceService {
    @Autowired
    private SystemConfigService systemConfigService;
    private String mdpUrl;
    private static final Logger logger = LoggerFactory.getLogger(ResourceServiceImpl.class);

    @Override
    public JSONObject queryList(ResourceApplyBean queryBean) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/queryResourceList.do";
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("pageSize", queryBean.getRows());
        parameter.put("pageNo", queryBean.getPage());
        parameter.put("status", queryBean.getStatus());
        parameter.put("vestInDepId", queryBean.getVestInDepId());
        if (queryBean.getType() != null) {
            parameter.put("type", new Integer[]{queryBean.getType()});
        }
        parameter.put("networkCode", queryBean.getNetworkCode());
        parameter.put("resourceName", queryBean.getName());
        RestfulQuery restfulQuery = RestfulQuery.getRestfulQuery(parameter);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u5217\u8868\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return RestfulResult.checkCodeAndGetData((String)result);
    }

    @Override
    public JSONObject queryById(String resourceId) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/getResourceById.do";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("resourceId", resourceId);
        RestfulQuery restfulQuery = RestfulQuery.getRestfulQuery(parameter);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u8be6\u60c5\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u8be6\u60c5\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u8be6\u60c5\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u8be6\u60c5\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u6b63\u5f0f\u8d44\u6e90\u8be6\u60c5\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return RestfulResult.checkCodeAndGetData((String)result);
    }

    @Override
    public JSONObject queryResourceScopeList(String resourceId) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/getResourceScope.do";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("resourceId", resourceId);
        RestfulQuery restfulQuery = RestfulQuery.getRestfulQuery(parameter);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u83b7\u53d6\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u83b7\u53d6\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u83b7\u53d6\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return RestfulResult.checkCodeAndGetData((String)result);
    }

    @Override
    public String setPublishScope(ResourceApplyBean bean) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/changeScope.do";
        String resourceId = bean.getResourceId();
        String regionalismCodes = bean.getRegionalismCodes();
        String[] scopes = regionalismCodes.split(",");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("resourceId", resourceId);
        parameter.put("scopes", new HashSet<String>(Arrays.asList(scopes)));
        parameter.put("vestInDepId", bean.getVestInDepId());
        RestfulQuery restfulQuery = RestfulQuery.getRestfulQuery(parameter);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u8bbe\u7f6e\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u8bbe\u7f6e\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u8bbe\u7f6e\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u8bbe\u7f6e\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u7f6e\u8d44\u6e90\u53d1\u5e03\u8303\u56f4\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return result;
    }

    @Override
    public void setRoamingAble(String resourceId, String roamingAble, String vestInDepId) throws Exception {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/editResourceRoaming.do";
        RestfulQuery restfulQuery = new RestfulQuery();
        restfulQuery.setMessageId(Util.getUUID());
        restfulQuery.setVersion("1.0");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("resourceId", (Object)resourceId);
        jsonObject.put("roamingAble", (Object)roamingAble);
        jsonObject.put("vestInDepId", (Object)vestInDepId);
        restfulQuery.setParameter((Object)jsonObject);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String result = URLDecoder.decode(httpRequestUtil.postJson(url, JSON.toJSONString((Object)restfulQuery)), "utf-8");
        logger.debug("\u8bbe\u7f6e\u8d44\u6e90\u662f\u5426\u5141\u8bb8\u6f2b\u6e38\u7ed3\u679c\uff1a{}", (Object)result);
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new RuntimeException("\u8bbe\u7f6e\u8d44\u6e90\u662f\u5426\u5141\u8bb8\u6f2b\u6e38\u7ed3\u679c\u51fa\u9519\uff1a\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
        }
        RestfulResult restfulResult = (RestfulResult)JSON.parseObject((String)result, (TypeReference)new TypeReference<RestfulResult<JSONObject>>(){}, (Feature[])new Feature[0]);
        if (!"200".equals(restfulResult.getCode())) {
            throw new RuntimeException(restfulResult.getMessage());
        }
    }

    @Override
    public String upOrDown(ResourceApplyBean queryBean) {
        this.setMdpUrl();
        String url = this.mdpUrl + "/resource/manager/upOrDownStatus.do";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("resourceId", queryBean.getResourceId());
        parameter.put("changeStatus", String.valueOf(queryBean.getStatus()));
        parameter.put("operatorId", queryBean.getOperatorId());
        parameter.put("vestInDepId", queryBean.getVestInDepId());
        RestfulQuery restfulQuery = RestfulQuery.getRestfulQuery(parameter);
        ResponseWrap responseWrap = this.postRequest(url, restfulQuery);
        if (200 != responseWrap.getStatusCode()) {
            logger.error("\u8d44\u6e90\u4e0a\u4e0b\u67b6\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38\uff1a{}", (Object)responseWrap.getStatusCode());
            throw new RuntimeException("\u8d44\u6e90\u4e0a\u4e0b\u67b6\u5931\u8d25\uff0c\u72b6\u6001\u7801\u5f02\u5e38");
        }
        String result = responseWrap.getString();
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("\u8d44\u6e90\u4e0a\u4e0b\u67b6\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new RuntimeException("\u8d44\u6e90\u4e0a\u4e0b\u67b6\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u5ba1\u8d44\u6e90\u4e0a\u4e0b\u67b6\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        }
        return result;
    }

    private void setMdpUrl() {
        this.mdpUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL");
        if (StringUtils.isBlank((CharSequence)this.mdpUrl)) {
            throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25\uff0c\u7cfb\u7edf\u672a\u914d\u7f6emdp\u5730\u5740");
        }
    }

    private ResponseWrap postRequest(String url, RestfulQuery restfulQuery) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)restfulQuery));
        }
        return HttpUtils.post((String)url).setConnectTimeout(500).addJson((Object)restfulQuery).execute();
    }
}

