/*
 * Decompiled with CFR 0.152.
 */
package pams.function.smcs.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import pams.function.smcs.bean.ReportInfo;
import pams.function.smcs.bean.SmcsResult;
import pams.function.smcs.service.SmcsReportService;

public abstract class SmcsAbstactReportServiceImpl<T>
implements InitializingBean,
SmcsReportService {
    protected ReportInfo reportInfo;
    protected LoadingCache<String, String> cache;
    @Autowired
    private SystemConfigService systemConfigService;
    private static final Logger log = LoggerFactory.getLogger(SmcsAbstactReportServiceImpl.class);

    public void afterPropertiesSet() {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(25L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String cacheKey) throws Exception {
                return SmcsAbstactReportServiceImpl.this.getSmcsToken();
            }
        });
    }

    protected abstract List<T> queryAscReportList(Long var1, Integer var2);

    protected abstract long getObjectUpdateTime(T var1);

    protected abstract boolean isDeleteObject(T var1);

    protected Long getLastUpdateTime() {
        String timestamp = this.systemConfigService.getValueByCode(this.reportInfo.getTimestampCode());
        log.debug("\u83b7\u53d6\u5230\u7684{}\u7684\u65f6\u95f4\u6233\u4e3a:{}\u3002smcsType:" + this.reportInfo.getSmcsTypeEnum().getName(), (Object)this.reportInfo.getTimestampCode(), (Object)timestamp);
        if (StringUtils.isEmpty((CharSequence)timestamp)) {
            log.error("\u672a\u83b7\u53d6\u5230{}\u7684\u65f6\u95f4\u6233\uff0c\u9ed8\u8ba4\u53d60\u3002smcsType:" + this.reportInfo.getSmcsTypeEnum().getName(), (Object)this.reportInfo.getTimestampCode());
            return 0L;
        }
        return new Long(timestamp);
    }

    protected void doReport(ReportInfo reportInfo) throws Exception {
        if (reportInfo == null) {
            log.error("reportInfo\u4e3anull");
            throw new Exception("reportInfo\u4e3anull");
        }
        this.reportInfo = reportInfo;
        if (!this.checkReportSwitch()) {
            log.debug("{}\u4e0a\u62a5\u5f00\u5173\u672a\u5f00\u542f", (Object)this.reportInfo.getSwitchCode());
            return;
        }
        int cycleIndex = 0;
        do {
            Long lastUpdateTime = this.getLastUpdateTime();
            log.debug("\u7b2c" + (cycleIndex + 1) + "\u6b21\u66f4\u65b0\u7684\u65f6\u95f4\u6233lastUpdateTime:{}\u3002smcsType:" + reportInfo.getSmcsTypeEnum().getName(), (Object)lastUpdateTime);
            List<T> reportList = this.queryAscReportList(lastUpdateTime, reportInfo.getBatchSize());
            if (CollectionUtils.isEmpty(reportList)) {
                log.debug("\u4e0a\u62a5\u8bb0\u5f55\u5df2\u5168\u90e8\u589e\u91cf\u66f4\u65b0\u5b8c\u3002smcsType:" + reportInfo.getSmcsTypeEnum().getName());
                return;
            }
            log.debug("\u672c\u6b21\u4e0a\u62a5\u7684\u8bb0\u5f55\u6570\uff1a{}\uff0c smcsType:{}", (Object)reportList.size(), (Object)reportInfo.getSmcsTypeEnum().getName());
            this.reportTwice(reportList);
        } while (++cycleIndex < 10000);
        log.error("\u672c\u6b21\u589e\u91cf\u66f4\u65b0\uff0c\u5df2\u4e0a\u62a5\u4e8610000\u6279\u6b21\u3002\u5f3a\u5236\u4e2d\u65ad\u3002smcsType:" + reportInfo.getSmcsTypeEnum().getName());
    }

    protected boolean checkReportSwitch() {
        String switchCode = this.systemConfigService.getValueByCode(this.reportInfo.getSwitchCode());
        log.debug("{}\u4e0a\u62a5\u5f00\u5173\u7684\u503c\u4e3a\uff1a{}", (Object)this.reportInfo.getSwitchCode(), (Object)switchCode);
        return "on".equals(switchCode);
    }

    public String getSmcsToken() throws Exception {
        String url = this.systemConfigService.getValueByCode("SMCS_URL") + "/api/public/login";
        String username = this.systemConfigService.getValueByCode("SMCS_USERNAME");
        String password = this.systemConfigService.getValueByCode("SMCS_PASSWORD");
        log.debug("\u83b7\u53d6token\u7684url:" + url + "username: {}, password:{}", (Object)username, (Object)password);
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json;charset=UTF-8");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("username", username);
        paramMap.put("password", password);
        String param = JSON.toJSONString(paramMap);
        String response = httpRequestUtil.post(url, param, header);
        log.debug("\u83b7\u53d6token\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a, response:{}", (Object)response);
        SmcsResult smcsResult = (SmcsResult)JSON.parseObject((String)response, SmcsResult.class);
        if ("0".equals(smcsResult.getCode())) {
            log.error("\u83b7\u53d6\u7968\u636etoken\u5931\u8d25:{}", (Object)smcsResult.getMessage());
            throw new Exception("\u83b7\u53d6\u7968\u636etoken\u5931\u8d25," + smcsResult.getMessage());
        }
        return smcsResult.getResult();
    }

    protected void reportTwice(List<T> reportList) throws Exception {
        try {
            this.reportOneBatch(reportList);
        }
        catch (Exception e) {
            log.error("\u9996\u6b21\u4e0a\u62a5\u672c\u6279\u6b21\u8bb0\u5f55\u5931\u8d25\uff0c\u5c06\u8fdb\u884c\u7b2c\u4e8c\u6b21\u4e0a\u62a5\u91cd\u8bd5\u3002\u5931\u8d25\u539f\u56e0\uff1a{}\u3002smcsType:" + this.reportInfo.getSmcsTypeEnum().getName(), (Object)e.getMessage());
            this.reportOneBatch(reportList);
        }
    }

    protected abstract List<?> formatReportList(List<T> var1) throws Exception;

    private List<Map<String, String>> formatDeleteReportList(List<T> reportList) {
        ArrayList<Map<String, String>> deleteReportList = new ArrayList<Map<String, String>>();
        if (CollectionUtils.isEmpty(reportList)) {
            return deleteReportList;
        }
        for (T reportT : reportList) {
            Map<String, String> deleteReportMap = this.formatDeleteReportMap(reportT);
            if (CollectionUtils.isEmpty(deleteReportMap)) continue;
            deleteReportList.add(deleteReportMap);
        }
        return deleteReportList;
    }

    protected abstract Map<String, String> formatDeleteReportMap(T var1);

    private void reportOneBatch(List<T> reportList) throws Exception {
        SmcsResult smcsResult;
        String response;
        HttpRequestUtil httpRequestUtil;
        HashMap<String, String> header;
        ArrayList<T> saveReportList = new ArrayList<T>();
        ArrayList<T> deleteReportList = new ArrayList<T>();
        for (T t : reportList) {
            if (this.isDeleteObject(t)) {
                deleteReportList.add(t);
                continue;
            }
            saveReportList.add(t);
        }
        String smcsToken = (String)this.cache.get((Object)"SMCS_TOKEN");
        if (!CollectionUtils.isEmpty(deleteReportList)) {
            String deleteUrl = this.systemConfigService.getValueByCode("SMCS_URL") + this.reportInfo.getDeleteUrl();
            log.debug("\u5f85\u5220\u9664\u7684\u4e0a\u62a5url:{}", (Object)deleteUrl);
            List<Map<String, String>> formatDeleteReportList = this.formatDeleteReportList(deleteReportList);
            if (!CollectionUtils.isEmpty(formatDeleteReportList)) {
                header = new HashMap<String, String>();
                header.put("token", smcsToken);
                header.put("Content-Type", "application/json;charset=UTF-8");
                httpRequestUtil = new HttpRequestUtil();
                String formatDeleteReportListJson = JSON.toJSONString(formatDeleteReportList);
                log.debug("\u5f00\u59cb\u5411\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u5f85\u5220\u9664\u7684\u8bb0\u5f55\uff1a{}", (Object)formatDeleteReportListJson);
                response = httpRequestUtil.post(deleteUrl, formatDeleteReportListJson, header);
                log.debug("\u5f85\u5220\u9664\u7684\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)response);
                smcsResult = (SmcsResult)JSON.parseObject((String)response, SmcsResult.class);
                if ("0".equals(smcsResult.getCode())) {
                    log.error("\u5f85\u5220\u9664\u7684\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u5931\u8d25:{}\u3002smcsType:" + this.reportInfo.getSmcsTypeEnum().getName(), (Object)smcsResult.getMessage());
                    throw new Exception("\u5f85\u5220\u9664\u7684\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u5931\u8d25," + smcsResult.getMessage());
                }
            }
        }
        if (!CollectionUtils.isEmpty(saveReportList)) {
            String saveUrl = this.systemConfigService.getValueByCode("SMCS_URL") + this.reportInfo.getSaveUrl();
            log.debug("\u4e0a\u62a5url:{}", (Object)saveUrl);
            List<?> formatSaveReportList = this.formatReportList(saveReportList);
            header = new HashMap();
            header.put("token", smcsToken);
            header.put("Content-Type", "application/json;charset=UTF-8");
            httpRequestUtil = new HttpRequestUtil();
            String formatSaveReportListJson = JSON.toJSONString(formatSaveReportList);
            log.debug("\u5f00\u59cb\u5411\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u5f85\u66f4\u65b0\u7684\u8bb0\u5f55\uff1a{}", (Object)formatSaveReportListJson);
            response = httpRequestUtil.post(saveUrl, formatSaveReportListJson, header);
            log.debug("\u5f85\u66f4\u65b0\u7684\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)response);
            smcsResult = (SmcsResult)JSON.parseObject((String)response, SmcsResult.class);
            if ("0".equals(smcsResult.getCode())) {
                log.error("\u5f85\u66f4\u65b0\u7684\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u5931\u8d25:{}", (Object)smcsResult.getMessage());
                throw new Exception("\u5f85\u66f4\u65b0\u7684\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u5931\u8d25," + smcsResult.getMessage());
            }
        }
        long maxUpdateTime = this.getObjectUpdateTime(reportList.get(reportList.size() - 1));
        log.debug("\u672c\u6b21\u66f4\u65b0\u8bb0\u5f55\u4e2d\u6700\u5927\u65f6\u95f4\u6233\u4e3a{}\u3002 switchCode:" + this.reportInfo.getSwitchCode(), (Object)maxUpdateTime);
        if (!StringUtils.isEmpty((CharSequence)this.reportInfo.getTimestampCode())) {
            SystemConfig systemConfig = this.systemConfigService.getByCode(this.reportInfo.getTimestampCode());
            systemConfig.setValue(Long.toString(maxUpdateTime));
            this.systemConfigService.update(systemConfig);
            log.debug("\u65f6\u95f4\u6233{}\u6570\u636e\u5e93\u6301\u4e45\u5316\u6210\u529f\uff1a{}\u3002smcsType:" + this.reportInfo.getSmcsTypeEnum().getName(), (Object)this.reportInfo.getTimestampCode(), (Object)maxUpdateTime);
        }
    }
}

