/*
 * Decompiled with CFR 0.152.
 */
package pams.function.smcs.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.smcs.bean.ReportInfo;
import pams.function.smcs.bean.SmcsTypeEnum;
import pams.function.smcs.dao.SmcsDao;
import pams.function.smcs.service.impl.SmcsAbstactReportServiceImpl;

@Service
public class SmcsDepartmentReportServiceImpl
extends SmcsAbstactReportServiceImpl<Department> {
    @Autowired
    private SmcsDao smcsDao;
    private static final Logger log = LoggerFactory.getLogger(SmcsDepartmentReportServiceImpl.class);

    @Override
    public List<Department> queryAscReportList(Long lastUpdateTime, Integer batchSize) {
        return this.smcsDao.queryAscDepartmentList(lastUpdateTime, batchSize);
    }

    @Override
    protected long getObjectUpdateTime(Department department) {
        return department.getTimestamp();
    }

    @Override
    protected List<Map<String, String>> formatReportList(List<Department> reportList) throws Exception {
        ArrayList<Map<String, String>> formatList = new ArrayList<Map<String, String>>();
        for (Department department : reportList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("orgId", new String(department.getId()));
            map.put("orgName", department.getName());
            if (department.getParentDep() != null) {
                map.put("parentOrgId", new String(department.getParentDep().getId()));
            }
            Date date = new Date(department.getTimestamp());
            map.put("updateTime", Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)date));
            map.put("createTime", Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)date));
            map.put("time", Util.getDate((String)"yyyy-MM-dd HH:mm:ss"));
            String area = "";
            String code = "";
            if (department.getCode() != null && department.getCode().length() >= 4) {
                area = department.getCode().substring(0, 4);
            }
            map.put("area", area);
            map.put("code", department.getCode());
            formatList.add(map);
        }
        return formatList;
    }

    @Override
    protected Map<String, String> formatDeleteReportMap(Department reportDepartment) {
        if (reportDepartment == null || StringUtils.isBlank((CharSequence)reportDepartment.getId())) {
            return null;
        }
        HashMap<String, String> deleteReportMap = new HashMap<String, String>();
        deleteReportMap.put("orgId", new String(reportDepartment.getId()));
        return deleteReportMap;
    }

    @Override
    protected boolean isDeleteObject(Department department) {
        return "1".equals(department.getFlag());
    }

    @Override
    public void doReport() throws Exception {
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setSwitchCode("SMCS_DEPARTMENT_PERSON_SWITCH");
        reportInfo.setTimestampCode("SMCS_DEPARTMENT_TIMESTAMP");
        reportInfo.setSaveUrl("/api/public/person/org/save");
        reportInfo.setDeleteUrl("/api/public/person/org/delete");
        reportInfo.setSmcsTypeEnum(SmcsTypeEnum.smcsDepartment);
        log.debug("\u589e\u91cf\u5411\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u90e8\u95e8\u7ebf\u7a0b\u5f00\u59cb\u3002reportInfo:{}", (Object)JSON.toJSONString((Object)reportInfo));
        super.doReport(reportInfo);
    }
}

