/*
 * Decompiled with CFR 0.152.
 */
package pams.function.uniteauth.Util;

import com.xdja.cssp.sm2cipher.sm2.cipher.Base64Util;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM2CipherImpl;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM2Utils {
    public static byte[] encrypt(ECPublicKey publicKey, byte[] plainText) {
        if (publicKey == null || plainText == null || plainText.length <= 0) {
            throw new IllegalArgumentException("param error: publicKey,plainText can not be null");
        }
        byte[] cipherText = null;
        byte[] pubkeydata = new byte[65];
        pubkeydata[0] = 4;
        byte[] xbyte = publicKey.getW().getAffineX().toByteArray();
        byte[] ybyte = publicKey.getW().getAffineY().toByteArray();
        System.arraycopy(xbyte, xbyte.length > 32 ? 1 : 0, pubkeydata, 1, 32);
        System.arraycopy(ybyte, ybyte.length > 32 ? 1 : 0, pubkeydata, 33, 32);
        SM2CipherImpl cipher = new SM2CipherImpl();
        String base64key = new String(Base64Util.encode((byte[])pubkeydata));
        cipherText = cipher.encrypt_gb(base64key, plainText);
        return cipherText;
    }

    public static byte[] encrypt(X509Certificate certificate, byte[] plainText) {
        if (certificate == null || plainText == null || plainText.length <= 0) {
            throw new IllegalArgumentException("param error: certificate,plainText can not be null");
        }
        byte[] cipherText = null;
        byte[] pubkeydata = new byte[65];
        ECPublicKey publicKey = (ECPublicKey)certificate.getPublicKey();
        pubkeydata[0] = 4;
        byte[] xbyte = publicKey.getW().getAffineX().toByteArray();
        byte[] ybyte = publicKey.getW().getAffineY().toByteArray();
        System.arraycopy(xbyte, xbyte.length > 32 ? 1 : 0, pubkeydata, 1, 32);
        System.arraycopy(ybyte, ybyte.length > 32 ? 1 : 0, pubkeydata, 33, 32);
        SM2CipherImpl cipher = new SM2CipherImpl();
        String base64key = new String(Base64Util.encode((byte[])pubkeydata));
        cipherText = cipher.encrypt_gb(base64key, plainText);
        return cipherText;
    }

    public static byte[] decrypt(ECPrivateKey privateKey, byte[] cipherText) {
        byte[] temp;
        if (privateKey == null || cipherText == null || cipherText.length <= 0) {
            throw new IllegalArgumentException("param error: privateKey,cipherText can not be null");
        }
        byte[] plainText = null;
        byte[] prikeydata = new byte[32];
        System.arraycopy(temp, (temp = privateKey.getS().toByteArray()).length > 32 ? 1 : 0, prikeydata, 0, 32);
        SM2CipherImpl cipher = new SM2CipherImpl();
        String base64key = new String(Base64Util.encode((byte[])prikeydata));
        plainText = cipher.decrypt_gb(base64key, cipherText);
        return plainText;
    }

    public static byte[] sign(ECPrivateKey privateKey, byte[] original) throws IllegalArgumentException {
        if (privateKey == null || original == null || original.length <= 0) {
            throw new IllegalArgumentException("param error: privateKey,original can not be null");
        }
        SM2CipherImpl cipher = new SM2CipherImpl();
        byte[] signData = cipher.sign(privateKey, original);
        return signData;
    }

    public static boolean verify(ECPublicKey publicKey, byte[] sign, byte[] original) throws IllegalArgumentException {
        if (publicKey == null || original == null || sign == null || original.length <= 0 || sign.length <= 0) {
            throw new IllegalArgumentException("param error: publicKey,sign,original can not be null");
        }
        boolean flag = false;
        SM2CipherImpl cipher = new SM2CipherImpl();
        flag = cipher.verify(publicKey, sign, original);
        return flag;
    }

    public static boolean verify(X509Certificate certificate, byte[] sign, byte[] original) throws IllegalArgumentException {
        if (certificate == null || original == null || sign == null || original.length <= 0 || sign.length <= 0) {
            throw new IllegalArgumentException("param error: certificate,sign,original can not be null");
        }
        boolean flag = false;
        SM2CipherImpl cipher = new SM2CipherImpl();
        flag = cipher.verify((ECPublicKey)certificate.getPublicKey(), sign, original);
        return flag;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

