/*!
 * @Descript	: dialog 网页弹出框
 * @Author		:  wangjia
 * @Depend		: jquery.js(1.7 or later)
 */
$.cpb_dialog={
    open:function(options){
        var _this=this;
        var $dia_con;
        var $layOut;
        var $dia=$("#cpbDialog");
        //如果页面上面已经有了可以不用再创建
        if(!$dia.length){
            $dia=createTemplate();
        }
        //弹出框的配置
        var setting= $.extend({
            width   :380,                        //弹出框宽度(px)
            height  :190,                       //弹出框高度（px）
            resize  :false,                       //是否可以由用户改变大小
            isDrag  :true,                       //是否可以拖动
            bgColor :"#000",                       //背景颜色
            opacity :0.3,                       //背景遮罩层的透明度
            src     :""
        },options);
        $dia.css({"height":setting.height,"width":setting.width});
        setCenter();
        $(window).resize(setCenter);
        $layOut=$("#cpbLayOut");
        $layOut.css({background:setting.bgColor,opacity:setting.opacity});
        return $dia;

        //初始化弹出框
        function createTemplate(){
            //弹出框的模版html
            var template='<div id="cpbLayOut"></div>'
                +'<div id="cpbDialog"><img src="../../css/themes/default/system/images/demo.jpg" width="380" height="190" />'
                +'</div>';
            $("body").append(template);
            return $("#cpbDialog");
        }
        //浏览器改变大小弹出框还是居中显示
        function setCenter(){
            var getScrollTop=function (){
                var scrollPos;
                if (window.pageYOffset) {
                    scrollPos = window.pageYOffset; }
                else if (document.compatMode && document.compatMode != 'BackCompat')
                { scrollPos = document.documentElement.scrollTop; }
                else if (document.body) { scrollPos = document.body.scrollTop; }
                return scrollPos;
            };
            var sctop=getScrollTop();
            var bw=document.documentElement.clientWidth; //这个获取的是浏览器的可用宽度，如果弹出框是要求在框架里面的居中那就得换body了
            var bh=document.documentElement.clientHeight;
            if(bh==0){
                bw=document.body.clientWidth;
                bh=document.body.clientHeight;
            }
            var dialog_h =  $dia.height();         //弹出框的高度已经改变，需要重新获取高度

//            var p_top = (bh-setting.height)/2 -13;  //顶部不能超出窗体 默认10px 距离  因顶部面包屑有26px,从视觉上弹出框未居中,特此减少13px;   modify by: Jay
            var p_top = (bh-dialog_h)/2 -13;  //顶部不能超出窗体 默认10px 距离  因顶部面包屑有26px,从视觉上弹出框未居中,特此减少13px;   modify by: Jay
            var p_left = (bw-setting.width)/2;
            if(parseInt(p_top) < 10){
                p_top = 10;
            }
            if(parseInt(p_left) < 5){
                p_left = 5;
            }
//            $dia.css({"height":setting.height,"width":setting.width,"left":p_left,top:p_top});    档窗体重设时，不改变弹出框的宽度和高度（如果改变高度，影响基本规则页面的弹出框）
            if(setting.type=="iframe"){
                $dia.css({"left":p_left,top:p_top+sctop});
                $("#cpbLayOut").css({top:sctop});
            }else{
                $dia.css({"position":"fixed","z-index":9999,"left":p_left,top:p_top});
                $("#cpbLayOut").css({"position":"fixed","z-index":9998,"width":"100%","height":"100%","top":0});
            }
        }
        function close(){
            _this.close(setting);
        }
    },
    show:function(){
        $("#cpbDialog").show();
    }
};





