/*
 * @Descript	: dialog 网页弹出框
 * @Depend		: jquery.js(1.7 or later)
 */
$.my_dialog={
    open:function(options){
        var _this=this;
        var $dia_con;
        var $layOut;
        var $dia=$("#cpbDialog");
        //如果页面上面已经有了可以不用再创建
        if(!$dia.length){
            $dia=createTemplate();
        }
        //如果传递进来的是字符串，默认为alert，的message
        if(typeof options=="string"){
            options={
                message:options
            }
        }
        //弹出框的配置
        var setting= $.extend({
            type       :"alert",                  //弹出框类型（alert,confirm,iframe ,ing）默认为alert
            title      :"详情",                   //弹出框标题
            message    :"",                       //弹出框正文
            width      :680,                      //弹出框宽度(px)
            height     :450,                      //弹出框高度（px）
            url        :"",                       //如果是iframe弹出框，url为页面地址,其他弹出框此设置无效
            resize     :false,                    //是否可以由用户改变大小
            //isDrag   :true,                     //是否可以拖动
            bgColor    :"#000",                   //背景颜色
            opacity    :0.5,                      //背景遮罩层的透明度
            zIndex     :999,                      //弹出框的z-index属性
            modal      :true                      //是否为模态弹出框
        },options);
        $dia.css({"height":setting.height,"width":setting.width});
        setCenter();
        $(window).resize(setCenter);
        $dia.find(".cpbDialog_top_title").html(setting.title);
        $dia_con=$dia.find(".cpbDialog_con");
        $layOut=$("#cpbLayOut");
        $layOut.css({background:setting.bgColor,opacity:setting.opacity});
        $dia_con.html('<p class="cpbDialog_con_message"></p>')
            .find(".cpbDialog_con_message").css({"width":setting.width-40,height:setting.height-59-37}).html(setting.message);
        //这里相当于对弹出框初始化一次，因为之前的动画或操作可能影响弹出框的初始化值
        $dia.css({opacity:1}).find(".cpbDialog_top_close").show();
        $("html").css("overflow","hidden");

        $dia.find(".cpbDialog_top_close").click(close);

        //如果为模态弹出框则显示遮罩层
        if(setting.modal){
            $layOut.show();
        }else{
            $layOut.hide();
        }
        //弹出框出现的动画效果
        switch (setting.showEffect){
            case "fadeIn":
                $dia.fadeIn();
                break;
            case "fadeInDown":
                $dia.css({top:$dia.css("top").replace("px","")-20,opacity:0}).show().animate({top:"+=20",opacity:1},400);
                break;
            case "fadeInLeft":
                $dia.css({left:$dia.css("left").replace("px","")-20,opacity:0}).show().animate({left:"+=20",opacity:1},400);
                break;
            default :
                $dia.show();
                break;
        }
        return $dia;


        //初始化弹出框
        function createTemplate(){
            //弹出框的模版html
            var template='<div id="cpbLayOut"></div>'
                +'<div id="cpbDialog">'
                +'<div id="cpbDialog_top" class="cpbDialog_top">'
                +'<button class="cpbDialog_top_close" title="关闭弹出窗口">关闭</button>'
                +'<strong class="cpbDialog_top_title">提示</strong>'
                +'</div>'
                +'<div class="cpbDialog_con">'
//                +'<p class="cpbDialog_con_message"></p>'
                +'</div>'
                +'</div>';
            $("body").append(template);
            return $("#cpbDialog");

        }
        //浏览器改变大小弹出框还是居中显示
        function setCenter(){
            var getScrollTop=function (){
                var scrollPos;
                if (window.pageYOffset) {
                    scrollPos = window.pageYOffset; }
                else if (document.compatMode && document.compatMode != 'BackCompat')
                { scrollPos = document.documentElement.scrollTop; }
                else if (document.body) { scrollPos = document.body.scrollTop; }
                return scrollPos;
            };
            var sctop=getScrollTop();
            var bw=document.documentElement.clientWidth; //这个获取的是浏览器的可用宽度，如果弹出框是要求在框架里面的居中那就得换body了
            var bh=document.documentElement.clientHeight;
            if(bh==0){
                bw=document.body.clientWidth;
                bh=document.body.clientHeight;
            }
            var dialog_h =  $dia.height();         //弹出框的高度已经改变，需要重新获取高度

//            var p_top = (bh-setting.height)/2 -13;  //顶部不能超出窗体 默认10px 距离  因顶部面包屑有26px,从视觉上弹出框未居中,特此减少13px;   modify by: Jay
            var p_top = (bh-dialog_h)/2 -13;  //顶部不能超出窗体 默认10px 距离  因顶部面包屑有26px,从视觉上弹出框未居中,特此减少13px;   modify by: Jay
            var p_left = (bw-setting.width)/2;
            if(parseInt(p_top) < 10){
                p_top = 10;
            }
            if(parseInt(p_left) < 5){
                p_left = 5;
            }
//            $dia.css({"height":setting.height,"width":setting.width,"left":p_left,top:p_top});    档窗体重设时，不改变弹出框的宽度和高度（如果改变高度，影响基本规则页面的弹出框）
            if(setting.type=="iframe"){
                $dia.css({"left":p_left,top:p_top+sctop});
                $("#cpbLayOut").css({top:sctop});
            }else{
                $dia.css({"position":"fixed","left":p_left,top:p_top});
                $("#cpbLayOut").css({"position":"fixed"});
            }

        }
        function close(){
            _this.close(setting);
            $("html").css("overflow","auto");
        }
    },
    //当是为iframe弹框的时候这个方法是有必要的
    close:function(option){
        //提示是否关闭窗体  modify by:Jay
        if($(".cpbDialog_top_close").attr('pop_msg') != undefined){
            parent.$.my_dialog.open({
                type:"confirm",
                message:"修改信息未保存，是否继续退出？",
                callback:function(){
                    $(".cpbDialog_top_close").removeAttr("pop_msg");
                    $.my_dialog.close();
                    parent.$.my_dialog.close();
                },
                cancel_callback:function(){
                    parent.$.my_dialog.close();
                    $.my_dialog.show();
                }
            });
            return;
        }

        var setting= $.extend({
            closeEffect:null,
            callback:null
        },option);
        var $dia=$("#cpbDialog");
        //弹出框出现的动画效果
        $dia.hide();
//        $dia.remove();//再考虑考虑？是否每次完了后移除掉
        $("#cpbLayOut").hide();
    },
    //用于提交失败后可回到提交之前的窗体 modify by: Jay
    show:function(){
        $("#cpbDialog").show();
    }
};

(function(){
    loadcss("../plugin/dialog2/dialog.css");
    function loadcss(url){
        var head = document.getElementsByTagName('HEAD')[0];
        var style = document.createElement('link');
        style.href = url;
        style.rel = 'stylesheet';
        style.type = 'text/css';
        head.appendChild(style);
    }
})();






