/**
 * User: wangjia
 */

$.cpb_messageBox={
    //显示messageBox提示框
    /**
     * @content  String 要显示的内容，可以是html标记
     * @dir String 窗口箭头显示的方向，up和down
     * @width Number 窗口内容的宽度
     * @height Number 窗口内容的高度
     * @dis Number 窗口箭头离左边的距离
     * @theme String 窗口主题
     */
    show:function(set){
        var def={
            t:this,
            content:"",
            dir:"up",
            width:"auto",
            height:"auto",
            dis:0,
            top:0,
            left:0,
            theme:"white"
        };
        var setting= $.extend(def,set);
        var pos=getObjPos(setting.t);
        var strStyle='';
        switch (setting.dir){
            case "up":
                pos.y-=17+setting.height;
                strStyle="left:"+setting.dis+"px";
                break;
            case "down":
                strStyle="left:"+setting.dis+"px";
                pos.y+=17+$(setting.t).height();
                break;
            case "left":
                pos.x-=17+setting.width;
                strStyle="top:"+setting.dis+"px";
                break;
            case "right":
                pos.x+=17+$(setting.t).width();
                strStyle="top:"+setting.dis+"px";
                break;
            default :
                break;
        }
        var theme=setting.theme;
        if(theme=="white"){
            theme="messageBox"
        }else if(theme=="yellow"){
            theme="yellow";
        }
        var str='<div class='+theme+' style="width:'+setting.width+'px;height:'+setting.height+'px;">'
            +'<span class="_h1"></span>'
            +'<span class="_h2"></span>'
            +'<span class="_h3"></span>'
            +'<span class="_h4"></span>'
            +'<span class="_k1"></span>'
            +'<span class="_k2"></span>'
            +'<span class="_k3"></span>'
            +'<span class="_k4"></span>'
            +'<span style="'+strStyle+'" class=_'+setting.dir+'></span>'
            +'<div class="_con"></div>'
            +'</div>';
        $(".window").append("<div class='message'></div>");
        $(".message").fadeIn().html(str).css({
            "width":setting.width,
            "height":setting.height,
            "left":setting.left,
            "top":setting.top,
            "position":"absolute",
            "z-index":"9999"
        }).find('._con').html(setting.content);
        $.cpb_messageBox.pos=pos;
        //获取页面中一个控件的坐标
        function getObjPos(ATarget){
            var target = ATarget;
            var pos = {x:target.offsetLeft, y:target.offsetTop};
            target = target.offsetParent;
            while (target)
            {
                pos.x += target.offsetLeft;
                pos.y += target.offsetTop;

                target = target.offsetParent
            }
            return pos;
        }
    },
    hide:function(){
        $(".message").fadeOut().remove();
    }
    ,pos:{x:0,y:0}
};
(function(){
    loadcss("../../plugin/message/message.css");
    function loadcss(url){
        var head = document.getElementsByTagName('HEAD')[0];
        var style = document.createElement('link');
        style.href = url;
        style.rel = 'stylesheet';
        style.type = 'text/css';
        head.appendChild(style);
    }
})();