$(function () {
    var cardCtrlErr = {
        0 : "请安装驱动",
        3 : "请升级驱动",
        4 : "请升级驱动",
        5 : "请重新安装驱动",
        6 : "驱动不支持的系统类型", // ，请使用Windows操作系统
        7 : "驱动不支持的CPU",
        8 : "不支持当前浏览器", //，建议使用IE、火狐浏览器登录
        9 : "不支持当前浏览器",
        10 : "不支持当前浏览器"
    };
    var dllType = "-1";
    var isFunc = function(func) {
        return func && typeof func === "function";
    };
    var cardTypeTrans = function(cardType) {
        switch (cardType){
            case "1": return "2";
            case "0": return "3";
            case "3": return "6";
            case "2": return "4";
        }
    };
    // 加载控件
    var loadPlugin_ = function (callBack, dllNeedInit) {
        $.winmask.show("加载控件中");
        Card.ready(function(pdata){
            $.winmask.hide();
            if (!pdata.success) {
                if (isFunc(callBack)) callBack({flag: false});
                $.messager.alert("提示",cardCtrlErr[pdata.code]);
            } else{
                var that_ = this;

                var dll_chose_val = $(":radio:checked").val();
                if (dllNeedInit && dll_chose_val && dll_chose_val !== '-1') {
                    // 加载第三方驱动
                    that_.dllInit(dll_chose_val, function () {
                        dllType = $(":radio:checked").data("type");
                        if (isFunc(callBack)) callBack({flag: true, plugin: that_});
                    });
                } else{
                    if (isFunc(callBack)) callBack({flag: true, plugin: that_});
                }
            }
        });
    };

    // 读取管理卡
    var readAdminCard_ = function (plugin, callBack) {
        $.winmask.show("开始读取管理key……");
        plugin.readAdminCard(function(data){
            $.winmask.hide();
            if (isFunc(callBack)){
                callBack(data && data.length && data.length === 1);
            }
        });
    };
    // 读取用户key
    var readUserCard_ = function (plugIn, cardType, callBack) {
        $.winmask.show("开始读取用户卡……");
        var isDistinguishCardType = $('#isDistinguishCardType').val();
        var getCardInfo = function(card) {
            card.getCardInfo(function(cardInfo){
                if (!cardInfo.success) {
                    $.messager.alert("错误","读取卡信息异常");
                } else if(cardType != -1) {
                    var cardTypeRead = cardTypeTrans(cardInfo.type);
                    if(isDistinguishCardType !=-1 && isDistinguishCardType.indexOf(cardTypeRead)<0){
                        if(cardTypeRead !== cardType){
                            $.messager.alert("提示", "插入的卡类型和选择的卡类型不一致");
                            return;
                        }
                    }
                }
                if(isFunc(callBack)) callBack(card);
            });
        };

        var readCallBack = function (data) {
            $.winmask.hide();
            if (!data.length) {
                $.messager.alert("提示","没有读取到用户卡");
            } else{
                if (data.length > 1) {
                    // 返回多张卡
                    $.messager.alert("提示","请插入一张用户卡");
                } else if (data.length === 1) {
                    // 获取到一张卡信息
                    getCardInfo(data[0]);
                } else{
                    // 没有获取到卡信息
                    $.messager.alert("提示","没有读取到用户卡");
                }
            }
        };
        plugIn.readUserCard(readCallBack);
        // switch (cardType){
        //     case "2":
        //     plugIn.readUserUSBKeyCard(readCallBack);
        //     break;
        //     case "3":
        //         plugIn.readUserTFCard(readCallBack);
        //         break;
        //     case "6":
        //         plugIn.readUserTMCard(readCallBack);
        //         break;
        //     case "4":
        //         plugIn.readUserACE(readCallBack);
        //         break;
        //     case "-1":
        //         plugIn.readUserCard(readCallBack);
        //         break;
        // }
    };
    // 检查pin码
    var checkPin_ = function (card, pin, callBack) {
        $.winmask.show("开始检查pin码……");
        card.checkPin(pin, function (data) {
            $.winmask.hide();
            if (!data.success) {
                this.getPinTryCount(function (tryData) {
                    if (tryData.success){
                        $.messager.alert("错误", "安全口令错误, 还有" + tryData.code + "次机会");
                    } else{
                        $.messager.alert("错误", "安全口令错误");
                    }
                });
                return;
            }
            if (data.isLock) {
                $.messager.alert("错误", "卡已经锁定");
                return;
            }
            if (isFunc(callBack)) callBack(data.success && !data.isLock);
        });
    };
    // 写用户信息
    var writeUserInfo_ = function (card, personInfo, callBack) {
        $.winmask.show("开始写入人员信息……");
        card.writeFileToCard(personInfo, function (data) {
            $.winmask.hide();
            if (isFunc(callBack)) callBack(data.success);
        });
    };
    // 生成密钥对
    var getPubKey_ = function (card, pin, alg, ctnId, usage, callBack) {
        $.winmask.show("开始生成秘钥对……");
        var b = function(data) {
            $.winmask.hide();
            if (!data.success) {
                $.messager.alert("错误", data.message);
            } else {
                if (isFunc(callBack)) callBack(data.publicKey);
            }
        };
        if (alg === '1.0' || alg === '1') {
            // rsa
            if (dllType === "1") {
                card.genKeypairExRSA(pin, ctnId, usage, b);
            } else{
                card.genKeypairRSA(pin, ctnId, usage, b);
            }
        } else if(alg === '2.0' || alg === '2') {
            // sm2
            if (dllType === "1") {
                card.genKeypairExSM2(pin, ctnId, usage, b);
            } else {
                card.genKeypairSM2(pin, ctnId, usage, b);
            }
        }
    };
    // 获取p10
    var getP10_ = function (card, pin, alg, ctnId, dn, callBack) {
        $.winmask.show("开始生成p10……");
        var b = function(data) {
            $.winmask.hide();
            if (!data.success) {
                $.messager.alert("错误", data.message);
            } else {
                if (isFunc(callBack)) callBack(data.p10);
            }
        };
        if (alg === '1.0' || alg === '1') {
            // rsa
            card.getGenP10ReqRsa(pin, ctnId, dn, b);
        } else if(alg === '2.0' || alg === '2') {
            // sm2
            card.getGenP10ReqSM2(pin, ctnId, dn, b);
        }
    };
    // 写证书，一起写
    var writeCertTogether_ = function (card, pin, ctnId, alg, type, certs, callBack) {
        $.winmask.show("开始写入双证……");
        card.writeDoubleCertEx(pin, alg === "1" || alg === "1.0" ? 0 : 1, ctnId, type, certs, function(data){
            $.winmask.hide();
            if (!data.success) {
                if (isFunc(callBack)) callBack(false);
            } else {
                if (isFunc(callBack)) callBack(true);
            }
        });
    };
    // 写证书，分开写
    var writeCertPart_ = function (card, pin, ctnId, certArr, callBack) {
        $.winmask.show("开始写入证书……");
        var arr = [];
        if (typeof certArr !== "object") {
            if (typeof certArr === "string") {
                arr = certArr.split("#");
            }
        } else{
            arr = certArr;
        }
        // certusage 在为单证时，作为交换证书。
        card.writeCert(pin, ctnId, arr.length === 1 ? 0 : 1, arr[0], function(data){
            $.winmask.hide();
            if (data.success) {
                if (arr.length === 2) {
                    $.winmask.show("开始写入证书……");
                    card.writeCert(pin, ctnId, 0, arr[1], function(data2){
                        $.winmask.hide();
                        if (data2.success) {
                            if (isFunc(callBack)) callBack(true);
                        } else{
                            if (isFunc(callBack)) callBack(false);
                        }
                    });
                } else{
                    if (isFunc(callBack)) callBack(true);
                }
            } else{
                if (isFunc(callBack)) callBack(false);
            }
        });
    };
    // 写入项目标签
    var writeProTag_ = function(card, tagStr, callback){
        $.winmask.show("开始写入项目标签……");
        if(!tagStr) {
            // 没有配置项目标签, 默认不写项目标签
            callback(true);
        } else{
            card.WriteProTag(tagStr, function(data){
                $.winmask.hide();
                if (data.success) {
                    if (isFunc(callback)) callback(true);
                } else{
                    $.messager.alert("错误", data.message, "error");
                }
            });
        }
    };

    var getCert_ = function(card, ctnId, callback) {
        $.winmask.show("开始获取证书……");
        card.getCert(ctnId, function (data) {
            if (data.success) {
                $.winmask.hide();
                if (isFunc(callback)) callback(data.cert);
            } else{
                $.messager.alert("错误", data.message, "error");
                $.winmask.hide();
            }
        });
    };
    $.extend({
        loadPlugin_:            loadPlugin_,
        readAdminCard_:         readAdminCard_,
        readUserCard_:          readUserCard_,
        checkPin_:              checkPin_,
        writeUserInfo_:         writeUserInfo_,
        getPubKey_:             getPubKey_,
        getP10_:                getP10_,
        writeCertTogether_:     writeCertTogether_,
        writeCertPart_:         writeCertPart_,
        writeProTag_:           writeProTag_,
        getCert_:               getCert_
    });
});