;$(function () {

    var personId;
    var keyId;
    var cardPwd;
    var proTag;

    // 加载控件
    var loadComActiveX = function () {
        $.loadPlugin_(function(data){
            if (data.flag) {
                $("#div_writeCardDriver_install").hide();
                $("#div_user_info_box, #write_card_btn").show();
            } else{
                $.messager.alert("提示",'没有安装写卡控件，请下载安装后再试。');
                $("#div_writeCardDriver_install").show();
                $("#div_user_info_box, #write_card_btn").hide();
            }
        });
    };

    // 开始写卡
    var mdpWriteCard = function(personIdIn, keyIdIn) {
        if (!personIdIn) {
            $.messager.alert('提示', "人员id异常");
            return false;
        }
        personId = personIdIn;
        keyId = keyIdIn;
        // 校验卡密码
        cardPwd = $("#card_pwd_ipt").val();
        if (!cardPwd){
            $.messager.alert('提示', "请输入卡密码");
            return false;
        }
        $.loadPlugin_(loadPlugin_back);
    };

    var loadPlugin_back = function(data) {
        if (data.flag) {
            $.readAdminCard_(data.plugin, function (isHas) {
                if (!isHas) {
                    $.messager.alert('提示',
                        "请插入且插入一个管理key","error");
                } else{
                    // 读取用户key
                    $.readUserCard_(data.plugin, "2", readUserKey_back);
                }
            });
        } else{
            $.messager.alert('提示', "读取控件失败， 请重新安装控件","error");
        }
    };

    var readUserKey_back = function (card) {
        // 检查pin码
        $.checkPin_(card, $("#card_pwd_ipt").val(), function(isPass) {
            if (isPass) {
                afterCheckPinPass(card);
            }
        });
    };


    var afterCheckPinPass = function(card) {
        if (checkUserKeyRemote(card.getCardId())) {
            // 开始写入项目标签
            $.writeProTag_(card, proTag, function(data){
                if (!data) {
                    $.messager.alert('提示', "写入项目标签失败","error");
                } else{
                    $.getPubKey_(card, $("#card_pwd_ipt").val(), "1", 0, function(pubKey){
                        if (pubKey) {
                            // 获取到公钥，开始走下载证书流程
                            downloadCert(card, pubKey);
                        }
                    });
                }
            });

        }
    };



    // 校验是否可以写卡
    var checkUserKeyRemote = function(cardId) {
        var isValidKey = false;
        $.ajax({
            url: "/pams/sso/mdpusermanagercontroller/checkcard.do",
            type: "POST",
            data: {personId: personId, cardId: cardId, keyId: keyId},
            async: false,
            dataType: "json",
            success: function(r) {
                if (r.success) {
                    isValidKey = true;
                    proTag = r.proTag;
                } else{
                    $.winmask.hide("[错误]" + r.msg);
                }
            },
            error: function() {
                $.winmask.hide("检查key异常！");
            }
        });
        return isValidKey;
    };


    var downloadCert = function(card, pubKey) {
        var cert = "";
        $.ajax({
            url: "/pams/sso/mdpusermanagercontroller/downloadcert.do",
            type: "POST",
            data: {personId: personId, cardId: card.getCardId(), keyId: keyId, pubKey: pubKey},
            dataType: "json",
            async: false,
            success: function(r) {
                if (r.success) {
                    cert = r.cert;
                    keyId = r.keyId;
                    writeCard(card, cert);
                } else{
                    $.winmask.hide(r.msg);
                }
            },
            error: function() {
                $.winmask.hide("下载证书网络异常");
            }
        });
        return cert;
    };

    var writeCard = function (card, cert) {
        if (cert) {
            $.writeCertPart_(card, $("#card_pwd_ipt").val(), 0, cert, function(flag) {
                if (!flag) {
                    mdpRevokeCert(personId, keyId)
                } else{
                    $.winmask.hide("写卡成功");
                    $('#win_userInfo').dialog('close');
                    $("#cardInfo_searchList").datagrid("load");
                }
            });
        }
    };



    // 撤销操作
    var mdpRevokeCert = function(personIdIn, keyIdIn){
        $.ajax({
            url: "/pams/sso/mdpusermanagercontroller/revoke.do",
            type: "POST",
            data: {personId: personIdIn, keyId: keyIdIn},
            dataType: "json",
            success: function(r) {
                if (r.success) {
                    $.messager.alert("提示",'证书已经撤销');
                    $('#win_userInfo').dialog('close');
                    $("#cardInfo_searchList").datagrid("load");
                } else{
                    $.messager.alert("提示",'证书撤销失败: ' + r.msg);
                }
            },
            error: function(){
                $.messager.alert("提示",'撤销证书网络异常');
            }
        });
    };
    $.extend({
        loadComActiveX: loadComActiveX,
        mdpWriteCard: mdpWriteCard,
        mdpRevokeCert: mdpRevokeCert
    });

});