$(function () {

    var dsFiledName = [
        {
            key:"dsType",
            name:"数据库类型",
            type: "option",
            options:{"0":"Oracle", "1":"SQLServer","2":"MySql","3":"Oracle集群","4":"非数据库"},
            format: function (val) {
                if (val === 0) return "Oracle";
                if (val === 1) return "SQLServer";
                if (val === 2) return "MySql";
                if (val === 3) return "Oracle集群";
                if (val === 4) return "非数据库";
                return "";
            }
        },{
            key:"dsName",
            name:"数据源名称",
            type: "string"
        },{
            key:"url",
            name:"数据源连接url",
            type: "string"
        },{
            key:"username",
            name:"数据源用户名",
            type: "string"
        },{
            key:"password",
            name:"数据源连接密码",
            type: "string"
        },{
            key:"protocol",
            name:"协议",
            type: "option",
            format: function (val) {
                if (val == "1") return "HttpRestful";
                if (val == "2") return "WebService";
                return "";
            }
        },{
            key:"traffSeqNum",
            name:"交管序列号",
            type: "string"
        },{
            key:"requestId",
            name:"请求方id",
            type: "string"
        },{
            key:"inputType",
            name:"审核方式",
            type: "option",
            format: function (val) {
                if (val == "0") return "录入未审核";
                if (val == "1") return "录入已审核";
                if (val == "2") return "本地审核外地未审核";
                if (val == "3") return "本地未审核外地审核";
                return "";
            }
        }
    ];

    var colFiledInfo = [
        {
            key:"fieldEnName",
            name:"字段名",
            type: "string"
        },
        {
            key:"fieldCnName",
            name:"描述",
            type: "string"
        },
        {
            key:"fieldType",
            name:"数据类型",
            type: "string"
        },
        {
            key:"conditions",
            name:"支持查询条件",
            type: "option",
            options:{
                "0":"不支持",
                "1":"等于",
                "2":"不等于",
                "3":"大于",
                "4":"小于",
                "5":"大于等于",
                "6":"小于等于",
                "7":"模糊查询",
                "8":"模糊查询取反",
                "9":"多值查询",
                "10":"多值查询取反",
                "11":"多条件组合",
                "12":"多条件满足一个"
            },
            format: function (val) {
                val = val.toString();
                var arr = val.split(',');
                var r = "";
                for (var i = 0; i < arr.length; i++) {
                    r += (this.options[arr[i]] || "")  + '<br/>';
                }
                return r;
            }
        },
        {
            key:"sort",
            name:"排序",
            type: "option",
            options:{
                "0":"不支持排序",
                "1":"升序",
                "2":"降序"
            },
            format: function (val) {
                val = val.toString();
                var arr = val.split(',');
                var r = "";
                for (var i = 0; i < arr.length; i++) {
                    r += (this.options[arr[i]] || "")  + '<br/>';
                }
                return r;
            }
        }
    ];

    var resFiledInfo = [
        {
            key:"dataObjId",
            name:"表名",
            type:"string"
        }, {
            key:"desc",
            name:"描述",
            type:"string"
        },{
            key:"owner",
            name:"拥有者",
            type:"string"
        },
        {
            key:"supportOpType",
            name:"支持操作类型",
            type:"option",
            options:{"0":"禁用", "3":"插入", "5":"删除", "4":"更新", "2":"查询"},
            format: function (val) {
                val = val.toString();
                var arr = val.split(',');
                var r = "";
                for (var i = 0; i < arr.length; i++) {
                    r += (this.options[arr[i]] || "")  + " ";
                }
                return r;
            }
        },{
            key:"handler",
            name:"操作类",
            type:"option",
            options:{"1":"版本1", "2":"版本2"},
            format: function (val) {
                var arr = val.split(',');
                var r = "";
                for (var i = 0; i < arr.length; i++) {
                    r += (this.options[arr[i]] || "")  + " ";
                }
                return r;
            }
        },{
            key:"dataObjNo",
            name:"数据对象编号",
            type:"string"
        },{
            key:"servicesId",
            name:"服务方ID",
            type:"string"
        },{
            key:"serviceCode",
            name:"业务代码",
            type:"string"
        },{
            key:"authorizeCode",
            name:"授权编号",
            type:"string"
        },
        {
            key:"nPage",
            name:"支持分页",
            type:"option",
            format: function (val) {
                if (val === 1) {
                    return "支持";
                } else if (val === 0){
                    return "不支持";
                }
                return "";
            }
        }
    ];
    var resolveFiledName = function (info, key) {
        if (window.console){
            // console.info("==字段:" + key);
        }
        var name = "";
        $.each(info, function (i, v) {
            if (key === v.key) {
                name = v.name;
            }
        });
        return name;
    };
    var resolveFiledValue = function (info, key, val) {
        var result = "";
        $.each(info, function (i, v) {
            if (key === v.key) {
                if (v.type === "string") {
                    result = (val === "null" || val === "undefined") ? "" : (val||"");
                }
                if (v.type === "option") {
                    result = v.format(val);
                }
            }
        });
        return result;
    };
    var loadDataSource = function (ds) {
        var i = 1;
        var tr = $("<tr></tr>");
        var arr = [];
        // url可能会比较长，为避免页面错乱，进行特殊处理，数据源地址单独一行
        var url = ds.url;
        tr.append('<td class="info_label" align="right">数据源地址:</td>' +
            '<td align="left" colspan="5">'+ url+'</td>');
        $("#res_info_target").before(tr);
        tr = $("<tr></tr>");
        $.each(ds, function(k, v){
            if (k != 'url') {
                var col_name = resolveFiledName(dsFiledName, k);
                if (col_name && col_name !== ""){
                    var tds = '<td class="info_label" align="right">'+ resolveFiledName(dsFiledName, k) +':</td>' +
                        '<td align="left" colspan="2">'+ resolveFiledValue(dsFiledName, k, v) +'</td>';
                    tr.append(tds);
                    arr.push(tds);
                    if (i % 2 === 0) {
                        $("#res_info_target").before(tr);
                        tr = $("<tr></tr>");
                        arr = [];
                    }
                    i++;
                }
            }
        });
        if (arr.length > 0) {
            $("#res_info_target").before(tr);
        }
    };

    var loadResEx = function (ri) {
        i = 1;
        var tr = $("<tr></tr>");
        var arr = [];
        $.each(ri, function(k, v){
            if (v !== '') {
                var col_name = resolveFiledName(resFiledInfo, k);
                if (col_name && col_name !== "") {
                    var tds = '<td class="info_label" align="right">'+ col_name +':</td>' +
                        '<td align="left" colspan="2">'+ resolveFiledValue(resFiledInfo, k, v) +'</td>';
                    tr.append(tds);
                    arr.push(tds);
                    if (i % 2 === 0) {
                        $("#res_info_target").before(tr);
                        tr = $("<tr></tr>");
                        arr = [];
                    }
                    i++;
                }

            }
        });
        if (arr.length > 0) {
            $("#res_info_target").before(tr);
        }
    };

    var makeHeader = function (d) {
        var tr = $("<tr></tr>");
            var name = "";
        $.each(colFiledInfo, function (k, v) {
                    name = v.name;
            tr.append('<td class="info_label" align="center">'+ name +'</td>');
        });
        return tr;
    };

    var makeBody = function (arr) {
        for (var i = 0; i < arr.length; i++) {
            var tr = $("<tr></tr>");
            $.each(colFiledInfo, function (k, v) {
                var data = "";
                $.each(arr[i], function (kk, vv) {
                    if (kk === v.key) {
                        if (v.type === "string") {
                            data = vv;
                        }
                        if (v.type === "option") {
                            data = v.format(vv);
                        }
                    }
                });
                tr.append('<td class="info_label" align="center">'+ data +'</td>');
            });
            $("#cols_info_table tbody").append(tr);
        }
    };

    var loadCols = function (data) {
        var cols = data;
        $("#cols_info_table thead").html(makeHeader(cols[0]));

        makeBody(cols);
    };

    var loadResourceInfo = function (data) {
        var resBaseFileds = $("#res_detail_info .res_filed");
        $.each(resBaseFileds, function (i, n) {
            var filed = $(n).data("filed");
            var v = data[filed];
            if (v == '' || v == null) {
                $(n).html('无');
            }
            if (filed === "resourceType" || filed === 'networkCode') {
                v = v === '1'?'一类':(v==='2'?'二类':'三类');
                $(n).html(v);
                return true;
            }
            if (filed === "type")  {
                v = v===1?'数据库资源':(v===2?'接口资源':(v===3?'巨龙资源':'六合一资源'));
                $(n).html(v);
                return true;
            }
            if (filed === 'status') {
                v = v===0?'审核中':(v===1?'已拒绝':(v===2)?'审核通过':'已发布');
                $(n).html(v);
                return true;
            }
            if (filed === 'openFlag') {
                v=v===0?'不公开':'公开';
                $(n).html(v);
                return true;
            }
            if (filed === 'createTime' || filed === 'lastUpdateTime') {
                v=formatTimestamp(v);
                $(n).html(v);
                return true;
            }
            $(n).html(v);
        });
        var d = data.dataSource;
        if (d) {
            loadDataSource(d);
        }
        var resEx = data.resourceExtension;
        if (resEx) {
            loadResEx(resEx);
        }
        var cols = data.resourceFields;
        if (cols) {
            loadCols(cols);
        }
    };

    $.extend({
       sbma_loadResInfo:  loadResourceInfo
    });

});