var regexEnum = {
	numAndLetter:/^[a-zA-Z0-9]+$/,
	number:"^\\d*$",						//数字
	intege:"^-?[1-9]\\d*$",					//整数
	intege1:"^[1-9]\\d*$",					//正整数
	intege2:"^-[1-9]\\d*$",					//负整数
	num:"^([+-]?)\\d*\\.?\\d+$",			//数字
	num1:"^([1-9]\\d*|0)$",					//正数（正整数 + 0）
	num2:"^(-[1-9]\\d*|0)$",				//负数（负整数 + 0）
	decmal:"^([+-]?)\\d*\\.\\d+$",			//浮点数
	decmal1:"^[1-9]\\d*.\\d*|0.\\d*[1-9]\\d*$",	//正浮点数
	decmal2:"^-([1-9]\\d*.\\d*|0.\\d*[1-9]\\d*)$", //负浮点数
	decmal3:"^-?([1-9]\\d*.\\d*|0.\\d*[1-9]\\d*|0?.0+|0)$", //浮点数
	decmal4:"^[1-9]\\d*.\\d*|0.\\d*[1-9]\\d*|0?.0+|0$", //非负浮点数（正浮点数 + 0）
	decmal5:"^(-([1-9]\\d*.\\d*|0.\\d*[1-9]\\d*))|0?.0+|0$",//非正浮点数（负浮点数 + 0）
	email:"^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$", //邮件
	emailSuffix:"^[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$",						//邮件后缀，@后的内容
	color:"^[a-fA-F0-9]{6}$",				//颜色
	url:"^http[s]?:\\/\\/([\\w-]+\\.)+[\\w-]+([\\w-./?%&=]*)?$",	//url
	chinese:"^[\\u4E00-\\u9FA5\\uF900-\\uFA2D]+$",					//仅中文
	ascii:"^[\\x00-\\xFF]+$",				//仅ACSII字符
	zipcode:"^\\d{6}$",						//邮编
	//mobile:"^(13|15|18|17|14)[0-9]{9}$",				//手机
    mobile:"^[0-9]*$",
    ip:"^(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)$",	//ip地址
	notempty:"(^\\S[\\S\\s]*\\S$)|(^\\S$)",				//非空
	noBlank:"^\\S+$",							//不允许出现空格
	picture:"(.*)\\.(jpg|bmp|gif|ico|pcx|jpeg|tif|png|raw|tga)$",	//图片
	rar:"(.*)\\.(rar|zip|7zip|tgz)$",								//压缩文件
	date:"^\\d{4}(\\-|\\/|\.)\\d{1,2}\\1\\d{1,2}$",					//日期
	qq:"^[1-9]*[1-9][0-9]*$",				//QQ号码
	tel:"^(([0\\+]\\d{2,3}-)?(0\\d{2,3})-)?(\\d{7,8})(-(\\d{3,}))?$",	//电话号码的函数(包括验证国内区号,国际区号,分机号)
	username:"^\\w+$",						//用来用户注册。匹配由数字、26个英文字母或者下划线组成的字符串
	letter:"^[A-Za-z]+$",					//字母
	letter_u:"^[A-Z]+$",					//大写字母
	letter_l:"^[a-z]+$",					//小写字母
	//idcard:"^([1-9][0-9]{16}[0-9|X])|([0-9]{15})$",	//身份证
	idcard:"^(([0-9Xx]{18})|([0-9Xx]{15}))$",	//身份证
	mac:"[A-F\\d]{2}:[A-F\\d]{2}:[A-F\\d]{2}:[A-F\\d]{2}:[A-F\\d]{2}:[A-F\\d]{2}",//MAC地址
	ipport:"^(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d):([1-9]\\d{1,4})$",//ip地址+端口号
	port:"(^[1-5]\\d{0,4}$)|(^6\\d{0,3}$)|(^6[0-4]\\d{0,3}$)|(^65[0-4]\\d{0,2}$)|(^655[0-2]\\d$)|(^6553[0-5]$)"	,				//端口号
	depcodenum:"^[0-9A-Za-z]*$",				//单位编码
	upperWord:"^([A-Z])+(_|[A-Z]|[0-9])*([A-Z]|[0-9])$"	,			//大写字符\数字\下划线
	jrxml:"^(.)*(.jrxml)$",
	orderField:"^([1-9]\\d*|0)$",					//正数（正整数 + 0）
	password:/^[a-zA-Z0-9_]+$/,
	noSingleQuote:"^[^']*$"						//不允许单引号
};

var regexEnum_messages = {
	numAndLetter:"只能输入数字和字母",
	number:"只能输入数字",						//数字
	intege:"请输入正确的整数.",					//整数
	intege1:"请输入大于0的整数.",				//正整数
	intege2:"请输入小于0的整数.",				//负整数
	num:"请输入正确的数字.",						//数字
	num1:"请输入大于0的数.",						//正数（正整数 + 0）
	num2:"请输入小于0的数.",						//负数（负整数 + 0）
	decmal:"请输入带小数的数字.",					//浮点数
	decmal1:"请输入大于0且带小数的数字.",	//正浮点数
	decmal2:"请输入小于0且带小数的数字.",	 	//负浮点数
	decmal3:"请输入带小数的数字.",			//浮点数
	decmal4:"请输入大于等于0且带小数的数字.",	//非负浮点数（正浮点数 + 0）
	decmal5:"请输入小于等于0且带小数的数字.",	//非正浮点数（负浮点数 + 0）
	email:"请输入正确的邮件格式，如:example@126.com.", //邮件
	emailSuffix:"请输入邮件地址中@符号后面的部分，如：126.com",	//邮件@符号后的部分
	color:"颜色数据格式不正确.",					//颜色
	url:"请输入正确的URL地址.",					//url
	chinese:"只能输入中文.",						//仅中文
	ascii:"只能输入ACSII字符.",					//仅ACSII字符
	zipcode:"邮编格式不正确.",					//邮编
	mobile:"手机号码格式不正确.",					//手机
	ip:"IP地址格式不正确.",						//ip地址
	notempty:"不能为空",		//非空
	noBlank:"不允许出现空格",					//不允许出现空格
	picture:"请选择正确的图片格式.",				//图片
	rar:"请选择正确的压缩文件格式.",				//压缩文件
	date:"日期格式不正确.",						//日期
	qq:"QQ号码格式不正确.",						//QQ号码
	tel:"电话号码格式不正确.",						//电话号码的函数(包括验证国内区号,国际区号,分机号)
	username:"只能输入数字、英文字母或下划线.",	//用来用户注册。匹配由数字、26个英文字母或者下划线组成的字符串
	letter:"只能输入英文字母.",					//字母
	letter_u:"只能输入大写英文字母.",				//大写字母
	letter_l:"只能输入小写英文字母.",				//小写字母
	idcard:"身份证号码格式不正确.",				//身份证
	equalsTo: "请输入相同的值.",			//值相同对比
	maxLength: "长度不能大于{0}.",		//最大长度
	minLength: "长度不能小于{0}.",		//最小长度
	mac:"MAC地址格式不正确，正确格式：00:24:21:19:BD:E4",//MAC地址
	ipport:"IP端口格式不正确，正确格式如：192.168.1.1:8080",//IP和端口
	port:"端口格式不正确，取值范围0-65535",		//端口号
    depcodenum:"单位编码长度必须12位",  //单位编码长度必须12位
    upperWord:"必须是英文大写字母、数字和下划线，开头必须是应为大写字母，结束必须非下划线",				//大写字符、数字和下划线，开头必须是字符，结束必须非下划线
    jrxml:"报表模板扩展名必须是jrxml",
    orderField:"请输入大于等于0的整数.",
    password:"只能输入数字、字母和下划线",
    noSingleQuote:"不允许出现单引号"
};

var rules_pams=new Object();
(function(){
for(var p in regexEnum){
	var regex=regexEnum[p];
	
	//alert(name+":"+regex);
	rules_pams[p]=new Object();
	rules_pams[p]["validator"]=function(value,param){
		//this.regex
		this.constructor.toString();
		var reg=new RegExp(this.regex);
		//alert(value+"  "+this.regex+" "+reg.test(value));
		//var name=(this).constructor.toString();
		//this.message=rules_pams[p].getName();
		return reg.test(value);
	};
	rules_pams[p]["regex"]=regexEnum[p];
	rules_pams[p]["message"]=regexEnum_messages[p];
}
})();
function validate_my(value,param,regex){
//alert(name+" "+regex);
		//var name=p;
		var reg=new RegExp(regex);
		
		//alert(value+"  "+regex+" "+reg.test(value));
		this.message=arguments[0];
		return reg.test(value);
}
$.extend($.fn.validatebox.defaults.rules,rules_pams);
/*
$.extend($.fn.validatebox.defaults.rules, {   
    remote: {   
        validator: function(value,param){
        var time=new Date().getTime();
       // alert(param[0]+"?"+time);
         
        	//var url="";
          $.post(param[0]+"?time="+time,param[1],function(date){
        	  //alert(date+"  "+(date=='true'));
        	  var flag=false;
        	  if(date=='true'){
        		  //alert(date);
        		  
        		  flag=true
        		 
        	  }
        	  $.data(document.body,'rmtflga',flag);
        	 // alert( $.data(document.body,'rmtflga'));
          });
          
          return  $.data(document.body,'rmtflga');;
        },   
        message: 'Field do not match.'
    }   
}); */