$(function () {

    var errInfo = {
            '0': '成功',
            '-19': 'SM4 运算失败',
            '-1' :'卡未插入',
            '-20' :'重置 PIN 码失败',
            '-2' :'参数错误',
            '-21' :'创建文件失败',
            '-3' :'未插入管理卡',
            '-22' :'SM3 运算失败',
            '-4' :'卡锁死',
            '-23' :'SM1 运算失败',
            '-5' :'口令错误',
            '-24' :'PSA 私钥运算失败',
            '-6' :'卡内产生公私钥对失败',
            '-25' :'获取设备信息失败',
            '-7' :'新建容器失败',
            '-61' :'解析网关证书失败',
            '-8' :'容器不存在',
            '-62' :'签名失败',
            '-9' :'绑定用户卡失败',
            '-63' :'取消签名失败',
            '-10' :'文件不存在',
            '-99' :'内部错误',
            '-11' :'写文件失败',
            '-101' :'内存申请失败',
            '-12' :'证书格式错误',
            '-203' :'容器不存在',
            '-13' :'导入证书失败',
            '-204' :'容器证书内容错误',
            '-14' :'BASE64 解码失败',
            '-100' :'不支持此功能',
            '-15' :'解析 pfx 失败',
            '-16' :'导入 pfx 失败',
            '-17' :'读卡文件失败',
            '-18' :'导入密钥失败',
            '-26' :'产生随机数失败',
            '-27' :'激活卡失败',
            '-28' :'获取卡激活状态失败',
            '-29' :'未激活',
            '-30' :'ADB 端口被占用',
            '-31' :'手机驱动安装失败',
            '-32' :'卸载安通助手失败',
            '-33' :'获取设备号失败',
            '-34' :'开启安通助手失败',
            '-35' :'导入公钥失败',
            '-36' :'导入私钥失败',
            '-37' :'公钥运算失败',
            '-38' :'私钥运算失败',
            '-39' :'SM2 运算失败',
            '-40' :'创建目录失败',
            '-41' :'创建密钥失败',
            '-42' :'选择文件失败',
            '-43' :'解锁加密盘失败',
            '-44' :'删除文件失败',
            '-45' :'修改剩余授权次数',
            '-46' :'导入的授权证书私钥不对',
            '-47' :'授权次数不够',
            '-48' :'没有授权卡'
    };


    var comActiveX = null;
    var conn;
    var cardId;
    var personId;
    var keyId;
    var cardPwd;

    // 撤销操作
    var mdpRevokeCert = function(personIdIn, keyIdIn){
        personId = personIdIn;
        keyId = keyIdIn;
        $.ajax({
           url: "/pams/sso/mdpusermanagercontroller/revoke.do",
           type: "POST",
           data: {personId: personId, keyId: keyId},
           dataType: "json",
           success: function(r) {
                if (r.success) {
                    $.messager.alert("提示",'证书已经撤销');
                    $('#win_userInfo').dialog('close');
                    $("#cardInfo_searchList").datagrid("load");
                } else{
                    $.messager.alert("提示",'证书撤销失败: ' + r.msg);
                }
           },
           error: function(){
               $.messager.alert("提示",'撤销证书网络异常');
           }
        });
    };
    var isLoadPluginSuccess = function (flag) {
        if (flag) {
            $("#div_writeCardDriver_install").hide();
            $("#div_user_info_box, #write_card_btn").show();
        } else{
            $.messager.alert("提示",'没有安装写卡控件，请下载安装后再试。');
            $("#div_writeCardDriver_install").show();
            $("#div_user_info_box, #write_card_btn").hide();
        }
    };
    var getVersion = function(){
        fun = {method:'Test',id:"1"};
        conn.onmessage = function(evt) {
            var rst = evt.data;
            try {
                rst = JSON.parse(rst);
            }catch(e) {
            }

            if (rst && rst.state) {
                var version = rst.result;
                var flag = true;
                if (version < newVersion) {
                    flag = false;
                    comActiveX = null;
                }
                try{
                    isLoadPluginSuccess(flag);
                } catch(e){

                }
            }
        };
        var param = JSON.stringify(fun);
        conn.send(param);
    };
    var Connect = function(){
        try {
            conn = new WebSocket('wss://localhost:8000/xdja/server');
        } catch(e) {
            console.log(e);
        }
        conn.onopen = function() {
            getVersion();
        };
        conn.onmessage = function(evt) {
            wsRst = evt.data;
        };
        conn.onclose = function() {
            alert('Conn closed');
        };
        conn.onerror = function(evt) {
            console.info(evt.data);
        };
        return conn;
    };

    var loadComActiveX = function () {
        $.winmask.setmsg("开始加载驱动......");
        // IE
        if (checkIEBrowser()) {
            comActiveX = new ActiveXObject("CardCert.WriteCard");
            flag = 1;
        } else {
            // 非IE
            comActiveX = document.getElementById("pluginXdja");
            flag = 0;
            try {
                comActiveX.Test();
            } catch(e) {
                comActiveX = Connect();
            }
        }
        isLoadPluginSuccess(comActiveX !== undefined);
    };
    var getCardId = function(usage) {
        // usage : 0-管理卡, 1-用户卡, -1-所有
        if (conn) {
           return [];
        } else{
            var ids = comActiveX.GetAllCards("1", usage);
            return ids.split("#");
        }
    };
    // 检查卡密码
    var checkPin = function() {
        $.winmask.setmsg("正在检查卡......");
        if (conn) {
            // websocket 方式省略校验卡密码步骤
            var checkResult = checkUserKeyRemote();
            if (checkResult) {
                getPubKey();
            }
            return false;
        } else{
            try {
                var cardPwdCheckCode = comActiveX.SafePin(cardId, cardPwd, 0x11);
                if (cardPwdCheckCode !== "0") {
                    $.winmask.hide("卡密码错误");
                    return false;
                }
            } catch (e) {
                $.winmask.hide("卡密码异常");
                return false;
            }
            return true;
        }
    };
    var checkKeyByConn = function(usage){
        if (conn) {
            var param = {method:'GetAllCards',id:"2",param:{type:1,usage:usage}};
            conn.onmessage=function(evt){
                conn.onmessage=function(){};
                var rst = evt.data;
                try {
                    rst = JSON.parse(rst);
                }catch(e) {

                }
                var keyName = usage === 0? "管理卡" : (usage === 1 ? "用户卡" : "");
                if (!rst.state) {
                    $.winmask.hide("请插入管理卡");
                    return;
                }
                if (rst) {
                    var cardIds = rst.result.split("#");
                    if (!cardIds) {
                        $.winmask.hide("未读取到卡号，请插入"+keyName+"！");
                    } else if(cardIds.length !== 1) {
                        $.winmask.hide("请插入并仅插入一个"+keyName+"！");
                    }
                    if (cardIds.length === 1){
                        if (usage === 0) {
                            // 检查用户key
                            checkKeyByConn(1);
                            return false;
                        }
                        if (usage === 1){
                            // 校验都通过 , 开始检查PIN码
                            checkPin();
                        }
                    }
                }
            };
            conn.send(JSON.stringify(param));
        }
    };
    // 检查管理key
    var checkAdminKey = function () {
        if (conn) {
            checkKeyByConn(0);
            return false;
        }
        var cardIds = getCardId("0");

        if (!cardIds) {
            $.winmask.hide("未读取到卡号，请插入管理卡！");
        } else if(cardIds.length !== 1) {
            $.winmask.hide("请插入并仅插入一个管理卡！");
        }
        return cardIds.length === 1;
    };
    // 检查用户key
    var checkUserKey = function () {
        if (conn) {
            return false;
        }
        var cardIds = getCardId("1");
        if (!cardIds) {
            $.winmask.hide("未读取到卡号，请插入用户卡！");
        } else if(cardIds.length !== 1) {
            $.winmask.hide("请插入并仅插入一个用户卡！");
        } else{
            cardId = cardIds[0];
        }
        return cardIds.length === 1;

    };
    // 校验是否可以写卡
    var checkUserKeyRemote = function() {
        var isValidKey = false;
        $.ajax({
           url: "/pams/sso/mdpusermanagercontroller/checkcard.do",
           type: "POST",
           data: {personId: personId, cardId: cardId, keyId: keyId},
           async: false,
           dataType: "json",
           success: function(r) {
                if (r.success) {
                    isValidKey = true;
                } else{
                    $.winmask.hide("[错误]" + r.msg);
                }
           },
           error: function() {
               $.winmask.hide("检查key异常！");
           }
        });
        return isValidKey;
    };
    // 获取公钥
    var getPubKey = function (){

        var pubKey;
        if (conn) {
            var param = {method:'GenKeypair',id:"12",param:{cardid:cardId,password:cardPwd,containerid:0,alg:0,certusage:0,keybits:1024}};
            conn.onmessage=function(evt){
                conn.onmessage=function(){};
                var rst = evt.data;
                try {
                    rst = JSON.parse(rst);
                }catch(e) {

                }
                if (rst) {
                    if (!rst.state) {
                        ernum = rst.result;
                        $.winmask.hide(errInfo["'"+ernum+"'"]);
                        return false;
                    } else{
                        pubKey = rst.result;
                        downloadCert(pubKey)
                    }

                }
            };
            conn.send(JSON.stringify(param));
            pubKey = undefined;
        } else{
            try {
                pubKey = comActiveX.GenKeypair(cardId, cardPwd, 0, 0, 0, 1024);
            } catch (ex) {
                console.error(ex);
                var ernum;
                if (checkIEBrowser()) {
                    ernum = ex.number;
                } else {
                    var tmp = String(ex).split(':');
                    if (tmp.length > 1) {
                        ernum = tmp[1];
                    } else {
                        ernum = tmp[0];
                    }
                }
                $.winmask.hide(errInfo["'"+ernum+"'"]);
                return undefined;
            }
        }
        return pubKey;
    };

    // 写入证书
    var mdpWriteCert = function (cert) {
        var ernum = 0;
        if (conn) {
            var param = {method:'WriteCert',id:"14",param:{cardid:cardId,password:cardPwd,containerid:0,certusage:0,cert:cert}};
            conn.onmessage=function(evt){
                conn.onmessage=function(){};
                var rst = evt.data;
                try {
                    rst = JSON.parse(rst);
                    $('#win_userInfo').dialog('close');
                    $("#cardInfo_searchList").datagrid("load");
                }catch(e) {

                }
                if (!rst.state) {
                    ernum = rst.result;
                    $.winmask.hide(errInfo["'"+ernum+"'"]);
                    mdpRevokeCert();
                    return false;
                }
            };
            conn.send(JSON.stringify(param));
        } else{
            try{
                comActiveX.WriteCert( cardId, cardPwd, 0, 0, cert);
                $('#win_userInfo').dialog('close');
                $("#cardInfo_searchList").datagrid("load");
            }catch(ex) {// IE
                if (checkIEBrowser()) {
                    ernum = ex.number;
                } else {
                    var tmp = String(ex).split(':');
                    if (tmp.length > 1) {
                        ernum = tmp[1];
                    } else {
                        ernum = tmp[0];
                    }
                }
                $.winmask.hide(errInfo["'"+ernum+"'"]);
                mdpRevokeCert();
            }
        }
    };

    var downloadCert = function(pubKey) {
        var cert = "";
        $.ajax({
            url: "/pams/sso/mdpusermanagercontroller/downloadcert.do",
            type: "POST",
            data: {personId: personId, cardId: cardId, keyId: keyId, pubKey: pubKey},
            dataType: "json",
            async: false,
            success: function(r) {
                if (r.success) {
                    cert = r.cert;
                    keyId = r.keyId;
                    mdpWriteCert(cert);
                } else{
                    $.winmask.hide(r.msg);
                }
            },
            error: function() {
                $.winmask.hide("下载证书网络异常");
            }
        });
        return cert;
    };
    // 开始写卡control
    // personId: 人员id;
    // keyId: 已经写过的key的记录id,用来判断读取的卡号和记录中的卡号是否相同
    var mdpWriteCard = function (personIdIn, keyIdIn) {
        $.winmask.setmsg("准备写卡......");
        if (!personIdIn) {
            $.winmask.hide("人员id异常");
            return false;
        }
        personId = personIdIn;
        keyId = keyIdIn;
        if (!comActiveX) {
            loadComActiveX();
        }
        // 校验卡密码
        cardPwd = $("#card_pwd_ipt").val();
        if (!cardPwd){
            $.winmask.hide("请输入卡密码");
            return false;
        }
        if (comActiveX && checkAdminKey() && checkUserKey()) {
            // 开始写卡
            /*
            1. 检查卡是否可用: 是否已经被别人占用, 是否已经写过证书
            2. 下载证书, 并写卡, 如果写卡失败上报并撤销证书
             */
            if (!cardId) {
                $.winmask.hide("读取用户卡失败");
                return false;
            }
            // 校验卡密码
            if(!checkPin()) return false;
            // 后台检查key是否可用
            if(!checkUserKeyRemote()) return false;
            // 生成公私钥对, 下载证书, 然后写卡
            $.winmask.setmsg("开始生成公私钥....");
            var pubKey = getPubKey();
            // 没有获取到公钥, 则停止操作
            if (!pubKey){
                return false;
            }
            $.winmask.setmsg("开始生成公私钥....");
            downloadCert(pubKey);
        }
    };

    $.extend({
        loadComActiveX: loadComActiveX,
        mdpWriteCard: mdpWriteCard,
        mdpRevokeCert: mdpRevokeCert
    });
});