/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.attendance.control;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.xatl.attendance.bean.ErrorBean;
import pams.function.xatl.attendance.bean.ResponseBean;
import pams.function.xatl.attendance.bean.push.ImeiPersonBean;
import pams.function.xatl.attendance.bean.push.RulePushPersonBean;
import pams.function.xatl.attendance.service.AttendanceService;
import pams.function.xatl.common.util.Util;
import pams.function.xatl.ruyihu.bean.BusinessTripDateBean;
import pams.function.xatl.ruyihu.entity.BusinessTripEntity;
import pams.function.xatl.ruyihu.entity.LeaveEntity;
import pams.function.xatl.ruyihu.service.IBusinessTripService;
import pams.function.xatl.ruyihu.service.LeaveQueryService;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.QuickJson;
import pams.function.xatl.workreport.util.DateUtil;

@Controller
@Scope(value="session")
public class AttendanceApiControl
extends BaseControler {
    private static final Logger logger = LoggerFactory.getLogger(AttendanceApiControl.class);
    @Autowired
    private AttendanceService attendanceService;
    @Autowired
    private LeaveQueryService leaveQueryService;
    @Autowired
    private IBusinessTripService businessTripService;

    @RequestMapping(value={"/attendanceApiControl/queryImeiAndPcidByPersonIds.do"})
    public void queryImeiAndPcidByPersonIds(HttpServletRequest request, HttpServletResponse response) {
        ResponseBean responseBean = new ResponseBean();
        try {
            String json = IOUtils.toString((InputStream)request.getInputStream());
            logger.debug("/attendanceApiControl/queryImeiAndPcidByPersonIds.do \u6839\u636e\u4eba\u5458id\u83b7\u53d6IMEI \u8bf7\u6c42\u6570\u636eRulePushPersonBean: [{}]", (Object)json);
            RulePushPersonBean rulePushPersonBean = Util.readValue(json, RulePushPersonBean.class);
            List<ImeiPersonBean> list = this.attendanceService.queryImeiAndPcidByPersonIds(rulePushPersonBean);
            responseBean.setResult(list);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u4eba\u5458id\u83b7\u53d6\u63a8\u9001\u6807\u8bc6: {}", (Throwable)e);
            responseBean.setId("-1");
            responseBean.setError(ErrorBean.create(-1, "\u83b7\u53d6\u4eba\u5458\u63a8\u9001\u6807\u8bc6\u5931\u8d25"));
        }
        String result = Util.toJsonStr(responseBean);
        logger.debug("/attendanceApiControl/queryImeiAndPcidByPersonIds.do \u6839\u636e\u4eba\u5458id\u83b7\u53d6IMEI \u8fd4\u56de\u6570\u636eResponseBean: [{}]", (Object)result);
        Util.writeUtf8Text(response, result);
    }

    @RequestMapping(value={"/attendanceApiControl/queryLeaveCountByPersonIdEveryDay.do"})
    public void queryLeaveCountByPersonIdEveryDay(HttpServletRequest request, HttpServletResponse response) {
        Date firstDayOfMonth;
        Date end;
        Date begin;
        Date dailyDate;
        String params = request.getParameter("params");
        if (StringUtils.isEmpty((String)params)) {
            logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new LakeMobException("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        JSONObject object = JSONObject.parseObject((String)params);
        logger.debug("/attendanceApiControl/queryLeaveCountByPersonIdEveryDay.do \u6839\u636e\u4eba\u5458id\u83b7\u53d6\u8bf7\u5047\u5929\u6570  \u8bf7\u6c42\u53c2\u6570: [{}]", (Object)object.toJSONString());
        String personId = object.getString("personId");
        String dailyDateStr = object.getString("dailyDate");
        try {
            dailyDate = Util.parseDate(dailyDateStr, "yyyy-MM-dd");
            begin = Util.parseDate(dailyDateStr + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
            end = Util.parseDate(dailyDateStr + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
            firstDayOfMonth = Util.getFirstDayOfMonth(dailyDate);
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new LakeMobException("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef");
        }
        float daysCount = this.leaveQueryService.getLeaveDaysForPerson(begin, end, personId);
        List<LeaveEntity> leaveEntityList = this.leaveQueryService.getLeaveList(personId, begin, end, null, null);
        JSONArray singleDayLeaveArray = new JSONArray();
        this.leaveList2JsonArray(singleDayLeaveArray, leaveEntityList);
        JSONArray jsonArray = new JSONArray();
        List<LeaveEntity> leaveList = this.leaveQueryService.getLeaveList(personId, firstDayOfMonth, dailyDate, null, "Y");
        this.leaveList2JsonArray(jsonArray, leaveList);
        object.put("singleDayLeaveList", (Object)singleDayLeaveArray);
        object.put("daysCount", (Object)Float.valueOf(daysCount));
        object.put("list", (Object)jsonArray);
        logger.debug("/attendanceApiControl/queryLeaveCountByPersonIdEveryDay.do \u6839\u636e\u4eba\u5458id\u83b7\u53d6\u8bf7\u5047\u5929\u6570  \u8fd4\u56de\u7ed3\u679c: [{}]", (Object)object.toJSONString());
        Util.writeUtf8Text(response, object.toJSONString());
    }

    private void leaveList2JsonArray(JSONArray jsonArray, List<LeaveEntity> leaveList) {
        if (leaveList != null && leaveList.size() > 0) {
            for (LeaveEntity leaveEntity : leaveList) {
                JSONObject temp = new JSONObject();
                temp.put("beginDate", (Object)Util.getDate("yyyy-MM-dd", leaveEntity.getBeginDate()));
                temp.put("beginHalfDay", (Object)(leaveEntity.getBeginHalfDay() + ""));
                temp.put("endDate", (Object)Util.getDate("yyyy-MM-dd", leaveEntity.getEndDate()));
                temp.put("endHalfDay", (Object)(leaveEntity.getEndHalfDay() + ""));
                temp.put("realBeginDate", (Object)Util.getDate("yyyy-MM-dd", leaveEntity.getRealStartDate()));
                temp.put("realBeginHalfDay", (Object)(leaveEntity.getRealStartHalfDay() + ""));
                temp.put("realEndDate", (Object)Util.getDate("yyyy-MM-dd", leaveEntity.getRealEndDate()));
                temp.put("realEndHalfDay", (Object)(leaveEntity.getRealEndHalfDay() + ""));
                jsonArray.add((Object)temp);
            }
        }
    }

    @RequestMapping(value={"/attendanceApiControl/businessTrip/dayDetail.do"})
    public void dayDetail(String personId, String dailyDate, HttpServletResponse response) {
        logger.debug("/attendanceApiControl/businessTrip/dayDetail.do \u8bf7\u6c42\u53c2\u6570\u4e3a:personId:[{}],dailyDate:[{}]", (Object)personId, (Object)dailyDate);
        if (StringUtils.isEmpty((String)personId) || StringUtils.isEmpty((String)dailyDate)) {
            logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new LakeMobException("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        Date dailyD = null;
        Date firstDayOfMonth = null;
        try {
            dailyD = Util.parseDate(dailyDate, "yyyy-MM-dd");
            firstDayOfMonth = Util.getFirstDayOfMonth(dailyD);
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new LakeMobException("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef");
        }
        int daysCount = 0;
        List<BusinessTripEntity> tripList = this.businessTripService.businessTripList(dailyD, dailyD, personId, null);
        JSONArray array = new JSONArray();
        if (tripList != null && tripList.size() > 0) {
            daysCount = 1;
            if (tripList != null && tripList.size() > 0) {
                for (BusinessTripEntity entity : tripList) {
                    JSONObject temp = new JSONObject();
                    temp.put("beginDate", (Object)Util.getDate("yyyy-MM-dd", entity.getStartDate()));
                    temp.put("endDate", (Object)Util.getDate("yyyy-MM-dd", entity.getEndDate()));
                    temp.put("realBeginDate", (Object)Util.getDate("yyyy-MM-dd", entity.getRealStartDate()));
                    temp.put("realEndDate", (Object)Util.getDate("yyyy-MM-dd", entity.getRealEndDate()));
                    array.add((Object)temp);
                }
            }
        }
        JSONArray jsonArray = new JSONArray();
        List<BusinessTripEntity> list = this.businessTripService.businessTripList(firstDayOfMonth, dailyD, personId, "Y");
        if (list != null && list.size() > 0) {
            for (BusinessTripEntity entity : list) {
                JSONObject temp = new JSONObject();
                temp.put("beginDate", (Object)Util.getDate("yyyy-MM-dd", entity.getStartDate()));
                temp.put("endDate", (Object)Util.getDate("yyyy-MM-dd", entity.getEndDate()));
                temp.put("realBeginDate", (Object)Util.getDate("yyyy-MM-dd", entity.getRealStartDate()));
                temp.put("realEndDate", (Object)Util.getDate("yyyy-MM-dd", entity.getRealEndDate()));
                jsonArray.add((Object)temp);
            }
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        dataMap.put("personId", personId);
        dataMap.put("dailyDate", dailyDate);
        dataMap.put("daysCount", daysCount);
        dataMap.put("nowDayLeaveList", array);
        dataMap.put("list", jsonArray);
        Util.writeUtf8Text(response, QuickJson.toJsonStr(dataMap));
    }

    @RequestMapping(value={"/attendanceApiControl/businessTrip/queryBusinessTripDaysCount.do"})
    public void queryBusinessTripDaysCount(String personId, String dailyDate, HttpServletResponse response) {
        logger.debug("/attendanceApiControl/businessTrip/queryBusinessTripDaysCount.do \u8bf7\u6c42\u53c2\u6570\u4e3a:personId:[{}],dailyDate:[{}]", (Object)personId, (Object)dailyDate);
        try {
            if (StringUtils.isEmpty((String)personId) || StringUtils.isEmpty((String)dailyDate)) {
                logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                throw new LakeMobException("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
            }
            Date dailyD = null;
            Date firstDayOfMonth = null;
            Date lastDayOfMonth = null;
            try {
                dailyD = Util.parseDate(dailyDate, "yyyy-MM-dd");
                firstDayOfMonth = Util.getFirstDayOfMonth(dailyD);
                lastDayOfMonth = Util.getLastDayOfMonth(dailyD);
            }
            catch (Exception e) {
                logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef\uff1a{}", (Throwable)e);
                throw new LakeMobException("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef");
            }
            int daysCount = 0;
            ArrayList<String> businessTripDayList = new ArrayList<String>();
            List<BusinessTripDateBean> businessTripDateBeanList = this.businessTripService.queryBusinessTripDateList(personId, DateUtil.ymdSDF.format(firstDayOfMonth), DateUtil.ymdSDF.format(lastDayOfMonth));
            while (firstDayOfMonth.getTime() <= lastDayOfMonth.getTime()) {
                for (BusinessTripDateBean businessTripDateBean : businessTripDateBeanList) {
                    Timestamp end;
                    Timestamp start;
                    if (businessTripDateBean.getRealStartDate() != null && businessTripDateBean.getRealEndDate() != null) {
                        start = businessTripDateBean.getRealStartDate();
                        end = businessTripDateBean.getRealEndDate();
                    } else {
                        start = businessTripDateBean.getStartDate();
                        end = businessTripDateBean.getEndDate();
                    }
                    if (start == null || end == null || firstDayOfMonth.getTime() < ((Date)start).getTime() || firstDayOfMonth.getTime() > ((Date)end).getTime()) continue;
                    ++daysCount;
                    businessTripDayList.add(DateUtil.ymdSDF.format(firstDayOfMonth));
                    break;
                }
                firstDayOfMonth = Util.addDay(firstDayOfMonth, 1);
            }
            HashMap<String, Serializable> dataMap = new HashMap<String, Serializable>(4);
            dataMap.put("daysCount", Integer.valueOf(daysCount));
            dataMap.put("businessTripDayList", businessTripDayList);
            Util.writeUtf8Text(response, QuickJson.toJsonStr(dataMap));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

