/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.attendance.control;

import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.xatl.attendance.bean.rule.AttendanceRuleAddress;
import pams.function.xatl.attendance.bean.rule.AttendanceRuleBean;
import pams.function.xatl.attendance.bean.rule.AttendanceRulePageBean;
import pams.function.xatl.attendance.bean.rule.AttendanceRulePeriod;
import pams.function.xatl.attendance.bean.rule.AttendanceRulePersonBean;
import pams.function.xatl.attendance.bean.rule.AttendanceRuleWifi;
import pams.function.xatl.attendance.bean.rule.AttendanceSetBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceClockBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceDetailBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceDetailDailyBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceDetailDailyPageBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceSumaryBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceSumaryDailyBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceSumaryDailyPageBean;
import pams.function.xatl.attendance.service.AttendanceService;
import pams.function.xatl.bims.bean.PersonDepBean;
import pams.function.xatl.bims.service.UserManageServiceForXatl;
import pams.function.xatl.common.exception.ServiceException;
import pams.function.xatl.workreport.util.DateUtil;

@Controller
@Scope(value="session")
public class AttendanceControl
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(AttendanceControl.class);
    @Autowired
    private ResourceBundleMessageSource resourceBundleMessageSource;
    @Autowired
    private AttendanceService attendanceService;
    @Autowired
    private UserManageServiceForXatl userManageService;
    @Autowired
    private PersonDao personDao;
    private static final int WEEKEND = 2;

    @RequestMapping(value={"/attendance/attendanceSet/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/attendance/attendanceSet/queryAttendanceSetList.do"})
    public void queryAttendanceSetList(HttpServletRequest request, HttpServletResponse response, ModelMap map, AttendanceRuleBean attendanceRule) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(8);
        try {
            int pageNum = 1;
            int rows = 10;
            try {
                pageNum = Integer.parseInt(attendanceRule.getPage());
                rows = Integer.parseInt(attendanceRule.getRows());
            }
            catch (Exception e) {
                pageNum = 1;
                rows = 100;
            }
            Page page = new Page(pageNum, rows);
            attendanceRule.setDeptId(this.person.getDepartment().getParentID());
            List<AttendanceRulePageBean> list = this.attendanceService.queryAttendanceSetList(attendanceRule, page);
            mapBean.put("total", page.getTotal());
            mapBean.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u89c4\u5219\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/attendance/attendanceSet/toAddOrEditForm.do"})
    public String toAddOrEditForm(HttpServletRequest request, HttpServletResponse response, ModelMap map, AttendanceRuleBean attendanceRule) {
        String sendUrl = "error/error";
        try {
            AttendanceRuleBean attendanceRuleBean = new AttendanceRuleBean();
            attendanceRuleBean.setWorkday("2,3,4,5,6");
            if (StringUtils.isNotBlank((CharSequence)attendanceRule.getRuleId())) {
                attendanceRuleBean = this.attendanceService.queryAttendanceRuleByRuleId(attendanceRule);
                List<AttendanceRuleAddress> attendanceSiteList = this.attendanceService.queryAttendanceSiteList(attendanceRule.getRuleId());
                if (null != attendanceSiteList && attendanceSiteList.size() > 0) {
                    AttendanceRuleAddress attendanceRuleAddress = attendanceSiteList.get(0);
                    attendanceRuleBean.setEffectiveDistance(attendanceRuleAddress.getEffectiveDistance() + "");
                }
            }
            if (StringUtils.isBlank((CharSequence)attendanceRuleBean.getEffectiveDistance())) {
                attendanceRuleBean.setEffectiveDistance("500");
            }
            map.put((Object)"rule", (Object)attendanceRuleBean);
            sendUrl = "attendance/attendanceSet/default/toAddOrEditForm";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/attendance/attendanceSet/toAttendanceRulePersonForm.do"})
    public String toAttendanceRulePersonForm(HttpServletRequest request, HttpServletResponse response, ModelMap map, AttendanceRulePersonBean attendanceRulePersonBean) {
        try {
            List<AttendanceRulePersonBean> list = null;
            if (StringUtils.isNotBlank((CharSequence)attendanceRulePersonBean.getRuleId())) {
                list = this.attendanceService.queryAttendanceRulePersonList(attendanceRulePersonBean);
            }
            ArrayList<String> personIds = new ArrayList<String>();
            if (null != list && list.size() > 0) {
                for (AttendanceRulePersonBean bean : list) {
                    personIds.add(bean.getPersonId());
                }
            }
            List<Object> personlist = new ArrayList();
            if (personIds.size() > 0) {
                personlist = this.userManageService.queryPersonByPersonIds(personIds);
            }
            request.setAttribute("personList", personlist);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return "attendance/attendanceSet/default/index";
    }

    @RequestMapping(value={"/attendance/attendanceSet/toAddAttendanceTimeForm.do"})
    public String toAddAttendanceTimeForm(ModelMap map, String startTime, String endTime) {
        String sendUrl = "error/error";
        try {
            sendUrl = "attendance/attendanceSet/default/toAddAttendanceTimeForm";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/attendance/attendanceSet/queryAttendanceTimeList.do"})
    public void queryAttendanceTimeList(HttpServletRequest request, HttpServletResponse response, ModelMap map, String ruleId) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(8);
        try {
            List<Object> list = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                list = this.attendanceService.queryAttendanceTimeList(ruleId);
            }
            if (null == list || list.size() == 0) {
                list = new ArrayList();
                AttendanceRulePeriod period = new AttendanceRulePeriod();
                period.setRulePeriodId("11");
                period.setOnLimitTime("00:00");
                period.setStartTime("09:00");
                period.setEndTime("17:30");
                period.setOffLimitTime("23:59");
                list.add(period);
            }
            if (list.size() > 0) {
                for (AttendanceRulePeriod attendanceRulePeriod : list) {
                    String endTime;
                    String startTime;
                    String offLimitTime;
                    String onLimitTime = attendanceRulePeriod.getOnLimitTime();
                    if (StringUtils.isNotBlank((CharSequence)onLimitTime)) {
                        String[] aryLimitTime = onLimitTime.split(":");
                        attendanceRulePeriod.setOnLimitTime(aryLimitTime[0] + ":" + aryLimitTime[1]);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(offLimitTime = attendanceRulePeriod.getOffLimitTime()))) {
                        String[] aryOffLimitTime = offLimitTime.split(":");
                        attendanceRulePeriod.setOffLimitTime(aryOffLimitTime[0] + ":" + aryOffLimitTime[1]);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(startTime = attendanceRulePeriod.getStartTime()))) {
                        String[] aryStartTime = startTime.split(":");
                        attendanceRulePeriod.setStartTime(aryStartTime[0] + ":" + aryStartTime[1]);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(endTime = attendanceRulePeriod.getEndTime()))) continue;
                    String[] aryEndTime = endTime.split(":");
                    attendanceRulePeriod.setEndTime(aryEndTime[0] + ":" + aryEndTime[1]);
                }
            }
            mapBean.put("total", list.size());
            mapBean.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u65f6\u6bb5\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/attendance/attendanceSet/toAddAttendanceSiteForm.do"})
    public String toAddAttendanceSiteForm(ModelMap map, String startTime, String endTime) {
        String sendUrl = "error/error";
        try {
            Department dept = this.person.getDepartment();
            String parentId = dept.getParentID();
            String address = null != parentId ? dept.getParentDep().getName() : dept.getName();
            String url = "/pams/view/attendance/attendanceSet/default/map.html?address=" + URLEncoder.encode(address, "utf-8");
            log.debug(url);
            map.put((Object)"mapUrl", (Object)url);
            sendUrl = "attendance/attendanceSet/default/toAddAttendanceSiteForm";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/attendance/attendanceSet/queryAttendanceSiteList.do"})
    public void queryAttendanceSiteList(HttpServletRequest request, HttpServletResponse response, ModelMap map, String ruleId) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(10);
        try {
            List<Object> list = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                list = this.attendanceService.queryAttendanceSiteList(ruleId);
            }
            if (null == list || list.size() == 0) {
                list = new ArrayList();
                AttendanceRuleAddress address = new AttendanceRuleAddress();
                address.setRuleAddressId("i");
                address.setEffectiveDistance(500);
                address.setLongitude("");
                address.setDimension("");
                list.add(address);
            }
            mapBean.put("total", list.size());
            mapBean.put("rows", list);
            log.debug(Util.toJsonStr(mapBean));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u5730\u70b9\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/attendance/attendanceSet/toAddAttendanceWifiForm.do"})
    public String toAddAttendanceWifiForm(ModelMap map, String wifiName, String wifiMac) {
        String sendUrl = "error/error";
        try {
            sendUrl = "attendance/attendanceSet/default/toAddAttendanceWifiForm";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/attendance/attendanceSet/queryAttendanceWifiList.do"})
    public void queryAttendanceWifiList(HttpServletRequest request, HttpServletResponse response, ModelMap map, String ruleId) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(10);
        try {
            List<Object> list = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                list = this.attendanceService.queryAttendanceWifiList(ruleId);
            }
            if (null == list || list.size() == 0) {
                list = new ArrayList();
                AttendanceRuleWifi wifi = new AttendanceRuleWifi();
                wifi.setRuleWifiId("i");
                list.add(wifi);
            }
            mapBean.put("total", list.size());
            mapBean.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4Wifi\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/attendance/attendanceSet/saveOrUpdateAttendanceSet.do"})
    public void saveOrUpdateAttendanceSet(ModelMap map, HttpServletRequest request, HttpServletResponse response, AttendanceSetBean attendanceSetBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            attendanceSetBean.setPersonId(this.person.getId());
            Department dept = this.person.getDepartment();
            String deptId = dept.getId();
            String parentId = dept.getParentID();
            attendanceSetBean.setDeptId(null != parentId ? parentId : deptId);
            attendanceSetBean.setRuleAdminName(this.person.getName());
            this.attendanceService.saveOrUpdateAttendanceSet(attendanceSetBean);
            rtnResult.setRtnCode("0");
            if (StringUtils.isBlank((CharSequence)attendanceSetBean.getAttendanceId())) {
                rtnResult.setRtnMsg("\u6dfb\u52a0\u6210\u529f");
            } else {
                rtnResult.setRtnMsg("\u66f4\u65b0\u6210\u529f");
            }
        }
        catch (ServiceException e) {
            log.error("\u4fdd\u5b58\u6216\u66f4\u65b0\u8003\u52e4\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6216\u66f4\u65b0\u8003\u52e4\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/attendance/attendanceSet/deleteAttendanceRule.do"})
    public void deleteAttendanceRule(ModelMap map, HttpServletRequest request, HttpServletResponse response, AttendanceRuleBean attendanceRuleBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.attendanceService.deleteAttendanceRule(attendanceRuleBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8003\u52e4\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/attendance/attendanceSet/updateAttendanceRulePerson.do"})
    public void updateAttendanceRulePerson(ModelMap map, HttpServletRequest request, HttpServletResponse response, AttendanceRulePersonBean attendanceRulePersonBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            attendanceRulePersonBean.setRuleAdminName(this.person.getName());
            this.attendanceService.updateAttendanceRulePerson(attendanceRulePersonBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("0");
        }
        catch (ServiceException e) {
            log.error("\u4e00\u4e2a\u4eba\u6709\u591a\u4e2a\u8003\u52e4\u89c4\u5219, \u9700\u8981\u518d\u6b21\u63d0\u4ea4", (Throwable)e);
            rtnResult.setRtnCode("0");
            log.debug("\u4e00\u4e2a\u4eba\u6709\u591a\u4e2a\u8003\u52e4\u89c4\u5219, \u9700\u8981\u518d\u6b21\u63d0\u4ea4: [{}]", (Object)e.getMessage());
            rtnResult.setRtnMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u8003\u52e4\u89c4\u5219\u4e0e\u4eba\u5458\u5173\u7cfb\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/attendance/attendanceStatistics/index.do"})
    public String index2(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            Calendar c = Calendar.getInstance();
            c.add(2, 0);
            c.set(5, 1);
            String fromDate = Util.getDate((String)"yyyy-MM-dd", (Date)c.getTime());
            String toDate = Util.getDate((String)"yyyy-MM-dd", (Date)new Date());
            map.put((Object)"fromDate", (Object)fromDate);
            map.put((Object)"toDate", (Object)toDate);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/attendance/attendanceStatistics/queryAttendanceSumaryDailyList.do"})
    public void queryAttendanceSumaryDailyList(HttpServletResponse response, String status, String startDate, String endDate, String personId) {
        HashMap<String, Serializable> mapBean = new HashMap<String, Serializable>(8);
        try {
            List<Object> list = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)status)) {
                AttendanceSumaryDailyBean attendanceSumaryDailyBean = new AttendanceSumaryDailyBean();
                attendanceSumaryDailyBean.setAbsentDay(Float.valueOf(1.0f));
                attendanceSumaryDailyBean.setStartTime(startDate);
                attendanceSumaryDailyBean.setEndTime(endDate);
                attendanceSumaryDailyBean.setPersonId(personId);
                list = this.attendanceService.queryAttendanceSumaryDailyList(attendanceSumaryDailyBean, new Page(1, Integer.MAX_VALUE));
            }
            mapBean.put("total", Integer.valueOf(list.size()));
            mapBean.put("rows", (Serializable)((Object)list));
            log.debug(Util.toJsonStr(mapBean));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u5730\u70b9\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/attendance/attendanceStatistics/queryAttendanceTotalList.do"})
    public void queryAttendanceTotalList(HttpServletResponse response, AttendanceSumaryDailyBean attendanceSumaryDailyBean, String ids) {
        if (this.validateArgs(attendanceSumaryDailyBean.getStartTime(), attendanceSumaryDailyBean.getEndTime())) {
            this.returnEmptyBean(response);
            return;
        }
        HashMap<String, Serializable> mapBean = new HashMap<String, Serializable>(10);
        try {
            String[] aryId;
            int rows;
            int pageNum;
            try {
                pageNum = Integer.parseInt(attendanceSumaryDailyBean.getPage());
                rows = Integer.parseInt(attendanceSumaryDailyBean.getRows());
            }
            catch (Exception e) {
                pageNum = 1;
                rows = 10;
            }
            Page page = new Page(pageNum, rows);
            Department dept = this.person.getDepartment();
            String deptId = dept.getId();
            String parentId = this.getDeptIdByAdmin();
            attendanceSumaryDailyBean.setDeptId(null != parentId ? parentId : deptId);
            ArrayList<AttendanceSumaryBean> totalListResult = new ArrayList<AttendanceSumaryBean>();
            if (StringUtils.isNotBlank((CharSequence)ids) && (aryId = ids.split(",")).length > 0) {
                List<String> personIds2 = Arrays.asList(aryId);
                ArrayList<String> personIds = new ArrayList<String>(personIds2);
                attendanceSumaryDailyBean.setPersonIds(personIds);
                List<AttendanceSumaryDailyPageBean> totalList = this.attendanceService.queryAttendanceSumaryTotalPageList(attendanceSumaryDailyBean, page);
                if (null != totalList) {
                    for (AttendanceSumaryDailyPageBean pageBean : totalList) {
                        String key = pageBean.getPersonId();
                        personIds.remove(key);
                    }
                    if (personIds.size() > 0) {
                        this.addNoAttendancePerson(totalList, personIds);
                    }
                    for (AttendanceSumaryDailyPageBean sumary : totalList) {
                        String day = "";
                        day = this.computeWorkDays(sumary, day);
                        AttendanceSumaryBean summaryBean = new AttendanceSumaryBean(sumary.getPersonId(), sumary.getCode(), sumary.getName(), sumary.getDeptName(), day, sumary.getBeLateNum() + "", sumary.getLeaveEarlyNum() + "", sumary.getAbsentDay() + "", sumary.getAbsentNum() + "", sumary.getFlag(), sumary.getLeaveDay() + "", sumary.getEvectionDay() + "", sumary.getWeekendDay());
                        totalListResult.add(summaryBean);
                    }
                }
            }
            int total = totalListResult.size();
            List pageTotalList = new ArrayList();
            if (total > 0) {
                int fromIndex = (pageNum - 1) * rows;
                int toIndex = pageNum * rows > total ? total : pageNum * rows;
                pageTotalList = totalListResult.subList(fromIndex, toIndex);
            }
            mapBean.put("total", Integer.valueOf(total));
            mapBean.put("rows", (Serializable)((Object)pageTotalList));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u6c47\u603b\u7edf\u8ba1\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    private boolean validateArgs(String startTime, String endTime) {
        if (StringUtils.isEmpty((CharSequence)startTime) || StringUtils.isEmpty((CharSequence)endTime)) {
            return true;
        }
        Integer twoDayInterval = DateUtil.getTwoDayInterval(endTime, startTime);
        int queryMaxInterval = 31;
        int oneYear = 365;
        String oneYearAgoDate = DateUtil.getStrDate(oneYear + "");
        Integer dayIntervalYear = DateUtil.getTwoDayInterval(oneYearAgoDate, startTime);
        return twoDayInterval > queryMaxInterval || dayIntervalYear > 0;
    }

    private void addNoAttendancePerson(List<AttendanceSumaryDailyPageBean> totalList, List<String> noAttendancePerson) {
        List<Person> personIds2 = this.userManageService.queryPersonByPersonIds(noAttendancePerson);
        if (null != personIds2 && personIds2.size() > 0) {
            for (Person person : personIds2) {
                AttendanceSumaryDailyPageBean pageBean = new AttendanceSumaryDailyPageBean();
                if (null == person) continue;
                pageBean.setFlag("0");
                pageBean.setActualDay("");
                pageBean.setName(person.getName());
                pageBean.setCode(person.getCode());
                pageBean.setDeptName(person.getDepartment().getName());
                totalList.add(pageBean);
            }
        }
    }

    @RequestMapping(value={"/attendance/attendanceStatistics/queryAttendanceDetailPageList.do"})
    public void queryAttendanceDetailPageList(HttpServletResponse response, AttendanceDetailDailyBean detailDailyBean, String ids) {
        if (this.validateArgs(detailDailyBean.getStartTime(), detailDailyBean.getEndTime())) {
            this.returnEmptyBean(response);
            return;
        }
        HashMap<String, Serializable> mapBean = new HashMap<String, Serializable>(10);
        try {
            String[] aryId;
            int rows;
            int pageNum;
            try {
                pageNum = Integer.parseInt(detailDailyBean.getPage());
                rows = Integer.parseInt(detailDailyBean.getRows());
            }
            catch (Exception e) {
                pageNum = 1;
                rows = 100;
            }
            Page page = new Page(pageNum, rows);
            Department dept = this.person.getDepartment();
            String deptId = dept.getId();
            String parentId = this.getDeptIdByAdmin();
            detailDailyBean.setDeptId(null != parentId ? parentId : deptId);
            List<Object> result = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)ids) && (aryId = ids.split(",")).length > 0) {
                detailDailyBean.setPersonIds(Arrays.asList(aryId));
                List<AttendanceDetailDailyPageBean> detailList = this.attendanceService.queryAttendanceDetailPageList(detailDailyBean, page);
                result = this.getPageDetailList(detailList);
            }
            mapBean.put("total", Integer.valueOf(page.getTotal()));
            mapBean.put("rows", (Serializable)((Object)result));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u660e\u7ec6\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/attendance/attendanceStatistics/queryAttendanceClockInRecordPageList.do"})
    public void queryAttendanceClockInRecordPageList(HttpServletResponse response, AttendanceDetailDailyBean detailDailyBean, String ids) {
        if (this.validateArgs(detailDailyBean.getStartTime(), detailDailyBean.getEndTime())) {
            this.returnEmptyBean(response);
            return;
        }
        HashMap<String, Serializable> mapBean = new HashMap<String, Serializable>(10);
        try {
            String[] aryId;
            int rows;
            int pageNum;
            try {
                pageNum = Integer.parseInt(detailDailyBean.getPage());
                rows = Integer.parseInt(detailDailyBean.getRows());
            }
            catch (Exception e) {
                pageNum = 1;
                rows = 100;
            }
            Page page = new Page(pageNum, rows);
            Department dept = this.person.getDepartment();
            String deptId = dept.getId();
            String parentId = this.getDeptIdByAdmin();
            detailDailyBean.setDeptId(null != parentId ? parentId : deptId);
            List<Object> detailList = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)ids) && (aryId = ids.split(",")).length > 0) {
                detailDailyBean.setPersonIds(Arrays.asList(aryId));
                detailList = this.attendanceService.queryAttendanceClockInRecordPageList(detailDailyBean, page);
            }
            mapBean.put("total", Integer.valueOf(page.getTotal()));
            mapBean.put("rows", (Serializable)((Object)detailList));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u51fa\u5dee\u6253\u5361\u8bb0\u5f55\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/attendance/attendanceStatistics/toAttendanceStatisticsDetailForm2.do"})
    public String toAttendanceStatisticsDetailForm(HttpServletRequest request, HttpServletResponse response, ModelMap map, String status, String personId, AttendanceSumaryDailyBean attendanceSumaryDailyBean) {
        String sendUrl = "error/error";
        try {
            map.put((Object)"startTime", (Object)attendanceSumaryDailyBean.getStartTime());
            map.put((Object)"endTime", (Object)attendanceSumaryDailyBean.getEndTime());
            map.put((Object)"status", (Object)attendanceSumaryDailyBean.getStatus());
            map.put((Object)"personId", (Object)attendanceSumaryDailyBean.getPersonId());
            sendUrl = "attendance/attendanceStatistics/default/toAttendanceStatisticsDetailForm2";
            if ("0".equals(status)) {
                sendUrl = "attendance/attendanceStatistics/default/toAttendanceStatisticsDetailForm";
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/attendance/attendanceStatistics/queryAttendanceErrorDataList.do"})
    public void queryAttendanceErrorDataList(HttpServletRequest request, HttpServletResponse response, ModelMap map, AttendanceClockBean attendanceClockBean) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(10);
        try {
            int rows;
            int pageNum = 1;
            try {
                pageNum = Integer.parseInt(attendanceClockBean.getPage());
                rows = Integer.parseInt(attendanceClockBean.getRows());
            }
            catch (Exception e) {
                pageNum = 1;
                rows = Integer.MAX_VALUE;
            }
            Page page = new Page(pageNum, rows);
            List<AttendanceClockBean> list = this.attendanceService.queryAttendanceErrorDataList(attendanceClockBean, page);
            if (null == list) {
                list = new ArrayList<AttendanceClockBean>();
            }
            mapBean.put("total", list.size());
            mapBean.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u5f02\u5e38\u660e\u7ec6\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/attendance/attendanceStatistics/updateAttendanceClock.do"})
    public void updateAttendanceClock(ModelMap map, HttpServletRequest request, HttpServletResponse response, AttendanceClockBean attendanceClockBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            attendanceClockBean.setPersonId(this.person.getId());
            attendanceClockBean.setStatus("1");
            this.attendanceService.updateAttendanceClock(attendanceClockBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("\u4fee\u6539\u6253\u5361\u72b6\u6001\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u6253\u5361\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/attendance/attendanceStatistics/exportExcel.do"})
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, String ids, String startDate, String endDate) {
        HSSFWorkbook wb = new HSSFWorkbook();
        CellStyle titleCellStyle = AttendanceControl.createTitleCellStyle(wb);
        CellStyle headCellStyle = AttendanceControl.createHeadCellStyle(wb);
        CellStyle normalCellStyle = AttendanceControl.createNormalCellStyle(wb);
        CellStyle cellStyle0 = this.createCellStyleByStatus(wb, "0");
        CellStyle cellStyle1 = this.createCellStyleByStatus(wb, "1");
        CellStyle cellStyle2 = this.createCellStyleByStatus(wb, "2");
        CellStyle cellStyle3 = this.createCellStyleByStatus(wb, "3");
        CellStyle cellStyle4 = this.createCellStyleByStatus(wb, "4");
        CellStyle cellStyle5 = this.createCellStyleByStatus(wb, "5");
        CellStyle cellStyle6 = this.createCellStyleByStatus(wb, "6");
        String sj = "(" + startDate.replaceAll("-", ".") + "-" + endDate.replaceAll("-", ".") + ")";
        List<AttendanceSumaryDailyPageBean> totalList = null;
        List<AttendanceDetailDailyPageBean> dailyList = null;
        List<PersonDepBean> personList = this.userManageService.queryAllPersonInfo();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String[] aryId = ids.split(",");
            List<String> personIds2 = Arrays.asList(aryId);
            ArrayList<String> personIds = new ArrayList<String>(personIds2);
            ArrayList<String> personIdsDetail = new ArrayList<String>(personIds2);
            Department dept = this.person.getDepartment();
            String deptId = dept.getId();
            String parentId = this.getDeptIdByAdmin();
            String depId = null != parentId ? parentId : deptId;
            AttendanceSumaryDailyBean attendanceSumaryDailyBean = new AttendanceSumaryDailyBean();
            attendanceSumaryDailyBean.setStartTime(startDate);
            attendanceSumaryDailyBean.setEndTime(endDate);
            attendanceSumaryDailyBean.setPersonIds(personIds);
            attendanceSumaryDailyBean.setDeptId(depId);
            totalList = this.attendanceService.queryAttendanceSumaryTotalPageListExportOnly(attendanceSumaryDailyBean, new Page(1, Integer.MAX_VALUE), personList);
            if (null != totalList && totalList.size() > 0) {
                for (AttendanceSumaryDailyPageBean pageBean : totalList) {
                    String key = pageBean.getPersonId();
                    personIds.remove(key);
                }
                if (personIds.size() > 0) {
                    this.addNoAttendancePerson(totalList, personIds);
                }
            }
            AttendanceDetailDailyBean attendanceDetailDailyBean = new AttendanceDetailDailyBean();
            attendanceDetailDailyBean.setStartTime(startDate);
            attendanceDetailDailyBean.setEndTime(endDate);
            attendanceDetailDailyBean.setPersonIds(personIdsDetail);
            attendanceDetailDailyBean.setDeptId(depId);
            dailyList = this.attendanceService.queryAttendanceDetailPageListExportOnly(attendanceDetailDailyBean, new Page(1, Integer.MAX_VALUE), personList);
        }
        assert (totalList != null);
        this.generateAttendanceSummary(wb, titleCellStyle, headCellStyle, normalCellStyle, sj, totalList);
        String[] aryDetailTitle = new String[]{"\u5de5\u53f7", "\u59d3\u540d", "\u90e8\u95e8", "\u65e5\u671f", "\u8003\u52e4\u65f6\u95f4", "\u8bf7\u5047", "\u51fa\u5dee", "\u6253\u5361\u65f6\u95f41", "\u72b6\u60011", "\u8003\u52e4\u5907\u6ce81", "\u6253\u5361\u65f6\u95f42", "\u72b6\u60012", "\u8003\u52e4\u5907\u6ce82", "\u6253\u5361\u65f6\u95f43", "\u72b6\u60013", "\u6253\u5361\u65f6\u95f44", "\u72b6\u60014"};
        String sheetName = "\u8003\u52e4\u660e\u7ec6\u8868" + sj;
        HSSFSheet sheet = wb.createSheet(sheetName);
        sheet.createFreezePane(0, 2);
        int rowIndex = 0;
        int columnIndex = 0;
        HSSFRow row = sheet.createRow(rowIndex);
        ++rowIndex;
        CellRangeAddress cra = new CellRangeAddress(0, 0, 0, aryDetailTitle.length - 1);
        sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)cra);
        row.setHeightInPoints(31.0f);
        HSSFCell cell = row.createCell(columnIndex);
        cell.setCellValue(sheetName);
        cell.setCellStyle(titleCellStyle);
        row = sheet.createRow(rowIndex);
        ++rowIndex;
        this.setCell(headCellStyle, aryDetailTitle, columnIndex, row);
        List<AttendanceDetailBean> detailList2 = this.getPageDetailList(dailyList);
        for (int k = 0; null != detailList2 && k < detailList2.size(); ++k) {
            columnIndex = 0;
            AttendanceDetailBean detail = detailList2.get(k);
            row = sheet.createRow(rowIndex);
            ++rowIndex;
            Object[] aryData = new Object[]{detail.getCode(), detail.getName(), detail.getDeptName(), detail.getDailyDate(), detail.getTime(), detail.getLeaveDay(), detail.getEvectionDay(), detail.getClockInTime1(), detail.getClockInStatus1(), detail.getClockInNote1(), detail.getClockOutTime1(), detail.getClockOutStatus1(), detail.getClockOutNote1(), detail.getClockInTime2(), detail.getClockInStatus2(), detail.getClockOutTime2(), detail.getClockOutStatus2()};
            for (int j = 0; j < aryDetailTitle.length; ++j) {
                String value = null == aryData[j] ? "" : aryData[j].toString();
                cell = row.createCell(columnIndex);
                value = this.getAttendanceTypeName(normalCellStyle, cellStyle0, cellStyle1, cellStyle2, cellStyle3, cellStyle4, cellStyle5, cellStyle6, cell, j, value);
                cell.setCellValue(value);
                ++columnIndex;
            }
            sheet.setColumnWidth(0, 3840);
            sheet.setColumnWidth(1, 3072);
            sheet.setColumnWidth(2, 3840);
            sheet.setColumnWidth(3, 3840);
            sheet.setColumnWidth(4, 7680);
            sheet.setColumnWidth(5, 4608);
            sheet.setColumnWidth(7, 4608);
            sheet.setColumnWidth(9, 4608);
        }
        String[] aryStartTime = startDate.split("-");
        String[] aryEndTime = endDate.split("-");
        String yearStart = aryStartTime[0];
        String monthStart = aryStartTime[1];
        String dayStart = aryStartTime[2];
        String yearEnd = aryEndTime[0];
        String monthEnd = aryEndTime[1];
        String dayEnd = aryEndTime[2];
        ArrayList<String> listDate = new ArrayList<String>();
        HashMap<String, String> mapWeek = new HashMap<String, String>(100);
        if (Integer.parseInt(yearStart) <= Integer.parseInt(yearEnd)) {
            if (Integer.parseInt(yearStart) == Integer.parseInt(yearEnd)) {
                if (Integer.parseInt(monthStart) == Integer.parseInt(monthEnd)) {
                    for (int i = Integer.parseInt(dayStart); i <= Integer.parseInt(dayEnd); ++i) {
                        String rq = yearStart + "-" + monthStart + "-" + (i < 10 ? "0" + i : Integer.valueOf(i));
                        mapWeek.put(rq, this.getWeekOfDate(rq));
                        listDate.add(rq);
                    }
                } else {
                    this.addListDate(yearStart, monthStart, dayStart, mapWeek, listDate);
                    Calendar cal2 = Calendar.getInstance();
                    this.setCalendar(cal2, yearStart, monthEnd);
                    this.addListDate2(cal2, yearStart, monthEnd, mapWeek, listDate);
                }
            } else {
                this.addListDate(yearStart, monthStart, dayStart, mapWeek, listDate);
                Calendar cal2 = Calendar.getInstance();
                this.setCalendar(cal2, yearEnd, monthEnd);
                this.addListDate2(cal2, yearStart, monthEnd, mapWeek, listDate);
            }
        }
        ArrayList<String> listTitle = new ArrayList<String>();
        listTitle.add("\u5de5\u53f7");
        listTitle.add("\u59d3\u540d");
        listTitle.add("\u5e94\u5230\n(\u5929)");
        listTitle.add("\u5b9e\u5230\n(\u5929)");
        listTitle.add("\u65f7\u5de5\n(\u5929)");
        listTitle.add("\u8fdf\u5230\n(\u5206\u949f)");
        listTitle.add("\u8bf7\u5047\n(\u5929)");
        listTitle.add("\u51fa\u5dee\n(\u5929)");
        if (listDate.size() > 0) {
            for (String rq : listDate) {
                String[] split = rq.split("-");
                listTitle.add(Integer.parseInt(split[1]) + "." + split[2] + "\n" + (String)mapWeek.get(rq));
            }
        }
        int size = null != dailyList ? dailyList.size() : 0;
        HashMap map = new HashMap(size);
        ArrayList<String> listP = new ArrayList<String>();
        if (null != dailyList && dailyList.size() > 0) {
            for (AttendanceDetailDailyPageBean attendanceDetailDailyPageBean : dailyList) {
                List<AttendanceDetailDailyPageBean> list;
                String personId = attendanceDetailDailyPageBean.getPersonId();
                if (map.containsKey(personId)) {
                    list = (List)map.get(personId);
                } else {
                    list = new ArrayList();
                    listP.add(personId);
                }
                list.add(attendanceDetailDailyPageBean);
                map.put(personId, list);
            }
        }
        ArrayList dataList = new ArrayList();
        if (listP.size() > 0) {
            for (String string : listP) {
                List list = (List)map.get(string);
                PersonDepBean person2 = null;
                for (PersonDepBean personDepBean : personList) {
                    if (!personDepBean.getID().equals(string)) continue;
                    person2 = personDepBean;
                    break;
                }
                if (null == person2) continue;
                HashMap<String, Object> map1 = new HashMap<String, Object>(64);
                ArrayList<String> listRq = new ArrayList<String>(8);
                map1.put("code", person2.getCODE());
                map1.put("name", person2.getNAME());
                float ydDay = 0.0f;
                float cdDay = 0.0f;
                float leaveDay = 0.0f;
                float evectionDay = 0.0f;
                if (listDate.size() > 0) {
                    for (String rq : listDate) {
                        StringBuilder tmp = new StringBuilder();
                        AttendanceDetailDailyPageBean data = this.getPersonData(rq, list);
                        if (null != data) {
                            String[] split;
                            String time;
                            ydDay += 1.0f;
                            String clockInStatus1 = data.getClockInStatus1();
                            String clockInStatus2 = data.getClockOutStatus1();
                            if (clockInStatus1 != null) {
                                switch (clockInStatus1) {
                                    case "0": {
                                        tmp.append("\u65f7");
                                        break;
                                    }
                                    case "2": {
                                        time = data.getClockInTime1();
                                        split = time.split(" ")[1].split(":");
                                        tmp.append(split[0]).append(":").append(split[1]);
                                        String startTime1 = data.getStartTime1();
                                        cdDay += (float)this.computerTime(time, startTime1);
                                        break;
                                    }
                                    case "5": {
                                        tmp.append("\u5047");
                                        leaveDay += data.getClockInTime1().equals(data.getStartTime1()) && data.getClockOutTime1().equals(data.getEndTime1()) ? 1.0f : 0.5f;
                                        break;
                                    }
                                    case "6": {
                                        tmp.append("\u5dee");
                                        evectionDay += 1.0f;
                                        break;
                                    }
                                    case "-1": {
                                        if (!StringUtils.isNotEmpty((CharSequence)data.getClockInTime1())) break;
                                        tmp.append("\u73ed");
                                        break;
                                    }
                                }
                                tmp.append("\n");
                            }
                            switch (clockInStatus2) {
                                case "0": {
                                    tmp.append("\u65f7");
                                    break;
                                }
                                case "2": {
                                    time = data.getClockInTime2();
                                    split = time.split(" ")[1].split(":");
                                    tmp.append(split[0]).append(":").append(split[1]);
                                    String startTime2 = data.getStartTime2();
                                    cdDay += (float)this.computerTime(time, startTime2);
                                    break;
                                }
                                case "-1": {
                                    if (!StringUtils.isNotEmpty((CharSequence)data.getClockOutTime1())) break;
                                    tmp.append("\u73ed");
                                    break;
                                }
                            }
                        }
                        listRq.add(tmp.toString());
                    }
                }
                AttendanceSumaryDailyPageBean attendanceSumaryDailyPageBean = new AttendanceSumaryDailyPageBean();
                for (AttendanceSumaryDailyPageBean sumary : totalList) {
                    if (!string.equals(sumary.getPersonId())) continue;
                    attendanceSumaryDailyPageBean = sumary;
                    break;
                }
                String day = "";
                day = this.computeWorkDays(attendanceSumaryDailyPageBean, day);
                map1.put("ydDay", Float.valueOf(ydDay));
                map1.put("sdDay", day);
                map1.put("kgDay", attendanceSumaryDailyPageBean.getAbsentDay());
                map1.put("cdDay", Float.valueOf(cdDay));
                map1.put("leaveDay", Float.valueOf(leaveDay));
                map1.put("evectionDay", Float.valueOf(evectionDay));
                map1.put("listRq", listRq);
                dataList.add(map1);
            }
        }
        sheetName = "\u8003\u52e4\u8868" + sj;
        sheet = wb.createSheet(sheetName);
        sheet.createFreezePane(0, 2);
        rowIndex = 0;
        columnIndex = 0;
        row = sheet.createRow(rowIndex);
        ++rowIndex;
        cra = new CellRangeAddress(0, 0, 0, listTitle.size() - 1);
        sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)cra);
        row.setHeightInPoints(31.0f);
        cell = row.createCell(columnIndex);
        cell.setCellValue(sheetName);
        cell.setCellStyle(titleCellStyle);
        row = sheet.createRow(rowIndex);
        row.setHeightInPoints(31.0f);
        ++rowIndex;
        headCellStyle = this.createNormalCellStyle2(wb);
        normalCellStyle = this.createNormalCellStyle2(wb);
        for (String string : listTitle) {
            cell = row.createCell(columnIndex);
            ++columnIndex;
            cell.setCellValue(string);
            cell.setCellStyle(headCellStyle);
        }
        for (Map map2 : dataList) {
            row = sheet.createRow(rowIndex);
            row.setHeightInPoints(31.0f);
            ++rowIndex;
            columnIndex = 0;
            cell = row.createCell(columnIndex);
            cell.setCellStyle(normalCellStyle);
            cell.setCellValue(map2.get("code").toString());
            cell = row.createCell(++columnIndex);
            cell.setCellStyle(normalCellStyle);
            cell.setCellValue(map2.get("name").toString());
            cell = row.createCell(++columnIndex);
            cell.setCellStyle(normalCellStyle);
            cell.setCellValue(map2.get("ydDay").toString());
            cell = row.createCell(++columnIndex);
            cell.setCellStyle(normalCellStyle);
            cell.setCellValue(map2.get("sdDay").toString());
            cell = row.createCell(++columnIndex);
            cell.setCellStyle(normalCellStyle);
            cell.setCellValue(map2.get("kgDay").toString());
            cell = row.createCell(++columnIndex);
            cell.setCellStyle(normalCellStyle);
            cell.setCellValue(map2.get("cdDay").toString());
            cell = row.createCell(++columnIndex);
            cell.setCellStyle(normalCellStyle);
            cell.setCellValue(map2.get("leaveDay").toString());
            cell = row.createCell(++columnIndex);
            cell.setCellStyle(normalCellStyle);
            cell.setCellValue(map2.get("evectionDay").toString());
            ++columnIndex;
            List listRq = (List)map2.get("listRq");
            for (int i = 0; i < listDate.size(); ++i) {
                cell = row.createCell(columnIndex);
                cell.setCellStyle(normalCellStyle);
                cell.setCellValue((String)listRq.get(i));
                ++columnIndex;
            }
        }
        row = sheet.createRow(++rowIndex);
        cra = new CellRangeAddress(rowIndex, rowIndex, 0, listTitle.size() - 1);
        sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)cra);
        cell = row.createCell(0);
        cell.setCellValue("\u5907\u6ce8\uff1a\u6b63\u5e38-\u201c\u201d\uff0c\u65f7\u5de5-\u201c\u65f7\u201d\uff0c\u8fdf\u5230-\u663e\u793a\u6253\u5361\u65f6\u95f4\uff0c\u8bf7\u5047-\u201c\u5047\u201d\uff0c\u51fa\u5dee-\u201c\u5dee\u201d\uff0c\u52a0\u73ed-\u201c\u73ed\u201d");
        sheet.setColumnWidth(0, 3840);
        String fileName = "\u8003\u52e4\u62a5\u8868" + sj;
        try {
            fileName = new String(fileName.getBytes("gbk"), "iso_8859_1") + ".xls";
        }
        catch (Exception exception) {
            fileName = sj + ".xls";
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        try {
            ServletOutputStream servletOutputStream = response.getOutputStream();
            servletOutputStream.flush();
            wb.write((OutputStream)servletOutputStream);
            log.debug("----Excle\u6587\u4ef6\u5df2\u751f\u6210------");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getAttendanceTypeName(CellStyle normalCellStyle, CellStyle cellStyle0, CellStyle cellStyle1, CellStyle cellStyle2, CellStyle cellStyle3, CellStyle cellStyle4, CellStyle cellStyle5, CellStyle cellStyle6, HSSFCell cell, int j, String value) {
        int status1 = 8;
        int status2 = 11;
        if (j == status1 || j == status2) {
            if ("0".equals(value)) {
                cell.setCellStyle(cellStyle0);
                value = "\u7f3a\u5361";
            } else if ("1".equals(value)) {
                cell.setCellStyle(cellStyle1);
                value = "\u6b63\u5e38";
            } else if ("2".equals(value)) {
                cell.setCellStyle(cellStyle2);
                value = "\u8fdf\u5230";
            } else if ("3".equals(value)) {
                cell.setCellStyle(cellStyle3);
                value = "\u65e9\u9000";
            } else if ("4".equals(value)) {
                cell.setCellStyle(cellStyle4);
                value = "\u5916\u52e4";
            } else if ("5".equals(value)) {
                cell.setCellStyle(cellStyle5);
                value = "\u8bf7\u5047";
            } else if ("6".equals(value)) {
                cell.setCellStyle(cellStyle6);
                value = "\u51fa\u5dee";
            } else if ("-1".equals(value)) {
                cell.setCellStyle(cellStyle1);
                value = "\u52a0\u73ed";
            } else {
                cell.setCellStyle(normalCellStyle);
                value = "";
            }
        } else {
            cell.setCellStyle(normalCellStyle);
        }
        return value;
    }

    private void generateAttendanceSummary(HSSFWorkbook wb, CellStyle titleCellStyle, CellStyle headCellStyle, CellStyle normalCellStyle, String sj, List<AttendanceSumaryDailyPageBean> totalList) {
        String[] aryTitle = new String[]{"\u5de5\u53f7", "\u59d3\u540d", "\u90e8\u95e8", "\u51fa\u52e4\u5929\u6570", "\u8bf7\u5047\u5929\u6570", "\u51fa\u5dee\u5929\u6570", "\u5468\u672b\u52a0\u73ed", "\u8fdf\u5230(\u6b21)", "\u65e9\u9000(\u6b21)", "\u65f7\u5de5(\u5929)", "\u7f3a\u5361(\u6b21)"};
        String sheetName = "\u8003\u52e4\u6c47\u603b\u8868" + sj;
        HSSFSheet sheet = wb.createSheet(sheetName);
        sheet.createFreezePane(0, 2);
        int rowIndex = 0;
        int columnIndex = 0;
        HSSFRow row = sheet.createRow(rowIndex);
        ++rowIndex;
        CellRangeAddress cra = new CellRangeAddress(0, 0, 0, aryTitle.length - 1);
        sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)cra);
        row.setHeightInPoints(31.0f);
        HSSFCell cell = row.createCell(columnIndex);
        cell.setCellValue(sheetName);
        cell.setCellStyle(titleCellStyle);
        row = sheet.createRow(rowIndex);
        ++rowIndex;
        this.setCell(headCellStyle, aryTitle, columnIndex, row);
        assert (totalList != null);
        for (AttendanceSumaryDailyPageBean sumary : totalList) {
            row = sheet.createRow(rowIndex);
            columnIndex = 0;
            ++rowIndex;
            String day = "";
            day = this.computeWorkDays(sumary, day);
            Object[] aryData = new Object[]{sumary.getCode(), sumary.getName(), sumary.getDeptName(), day, sumary.getLeaveDay(), sumary.getEvectionDay(), sumary.getWeekendDay(), sumary.getBeLateNum(), sumary.getLeaveEarlyNum(), sumary.getAbsentDay(), sumary.getAbsentNum()};
            for (int j = 0; j < aryTitle.length; ++j) {
                cell = row.createCell(columnIndex);
                cell.setCellValue(null == aryData[j] ? "" : aryData[j].toString());
                cell.setCellStyle(normalCellStyle);
                ++columnIndex;
            }
            sheet.setColumnWidth(0, 3840);
            sheet.setColumnWidth(1, 3072);
            sheet.setColumnWidth(2, 3840);
        }
    }

    private String computeWorkDays(AttendanceSumaryDailyPageBean sumary, String day) {
        if (!"0".equals(sumary.getFlag()) && StringUtils.isNotBlank((CharSequence)sumary.getActualDay())) {
            day = Float.parseFloat(sumary.getActualDay()) - (null == sumary.getAbsentDay() ? 0.0f : sumary.getAbsentDay().floatValue()) + "";
            if (Float.parseFloat(day = Float.parseFloat(day) - (null == sumary.getLeaveDay() ? 0.0f : sumary.getLeaveDay().floatValue()) + "") < 0.0f) {
                day = "0";
            }
        }
        return day;
    }

    private void addListDate(String yearStart, String monthStart, String dayStart, Map<String, String> mapWeek, List<String> listDate) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(yearStart));
        cal.set(2, Integer.parseInt(monthStart));
        cal.set(5, 1);
        cal.add(5, -1);
        int actualMaximum = cal.getActualMaximum(5);
        for (int i = Integer.parseInt(dayStart); i <= actualMaximum; ++i) {
            String rq = yearStart + "-" + monthStart + "-" + (i < 10 ? "0" + i : Integer.valueOf(i));
            mapWeek.put(rq, this.getWeekOfDate(rq));
            listDate.add(rq);
        }
    }

    private void addListDate2(Calendar cal2, String yearStart, String monthEnd, Map<String, String> mapWeek, List<String> listDate) {
        int actualMaximum2 = cal2.getActualMaximum(5);
        for (int i = 1; i <= actualMaximum2; ++i) {
            String rq = yearStart + "-" + monthEnd + "-" + (i < 10 ? "0" + i : Integer.valueOf(i));
            mapWeek.put(rq, this.getWeekOfDate(rq));
            listDate.add(rq);
        }
    }

    private void setCalendar(Calendar cal2, String year, String monthEnd) {
        cal2.set(1, Integer.parseInt(year));
        cal2.set(2, Integer.parseInt(monthEnd));
        cal2.set(5, 1);
        cal2.add(5, -1);
    }

    private void setCell(CellStyle headCellStyle, String[] aryTitle, int columnIndex, HSSFRow row) {
        for (String anAryTitle : aryTitle) {
            HSSFCell cell = row.createCell(columnIndex);
            ++columnIndex;
            cell.setCellValue(anAryTitle);
            cell.setCellStyle(headCellStyle);
        }
    }

    private AttendanceDetailDailyPageBean getPersonData(String day, List<AttendanceDetailDailyPageBean> list) {
        for (AttendanceDetailDailyPageBean bean : list) {
            if (!bean.getDailyDate().equals(day)) continue;
            return bean;
        }
        return null;
    }

    private long computerTime(String time1, String time2) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date1 = sdf.parse(time1);
            Date date2 = sdf.parse(time2);
            long seconds = (date1.getTime() - date2.getTime()) / 1000L;
            return seconds / 60L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private String getWeekOfDate(String dateStr) {
        try {
            Date date = Util.parseDate((String)dateStr);
            String[] weekDays = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int w = cal.get(7) - 1;
            if (w < 0) {
                w = 0;
            }
            return weekDays[w];
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u65e5\u671f\u83b7\u53d6\u661f\u671f\u51e0\u5931\u8d25");
            return "";
        }
    }

    private CellStyle createCellStyleByStatus(HSSFWorkbook wb, String status) {
        HSSFCellStyle normalCellStyle = wb.createCellStyle();
        normalCellStyle.setAlignment((short)2);
        normalCellStyle.setVerticalAlignment((short)1);
        normalCellStyle.setBorderBottom((short)1);
        normalCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderLeft((short)1);
        normalCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderRight((short)1);
        normalCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderTop((short)1);
        normalCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setWrapText(true);
        HSSFFont font = wb.createFont();
        if ("0".equals(status)) {
            font.setColor((short)16);
        } else if ("1".equals(status)) {
            font.setColor((short)17);
        } else if ("2".equals(status)) {
            font.setColor((short)10);
        } else if ("3".equals(status)) {
            font.setColor((short)10);
        } else if ("4".equals(status)) {
            font.setColor((short)17);
        } else if ("5".equals(status)) {
            font.setColor((short)17);
        } else if ("6".equals(status)) {
            font.setColor((short)17);
        }
        normalCellStyle.setFont((Font)font);
        return normalCellStyle;
    }

    private static CellStyle createTitleCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment((short)2);
        titleCellStyle.setVerticalAlignment((short)1);
        titleCellStyle.setBorderBottom((short)6);
        titleCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderLeft((short)1);
        titleCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderRight((short)1);
        titleCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderTop((short)1);
        titleCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        titleCellStyle.setFillPattern((short)1);
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)20);
        titleCellStyle.setFont((Font)font);
        return titleCellStyle;
    }

    private static CellStyle createHeadCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle headCellStyle = wb.createCellStyle();
        headCellStyle.setAlignment((short)2);
        headCellStyle.setVerticalAlignment((short)1);
        headCellStyle.setBorderBottom((short)2);
        headCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderLeft((short)1);
        headCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderRight((short)1);
        headCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderTop((short)1);
        headCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headCellStyle.setFillPattern((short)1);
        return headCellStyle;
    }

    private static CellStyle createNormalCellStyle(HSSFWorkbook wb) {
        return AttendanceControl.getNewNormalCellStyle(wb);
    }

    private static CellStyle getNewNormalCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle normalCellStyle = wb.createCellStyle();
        normalCellStyle.setAlignment((short)2);
        normalCellStyle.setVerticalAlignment((short)1);
        normalCellStyle.setBorderBottom((short)1);
        normalCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderLeft((short)1);
        normalCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderRight((short)1);
        normalCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderTop((short)1);
        normalCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setWrapText(true);
        return normalCellStyle;
    }

    private CellStyle createNormalCellStyle2(HSSFWorkbook wb) {
        return AttendanceControl.getNewNormalCellStyle(wb);
    }

    private List<AttendanceDetailBean> getPageDetailList(List<AttendanceDetailDailyPageBean> detailList) {
        ArrayList<AttendanceDetailBean> result = new ArrayList<AttendanceDetailBean>();
        if (detailList == null) {
            return result;
        }
        for (AttendanceDetailDailyPageBean detail : detailList) {
            String[] st;
            String time = "";
            String[] s1 = null;
            String startTime1 = detail.getStartTime1();
            if (StringUtils.isNotBlank((CharSequence)startTime1)) {
                st = startTime1.split(" ");
                s1 = st[1].split(":");
            }
            String endTime1 = detail.getEndTime1();
            String[] e1 = null;
            if (StringUtils.isNotBlank((CharSequence)endTime1)) {
                st = endTime1.split(" ");
                e1 = st[1].split(":");
            }
            String startTime2 = detail.getStartTime2();
            String[] s2 = null;
            if (StringUtils.isNotBlank((CharSequence)startTime2)) {
                st = startTime2.split(" ");
                s2 = st[1].split(":");
            }
            String endTime2 = detail.getEndTime2();
            String[] e2 = null;
            if (StringUtils.isNotBlank((CharSequence)endTime2)) {
                st = endTime2.split(" ");
                e2 = st[1].split(":");
            }
            String startTime3 = detail.getStartTime3();
            String[] s3 = null;
            if (StringUtils.isNotBlank((CharSequence)startTime3)) {
                st = startTime3.split(" ");
                s3 = st[1].split(":");
            }
            String endTime3 = detail.getEndTime3();
            String[] e3 = null;
            if (StringUtils.isNotBlank((CharSequence)endTime3)) {
                st = endTime3.split(" ");
                e3 = st[1].split(":");
            }
            time = this.getAttendanceTime(time, s1, startTime1, endTime1, e1, startTime2, s2, endTime2, e2, startTime3, s3, endTime3, e3);
            String c1 = "";
            c1 = this.getClockTime1(detail, c1);
            String c2 = "";
            c2 = this.getClockTime2(detail, c2);
            String c3 = "";
            c3 = this.getClockTime3(detail, c3);
            String c4 = "";
            c4 = this.getClockTime4(detail, c4);
            String leaveStatus = "5";
            String evectionStatus = "6";
            String halfDay = "0.5";
            String oneDay = "1";
            String leaveDay = "";
            String evectionDay = "";
            if (leaveStatus.equals(detail.getClockInStatus1()) || leaveStatus.equals(detail.getClockOutStatus1())) {
                String string = leaveDay = detail.getClockInTime1().equals(detail.getStartTime1()) && detail.getClockOutTime1().equals(detail.getEndTime1()) ? oneDay : halfDay;
            }
            if (evectionStatus.equals(detail.getClockInStatus1())) {
                evectionDay = oneDay;
            } else if (2 == detail.getDailyType()) {
                String weekendStatus = "-1";
                detail.setClockInStatus1(StringUtils.isNotEmpty((CharSequence)detail.getClockInTime1()) ? weekendStatus : "");
                detail.setClockOutStatus1(StringUtils.isNotEmpty((CharSequence)detail.getClockOutTime1()) ? weekendStatus : "");
            }
            AttendanceDetailBean bean = new AttendanceDetailBean(detail.getPersonId(), detail.getCode(), detail.getName(), detail.getDeptName(), detail.getDailyDate(), time, c1, detail.getClockInStatus1(), c2, detail.getClockOutStatus1(), detail.getClockInNote1(), detail.getClockOutNote1(), leaveDay, evectionDay, c3, detail.getClockInStatus2(), c4, detail.getClockOutStatus2(), detail.getFlag());
            result.add(bean);
        }
        return result;
    }

    private String getClockTime4(AttendanceDetailDailyPageBean detail, String c4) {
        if (!"0".equals(detail.getClockOutStatus2())) {
            String cc1 = detail.getClockOutTime2();
            if (StringUtils.isNotBlank((CharSequence)cc1)) {
                String[] st = cc1.split(" ");
                st = st[1].split(":");
                c4 = st[0] + ":" + st[1];
            }
        } else {
            detail.setClockOutTime2("");
        }
        return c4;
    }

    private String getClockTime3(AttendanceDetailDailyPageBean detail, String c3) {
        if (!"0".equals(detail.getClockInStatus2())) {
            String cc1 = detail.getClockInTime2();
            if (StringUtils.isNotBlank((CharSequence)cc1)) {
                String[] st = cc1.split(" ");
                st = st[1].split(":");
                c3 = st[0] + ":" + st[1];
            }
        } else {
            detail.setClockInTime2("");
        }
        return c3;
    }

    private String getClockTime2(AttendanceDetailDailyPageBean detail, String c2) {
        if (!"0".equals(detail.getClockOutStatus1())) {
            String cc1 = detail.getClockOutTime1();
            if (StringUtils.isNotBlank((CharSequence)cc1)) {
                String[] st = cc1.split(" ");
                st = st[1].split(":");
                c2 = st[0] + ":" + st[1];
            }
        } else {
            detail.setClockOutTime1("");
        }
        return c2;
    }

    private String getClockTime1(AttendanceDetailDailyPageBean detail, String c1) {
        if (!"0".equals(detail.getClockInStatus1())) {
            String cc1 = detail.getClockInTime1();
            if (StringUtils.isNotBlank((CharSequence)cc1)) {
                String[] st = cc1.split(" ");
                st = st[1].split(":");
                c1 = st[0] + ":" + st[1];
            }
        } else {
            detail.setClockInTime1("");
        }
        return c1;
    }

    private String getAttendanceTime(String time, String[] s1, String startTime1, String endTime1, String[] e1, String startTime2, String[] s2, String endTime2, String[] e2, String startTime3, String[] s3, String endTime3, String[] e3) {
        if (StringUtils.isNotBlank((CharSequence)startTime1) && StringUtils.isNotBlank((CharSequence)endTime1)) {
            time = time + s1[0] + ":" + s1[1] + '-' + e1[0] + ":" + e1[1] + " ";
        }
        if (StringUtils.isNotBlank((CharSequence)startTime2) && StringUtils.isNotBlank((CharSequence)endTime2)) {
            time = time + s2[0] + ":" + s2[1] + '-' + e2[0] + ":" + e2[1] + " ";
        }
        if (StringUtils.isNotBlank((CharSequence)startTime3) && StringUtils.isNotBlank((CharSequence)endTime3)) {
            time = time + s3[0] + ":" + s3[1] + '-' + e3[0] + ":" + e3[1] + " ";
        }
        return time;
    }

    private String getDeptIdByAdmin() {
        Person person = this.personDao.queryPersonById("0");
        return person != null ? person.getDepId() : "";
    }

    private void returnEmptyBean(HttpServletResponse response) {
        HashMap<String, Serializable> mapBean = new HashMap<String, Serializable>(10);
        mapBean.put("total", Integer.valueOf(0));
        mapBean.put("rows", new ArrayList());
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }
}

